﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/">
		<html>
			<xsl:apply-templates/>
		</html>
	</xsl:template>
	<xsl:template match="vdex">
		<head>
			<title>
				<xsl:apply-templates select="vocabName"/>
			</title>
		</head>
		<body>
			<h1>
				<xsl:apply-templates select="vocabName"/>
			</h1>
			
			<p>
				<strong>Editores[1]:</strong> Ministerio de Educación (Instituto Superior de Formación y Recursos en Red para el Profesorado. ISFTIC), Ministerio de Industria, Turismo y Comercio (Entidad Pública Empresarial red.es), Generalitat de Catalunya (Departament d'Educació i Universitats), Junta de Extremadura (Consejería de Educación) y Comunidad de Madrid (Consejería de Educación).
			</p>
			<p>	
				<strong>Autores[2]:</strong> Francisco Berrocal Román, Juan José Blanco Villalobos, María Teresa Bouza Álvarez,  Santiago Campo Moreno, Juan del Campo Vecino, Joan B. Canet Parrilla, José Miguel Casares del Río, Cristina Fuertes Royo, Antonio Galisteo del Valle, Manuel Gértrudix Barrio, Miguel Ángel Gómez Crespo, Alejandro González Prado, Manuel López,  Francisco López Blanco, América López de la Riva, José Antonio Moreno Santos,  María del Mar Paredes Maña, Noemí Peña Sánchez, Arturo de Porras Guardo, Felipe Retortillo Franco, María Jesús Rodríguez San Felipe, Enrique Rojo García, Adolfo Romero Montero, Jorge Sánchez Pedraza y Jordi Vivancos Martí.
			</p>
			<p>
				<strong>Integración:</strong> Antonio Galisteo del Valle (ISFTIC) y Antonio Sarasa Cabezuelo (red.es).
			</p>
			<p>
				<strong>Revisión y validación[3]:</strong> Antonio Galisteo del Valle (ISFTIC), Eva Mª Méndez Rodríguez (Universidad Carlos III), Laura Sanz Herrero (ISFTIC) y Antonio Sarasa Cabezuelo (red.es).
			</p>
			<p>
				<strong>[1]</strong> Este documento se ha desarrollado en el seno del Grupo de Trabajo 9 perteneciente al Subcomité 36 de Tecnologías de la Información y la Comunicación para el aprendizaje (SC36) de la Asociación Española de Normalización y Certificación (AENOR) al que pertenecen las Administraciones Públicas y Autonómicas que lo editan.
			</p>
			<p>
				<strong>[2] </strong>Ordenados por orden alfabético.
			</p>
			<p>
				<strong>[3]</strong> Para más información sobre el proceso de validación ver Apendice 1 del Anexo X de la Guía de aplicación de LOM-ES v1.0 en la Educación.
			</p>
			
			<br/>
			<h3><a name="inicio">Index</a><br/></h3>
			<ul>  
				<li><a href="#definiciones">Definitions</a><br/><br/></li>
				<li><a href="#tr">TR relationship</a><br/><br/></li>
				<li><a href="#te">TE relationship</a><br/><br/></li>
				<li><a href="#te0">TE0 relationship</a><br/><br/></li>
				<li><a href="#te1">TE1 relationship</a><br/><br/></li>
				<li><a href="#te2">TE2 relationship</a><br/><br/></li>
				<li><a href="#te3">TE3 relationship</a><br/><br/></li>
				<li><a href="#te4">TE4 relationship</a><br/><br/></li>
				<li><a href="#te5">TE5 relationship</a><br/><br/></li>
				<li><a href="#te6">TE6 relationship</a><br/><br/></li>
				<li><a href="#te7">TE7 relationship</a><br/><br/></li>
				<li><a href="#te8">TE8 relationship</a><br/><br/></li>
				<li><a href="#te9">TE9 relationship</a><br/><br/></li>
				<li><a href="#te10">TE10 relationship</a><br/><br/></li>
				<li><a href="#te11">TE11 relationship</a><br/><br/></li>
				<li><a href="#te12">TE12 relationship</a><br/><br/></li>
				<li><a href="#te13">TE13 relationship</a><br/><br/></li>
			</ul>
			
			<a name="definiciones"><h2 align="center">DEFINITIONS</h2></a> <a href="#inicio">Index</a><br/>
			<br/>
			<table border="1" cellspacing="0">
				<tbody>
					<tr bgcolor="red">
						<th align="center" height="20" width="100" >IDENTIFIER</th>
						<th align="center" height="20" width="1000" >TAXON</th>
					</tr>
					<xsl:for-each select="term">
					<!--<xsl:apply-templates select="termIdentifier"/>.- <xsl:apply-templates select="caption"/>-->	
						<tr>
							<th align="center" height="20" width="100" ><xsl:apply-templates select="termIdentifier"/></th>
							<th align="center" height="20" width="1000" ><xsl:apply-templates select="caption"/></th>
						</tr>
					</xsl:for-each>
				</tbody>
			</table>
				
			
			<a name="tr"><h2 align="center">TR ASSOCIATIVE RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TR</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te"><h2 align="center">TE  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te0"><h2 align="center">TE0  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE0</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te1"><h2 align="center">TE1  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE1</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te2"><h2 align="center">TE2  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE2</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te3"><h2 align="center">TE3  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE3</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te4"><h2 align="center">TE4  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE4</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te5"><h2 align="center">TE5  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE5</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te6"><h2 align="center">TE6  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE6</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te7"><h2 align="center">TE7  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE7</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te8"><h2 align="center">TE8  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE8</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te9"><h2 align="center">TE9  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE9</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te10"><h2 align="center">TE10  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE10</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te11"><h2 align="center">TE11  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE11</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te12"><h2 align="center">TE12  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE12</xsl:with-param>
			</xsl:call-template>
			<br/>
			<a name="te13"><h2 align="center">TE13  HIERARCHICAL RELATIONSHIP</h2></a><a href="#inicio">Index</a><br/>
			<br/>
			<xsl:call-template name="relaciones">
				<xsl:with-param name="tipoRelacion">TE13</xsl:with-param>
			</xsl:call-template>	
			<br/>
			
			<p><strong>[1]</strong> Este documento se ha desarrollado en el seno del Grupo de Trabajo 9 perteneciente al Subcomité 36 de Tecnologías de la Información y la Comunicación para el aprendizaje (SC36) de la Asociación Española de Normalización y Certificación (AENOR) al que pertenecen las Administraciones Públicas y Autonómicas que lo editan.</p>



			<p><strong>[2]</strong> Ordenados por orden alfabético.</p>



			<p><strong>[3]</strong> Para más información sobre el proceso de validación ver Apéndice 1 del Anexo X de LOM-ES v1.0.</p>
			
		</body>
	</xsl:template>

	<xsl:template match="vocabName">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="term"> 
       	<xsl:apply-templates/>
    </xsl:template>
		
	<xsl:template match="termIdentifier">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="caption">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="sourceTerm">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="targetTerm">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template name='relaciones'>
		<xsl:param name = "tipoRelacion"/>
		<table border="1" cellspacing="0">
			<tbody>
				<tr bgcolor="green">
					<th align="center" height="20" width="100" >ID </th>
					<th align="center" height="20" width="500" >SOURCE</th>
					<th align="center" height="20" width="100" >RELATIONSHIP</th>
					<th align="center" height="20" width="500" >TARGET</th>
					<th align="center" height="20" width="100" >ID </th>
				</tr>
				
					<xsl:for-each select="relationship">
						<xsl:variable name = "destino"><xsl:value-of select='targetTerm'/></xsl:variable>
						<xsl:variable name = "fuente"><xsl:value-of select='sourceTerm'/></xsl:variable>
						<xsl:if test="relationshipType = $tipoRelacion">
							<tr>
								<xsl:for-each select="../term">
								<xsl:choose>
									<xsl:when test='$fuente = termIdentifier'>
										<th height="20" width="100">									
											<xsl:value-of select='termIdentifier'/>
										</th>
										<th height="20" width="500">
											<xsl:value-of select='caption'/>
										</th>		
									</xsl:when>
								</xsl:choose>
								</xsl:for-each>		
									<th align="center" height="20" width="100">
										<xsl:value-of select='relationshipType'/>
									</th>
								<xsl:for-each select="../term">
									<xsl:if test='$destino = termIdentifier'>
										<th height="20" width="500">									
											<xsl:value-of select='caption'/>
										</th>
										<th height="20" width="100">									
											<xsl:value-of select='termIdentifier'/>
										</th>
									</xsl:if>
								</xsl:for-each>	
								
							</tr>
						</xsl:if>
					</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
</xsl:stylesheet>
