/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaException;

public class SchemaModel {
    private XSDSchema _xsdSchema;
    private Hashtable schemaTbl = new Hashtable();
    private Map nsMap;
    private Hashtable nsURI2PrfxMap = new Hashtable();
    private Hashtable elementDecTbl = new Hashtable();
    private static XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    private SchemaElement _root;
    private String _rootName;
    private File _schemaFile;
    private static Hashtable _schemaTable = new Hashtable();
    private static URI xsdURI;
    private static URI xsdCacheURI;

    public static SchemaModel getSchemaModel(String version, File fileSchema, String rootName) throws SchemaException, IOException {
        SchemaModel schema = (SchemaModel)_schemaTable.get(version);
        if (schema == null) {
            schema = new SchemaModel(fileSchema, rootName);
            _schemaTable.put(version, schema);
        }
        return schema;
    }

    private SchemaModel() {
    }

    public SchemaModel(File schemaFile, String rootName) throws IOException, SchemaException {
        XSDElementDeclaration rootElement = null;
        this._xsdSchema = this.loadSchema(schemaFile);
        this._schemaFile = schemaFile;
        this._rootName = rootName;
        rootElement = (XSDElementDeclaration)this.getElementDecTbl().get(rootName);
        if (rootElement == null) {
            throw new SchemaException("Root Element was null for rootname \"" + rootName + "\"");
        }
        this._root = new SchemaElement(rootElement);
        this._root.setSchemaModel(this);
    }

    public void setSchemaFile(File file) {
        this._schemaFile = file;
    }

    public File getSchemaFile() {
        return this._schemaFile;
    }

    public SchemaElement getRootElement() {
        return this._root;
    }

    public void setRootElementName(String rootName) {
        this._rootName = rootName;
    }

    public String getRootElementName() {
        return this._rootName;
    }

    public XSDSchema getSchema() {
        return this._xsdSchema;
    }

    public void addImportedSchema(SchemaModel subSchemaModel, String nsPrefix) throws SchemaException {
        XSDSchema attachedSchema = subSchemaModel.getSchema();
        if (!this.nsMap.containsValue(attachedSchema.getTargetNamespace())) {
            XSDImport xsdImport = xsdFactory.createXSDImport();
            xsdImport.setResolvedSchema(attachedSchema);
            Object[] elLst = attachedSchema.getElementDeclarations().toArray();
            String qname = "";
            for (int i = 0; i < elLst.length; ++i) {
                XSDElementDeclaration el = (XSDElementDeclaration)elLst[i];
                qname = el.getName();
                if (el.getQName().indexOf(":") <= 0 && !this.getTargetNamespaceURI().equals(el.getTargetNamespace())) {
                    StringBuffer sb = new StringBuffer(nsPrefix);
                    sb.append(":");
                    sb.append(el.getName());
                    qname = sb.toString();
                    el.setName(qname);
                }
                this.elementDecTbl.put(qname, el.getResolvedElementDeclaration());
            }
            this.schemaTbl.put(attachedSchema.getTargetNamespace(), attachedSchema);
            this.nsMap.put(nsPrefix, attachedSchema.getTargetNamespace());
            this.nsURI2PrfxMap.put(attachedSchema.getTargetNamespace(), nsPrefix);
            this._xsdSchema.getContents().add(0, (Object)xsdImport);
            ((XSDImportImpl)xsdImport).importSchema();
        }
    }

    public void attachSchemaElement(SchemaModel subSchemaModel, String complexTypeName, String elementName) throws SchemaException {
        XSDComplexTypeDefinition parentType = this._xsdSchema.resolveComplexTypeDefinition(complexTypeName);
        if (parentType == null) {
            this._xsdSchema.updateDocument();
        }
        this.attachSchemaElement(subSchemaModel, (XSDTypeDefinition)parentType, elementName);
    }

    public void attachSchemaElement(SchemaModel subSchemaModel, XSDTypeDefinition parentType, String elementName) throws SchemaException {
        XSDTerm parentTerm;
        XSDSchema attachedSchema = subSchemaModel.getSchema();
        XSDParticle parentParticle = parentType.getComplexType();
        if (parentParticle == null) {
            parentType.updateElement(true);
            parentType.resolveTypeDefinition(parentType.getName());
            parentParticle = parentType.getComplexType();
            if (parentParticle == null) {
                System.err.println("\t Parent Particle is null");
                return;
            }
        }
        if ((parentTerm = parentParticle.getTerm()) instanceof XSDModelGroup) {
            XSDElementDeclaration ed;
            String prefix;
            XSDModelGroup mg = (XSDModelGroup)parentTerm;
            String hashTablename = elementName;
            if (elementName.indexOf(":") == -1 && (prefix = (String)this.nsURI2PrfxMap.get(attachedSchema.getTargetNamespace())) != null) {
                hashTablename = prefix + ":" + elementName;
            }
            if ((ed = (XSDElementDeclaration)this.elementDecTbl.get(hashTablename)) != null) {
                if (mg.contains((XSDConcreteComponent)ed.getResolvedElementDeclaration())) {
                    return;
                }
                XSDParticle tmpPartcl = xsdFactory.createXSDParticle();
                String prefix2 = (String)this.nsURI2PrfxMap.get(attachedSchema.getTargetNamespace());
                if (prefix2 != null && !prefix2.equals("")) {
                    elementName = prefix2 + ":" + elementName;
                    ed.setName(elementName);
                }
                tmpPartcl.setContent((XSDParticleContent)ed.getResolvedElementDeclaration());
                mg.getContents().add((Object)tmpPartcl);
                ed.setTargetNamespace(attachedSchema.getTargetNamespace());
                mg.updateElement(true);
                return;
            }
            System.err.println("Unable to attach schema element to base schema");
        } else {
            System.err.println("Unable to attach schema element to base schema");
        }
    }

    public String getTargetNamespaceURI() {
        return this._xsdSchema.getTargetNamespace();
    }

    public String getSchemaNamespaceURI() {
        return this._xsdSchema.getSchemaForSchemaNamespace();
    }

    public String getSchemaLocation(String namespaceURI) {
        XSDSchema schema = (XSDSchema)this.schemaTbl.get(namespaceURI);
        if (schema != null) {
            return schema.getSchemaLocation();
        }
        return null;
    }

    public String getSchemaName() {
        return this.getSchemaFile().getName();
    }

    public String getSchemaName(String namespaceURI) {
        String path = this.getSchemaLocation(namespaceURI);
        return path == null ? null : new File(path).getName();
    }

    public String getNamespaceURI(String prefix) {
        if (prefix != null && prefix.equals("")) {
            prefix = null;
        }
        return (String)this.nsMap.get(prefix);
    }

    public String getVersion() {
        return this._xsdSchema.getVersion();
    }

    protected XSDSchema loadSchema(File schemaFile) throws IOException, SchemaException {
        try {
            String url = schemaFile.toURL().toString();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
            Map urimap = resourceSet.getURIConverter().getURIMap();
            urimap.put(xsdURI, xsdCacheURI);
            XSDResourceImpl xsdSchemaResource = (XSDResourceImpl)resourceSet.getResource(URI.createURI((String)url), true);
            XSDSchema baseSchema = xsdSchemaResource.getSchema();
            this.schemaTbl.put(baseSchema.getTargetNamespace(), baseSchema);
            this.nsMap = baseSchema.getQNamePrefixToNamespaceMap();
            for (Object content : baseSchema.getContents()) {
                if (!(content instanceof XSDImport)) continue;
                XSDImport xsdImport = (XSDImport)content;
                xsdImport.resolveTypeDefinition(xsdImport.getNamespace(), "");
                this.schemaTbl.put(xsdImport.getNamespace(), xsdImport.getResolvedSchema());
            }
            this.updateElements(baseSchema);
            return baseSchema;
        }
        catch (IOException e) {
            throw new SchemaException("Error loading schema file");
        }
        catch (Exception e) {
            throw new SchemaException("Error loading schema file");
        }
    }

    public Map getNSMap() {
        return this.nsMap;
    }

    public Hashtable getSchemaTbl() {
        return this.schemaTbl;
    }

    public void updateElements(XSDSchema schema) {
        Object[] vals = this.nsMap.values().toArray();
        Object[] keys = this.nsMap.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null || this.nsURI2PrfxMap.contains(keys[i])) continue;
            this.nsURI2PrfxMap.put(vals[i], keys[i]);
        }
        for (XSDElementDeclaration el : schema.getElementDeclarations()) {
            String pref = (String)this.nsURI2PrfxMap.get(el.getTargetNamespace());
            if (pref != null && el.getQName().indexOf(":") < 0) {
                el.getElement().setPrefix(pref);
            }
            this.elementDecTbl.put(el.getName(), el);
        }
        for (XSDAttributeDeclaration attr : schema.getAttributeDeclarations()) {
            String pref = (String)this.nsURI2PrfxMap.get(attr.getTargetNamespace());
            if (pref == null || attr.getQName().indexOf(":") >= 0) continue;
            StringBuffer sbuf = new StringBuffer(pref);
            sbuf.append(":");
            sbuf.append(attr.getName());
            attr.setName(sbuf.toString());
        }
    }

    public Hashtable getNS2PrefixMap() {
        return this.nsURI2PrfxMap;
    }

    public String getPrefixfromURI(String nsURI) {
        return (String)this.nsURI2PrfxMap.get(nsURI);
    }

    public Hashtable getElementDecTbl() {
        return this.elementDecTbl;
    }

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        xsdURI = URI.createURI((String)"http://www.w3.org/2001/xml.xsd");
        xsdCacheURI = URI.createURI((String)(XSDPlugin.INSTANCE.getBaseURL().toString() + "cache/www.w3.org/2001/xml.xsd"));
    }
}

