/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import uk.ac.reload.diva.util.CopyTask;
import uk.ac.reload.dweezil.gui.DweezilFileChooser;
import uk.ac.reload.dweezil.gui.SplashScreen;
import uk.ac.reload.dweezil.gui.StatusWindow;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.dweezil.util.NativeLauncher;
import uk.ac.reload.dweezil.util.OSXApplication;
import uk.ac.reload.dweezil.util.UIUtils;
import uk.ac.reload.editor.EditorDesktopPane;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.menu.MenuAction_About;
import uk.ac.reload.editor.prefs.EditorPrefs;
import uk.ac.reload.editor.prefs.PrefsDialog;
import uk.ac.reload.editor.properties.EditorProperties;

public class EditorFrame
extends JFrame
implements OSXApplication,
IIcons {
    public static final String SUPPORT_JAR_LOCATION = "reload-support.jar";
    public static final String SUPPORT_JAR_RESOURCE = "helpers";
    private StatusWindow _statusWindow;
    private static EditorFrame _instance;

    public EditorFrame() {
        String lf;
        _instance = this;
        System.setProperty("editor.properties.file", "uk.ac.reload.editor.properties.rb");
        DweezilUIManager.setMacUIDefaults((String)EditorProperties.getString("APP_NAME"), (OSXApplication)EditorFrame.getInstance());
        SplashScreen splash = new SplashScreen(DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/splash.gif"));
        boolean DEBUG = EditorProperties.getString("DEBUG").equals("true");
        EditorPrefs.getInstance().setDefaultLocale();
        this._statusWindow = new StatusWindow(EditorProperties.getString("APP_NAME"), EditorProperties.getString("VERSION"), EditorProperties.getString("BUILD_DATE"), DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app32.gif"), !DEBUG, EditorPrefs.getInstance().getPrefsFolder());
        System.out.println(Messages.getString("uk.ac.reload.editor.EditorFrame.0") + ":\t" + EditorProperties.getFileProperty("prefs.dir"));
        System.out.println(Messages.getString("uk.ac.reload.editor.EditorFrame.1") + ":\t\t" + EditorProperties.getFileProperty("helpers.dir"));
        System.out.println(Messages.getString("uk.ac.reload.editor.EditorFrame.2") + ":\t\t" + EditorProperties.getFileProperty("schema.dir"));
        System.out.println(Messages.getString("uk.ac.reload.editor.EditorFrame.3") + ":\t\t" + EditorProperties.getFileProperty("preview.dir"));
        EditorHandler.getSharedInstance().registerInbuiltEditorHandlers();
        boolean checkSupport = EditorPrefs.getInstance().getBooleanValue("check_support");
        if (checkSupport) {
            this.checkSupportFolder();
        }
        if ((lf = EditorPrefs.getInstance().getValue("look_and_feel")) == null) {
            lf = UIManager.getSystemLookAndFeelClassName();
        }
        DweezilUIManager.setLookAndFeel((String)lf, (Component[])new Component[]{EditorFrame.getInstance(), this.getStatusWindow()});
        String defFolder = EditorPrefs.getInstance().getValue("default_folder");
        if (defFolder != null) {
            DweezilFileChooser.setDefaultFolder((File)new File(defFolder));
        }
        super.setTitle(EditorProperties.getString("APP_NAME"));
        ImageIcon icon = DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app32.gif");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EditorHandler.getSharedInstance().closeApplication();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        EditorDesktopPane deskTop = new EditorDesktopPane();
        EditorHandler.getSharedInstance().registerDesktop(deskTop);
        panel.add((Component)deskTop, "Center");
        this.setContentPane(panel);
        this.setJMenuBar(MainMenu.getSharedInstance());
        this.getContentPane().add((Component)MainMenu.getSharedInstance().getToolBar(), "North");
        splash.close();
        UIUtils.centreWindowProportional((Window)this, (double)0.9, (double)0.9);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            int pos = args[i].indexOf("=");
            if (pos == -1) continue;
            try {
                String key = args[i].substring(0, pos).trim();
                String value = args[i].substring(pos + 1).trim();
                System.setProperty(key, value);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        new EditorFrame();
    }

    public static EditorFrame getInstance() {
        return _instance;
    }

    public StatusWindow getStatusWindow() {
        return this._statusWindow;
    }

    public File getHelpFile() {
        return EditorProperties.getFileProperty("help.file");
    }

    public void showHelp() {
        File file = this.getHelpFile();
        if (file != null) {
            NativeLauncher.launchFile((File)file);
        }
    }

    public void setTitle(String title) {
        super.setTitle(EditorProperties.getString("APP_NAME") + " - " + title);
    }

    private void checkSupportFolder() {
        CopyTask copyTask = null;
        try {
            copyTask = new CopyTask(SUPPORT_JAR_LOCATION, EditorPrefs.getInstance().getPrefsFolder());
        }
        catch (IOException e) {
            try {
                copyTask = new CopyTask(SUPPORT_JAR_RESOURCE, EditorPrefs.getInstance().getPrefsFolder());
            }
            catch (Exception e1) {
                e1.printStackTrace();
                System.err.println(Messages.getString("uk.ac.reload.editor.EditorFrame.4"));
                return;
            }
        }
        final CopyTask copyTask1 = copyTask;
        new Runnable(){

            public void run() {
                try {
                    copyTask1.execute(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.run();
    }

    public void preferences() {
        PrefsDialog.getSharedInstance().showDialog();
    }

    public void about() {
        MenuAction_About.doShowMessageDialog();
    }

    public void quit() {
        EditorHandler.getSharedInstance().closeApplication();
    }

    public OSXApplication getAppInstance() {
        return EditorFrame.getInstance();
    }
}

