/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.diva.util.IProgressMonitor;
import uk.ac.reload.diva.util.ZipUtils;
import uk.ac.reload.dweezil.gui.DweezilFileChooser;
import uk.ac.reload.dweezil.gui.DweezilFileFilter;
import uk.ac.reload.dweezil.gui.DweezilProgressMonitor;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.EditorInternalFrame;
import uk.ac.reload.editor.IEditorHandler;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.editor.CP_Editor;
import uk.ac.reload.editor.contentpackaging.editor.CP_NewDialog;
import uk.ac.reload.editor.contentpackaging.editor.cp12.CP12_SchemaController;
import uk.ac.reload.editor.contentpackaging.xml.CP111_SchemaController;
import uk.ac.reload.editor.contentpackaging.xml.CP112_SchemaController;
import uk.ac.reload.editor.contentpackaging.xml.CP113_SchemaController;
import uk.ac.reload.editor.contentpackaging.xml.CP114_SchemaController;
import uk.ac.reload.editor.contentpackaging.xml.CP_SchemaController;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.metadata.MD_EditorHandler;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.prefs.EditorPrefs;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaException;

public class CP_EditorHandler
implements IEditorHandler,
IIcons {
    public static final String IMS_CONTENT_PACKAGING_1_1 = "IMS Content Packaging 1.1";
    public static final String IMS_CONTENT_PACKAGING_1_1_1 = "IMS Content Packaging 1.1.1";
    public static final String IMS_CONTENT_PACKAGING_1_1_2 = "IMS Content Packaging 1.1.2";
    public static final String IMS_CONTENT_PACKAGING_1_1_3 = "IMS Content Packaging 1.1.3";
    public static final String IMS_CONTENT_PACKAGING_1_1_4 = "IMS Content Packaging 1.1.4";
    public static final String IMS_CONTENT_PACKAGING_1_2 = "IMS Content Packaging 1.2";
    public static String IMSCP_NAMESPACE_PREFIX = "imscp";
    public static Namespace IMSCP_NAMESPACE_114 = Namespace.getNamespace("http://www.imsglobal.org/xsd/imscp_v1p1");
    public static Namespace IMSCP_NAMESPACE_113 = Namespace.getNamespace("http://www.imsglobal.org/xsd/imscp_v1p1");
    public static Namespace IMSCP_NAMESPACE_112 = Namespace.getNamespace("http://www.imsproject.org/xsd/imscp_rootv1p1p2");
    public static Namespace IMSCP_NAMESPACE_111 = Namespace.getNamespace("http://www.imsproject.org/xsd/ims_cp_rootv1p1");
    public static Namespace CP_BOGUS_NAMESPACE1 = Namespace.getNamespace("http://www.imsproject.org/content");
    public static String ADLCP_NAMESPACE_PREFIX = "adlcp";
    public static Namespace ADLCP_NAMESPACE_12 = Namespace.getNamespace("adlcp", "http://www.adlnet.org/xsd/adlcp_rootv1p2");
    public static Namespace ADLCP_NAMESPACE_13 = Namespace.getNamespace("adlcp", "http://www.adlnet.org/xsd/adlcp_v1p3");
    public static String IMSLD_NAMESPACE_PREFIX = "imsld";
    public static Namespace IMSLD_NAMESPACE_10 = Namespace.getNamespace("imsld", "http://www.imsglobal.org/xsd/imsld_v1p0");
    public static String IMSMD_NAMESPACE_PREFIX = "imsmd";
    protected static Hashtable SUPPORTED_CP_NAMESPACES = new Hashtable();
    public static final File HELPER_FOLDER;
    public static final File PROFILE_FOLDER;
    public static final File SCHEMAHELPER_FOLDER;
    public static final File VOCAB_FOLDER;

    public boolean canCreateDocuments() {
        return true;
    }

    public boolean canEditFile(File file) {
        Document doc = null;
        try {
            doc = this.getDocument(file);
        }
        catch (Exception ex) {
            return false;
        }
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)doc);
        if (nameSpace == null || nameSpace.equals(Namespace.NO_NAMESPACE)) {
            return false;
        }
        if (CP_EditorHandler.getSCORM_Namespace(doc) != null) {
            return false;
        }
        if (CP_EditorHandler.getLD_Namespace(doc) != null) {
            return false;
        }
        return SUPPORTED_CP_NAMESPACES.containsKey(nameSpace);
    }

    public EditorInternalFrame editFile(File file) throws JDOMException, SchemaException, IOException {
        boolean ok;
        if (file.getName().toLowerCase().endsWith(".zip")) {
            File manifest = this.unzipManifest(file);
            if (manifest == null) {
                return null;
            }
            file = manifest;
        }
        if (!(ok = this.replaceBogusNamespace(file, true))) {
            return null;
        }
        ContentPackage cp = new ContentPackage(file);
        return new CP_Editor(cp);
    }

    protected boolean replaceBogusNamespace(File manifest, boolean askUser) throws IOException, JDOMException {
        Document doc = this.getDocument(manifest);
        Namespace ns = XMLUtils.getDocumentNamespace((Document)doc);
        if (CP_BOGUS_NAMESPACE1.equals(ns)) {
            int result;
            if (askUser && (result = JOptionPane.showConfirmDialog(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.0") + ":     " + ns.getURI() + "\n" + Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.1") + "\n\n" + Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.2") + "\n" + Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.3") + "\n" + Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.4"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.13"), 0)) != 0) {
                return false;
            }
            FileUtils.copyFile((File)manifest, (File)new File(manifest.getPath() + ".bak"));
            XMLUtils.replaceNamespaces((Element)doc.getRootElement(), (Namespace)ns, (Namespace)IMSCP_NAMESPACE_113);
            XMLUtils.replaceNamespaces((Element)doc.getRootElement(), (Namespace)MD_EditorHandler.MD_BOGUS_NAMESPACE1, (Namespace)Namespace.getNamespace("imsmd", MD_EditorHandler.IMSMD_NAMESPACE_122.getURI()));
            doc.getContent().add(0, new Comment(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.5") + EditorProperties.getString("APP_NAME")));
            XMLUtils.write2XMLFile((Document)doc, (File)manifest);
        }
        return true;
    }

    public EditorInternalFrame newDocument() throws JDOMException, SchemaException, IOException {
        String versionCP = EditorPrefs.getInstance().getValue("default_cp_version");
        String versionMD = EditorPrefs.getInstance().getValue("default_cp_md_version");
        String[] versionsMD = EditorHandler.MD_EDITORHANDLER.getSupportedVersions();
        String[] versionsCP = this.getSupportedVersions();
        CP_NewDialog dialog = new CP_NewDialog(versionsCP, versionCP, versionsMD, versionMD);
        File cpFolder = dialog.showDialog();
        if (cpFolder == null) {
            return null;
        }
        versionCP = dialog.getVersionCP();
        versionMD = dialog.getVersionMD();
        EditorPrefs.getInstance().putValue("default_cp_version", versionCP);
        EditorPrefs.getInstance().putValue("default_cp_md_version", versionMD);
        CP_SchemaController cpController = (CP_SchemaController)this.getSchemaControllerInstance(versionCP);
        MD_SchemaController mdController = (MD_SchemaController)EditorHandler.MD_EDITORHANDLER.getSchemaControllerInstance(versionMD);
        ContentPackage cp = new ContentPackage(cpFolder, cpController, mdController);
        return new CP_Editor(cp);
    }

    protected Document getDocument(File file) throws IOException, JDOMException {
        if (file.getName().toLowerCase().endsWith(".zip")) {
            String manifest = ZipUtils.extractZipEntry((File)file, (String)"imsmanifest.xml");
            if (manifest != null) {
                return XMLUtils.readXMLString((String)manifest);
            }
            throw new IOException(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.6"));
        }
        return XMLUtils.readXMLFile((File)file);
    }

    public String getName() {
        return Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.7");
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/cp.gif");
    }

    public String[] getSupportedVersions() {
        return new String[]{IMS_CONTENT_PACKAGING_1_1_1, IMS_CONTENT_PACKAGING_1_1_2, IMS_CONTENT_PACKAGING_1_1_3, IMS_CONTENT_PACKAGING_1_1_4, IMS_CONTENT_PACKAGING_1_2};
    }

    public String getDefaultVersion() {
        return IMS_CONTENT_PACKAGING_1_1_4;
    }

    public String getDefaultMDVersion() {
        return "IMS Metadata 1.2.4";
    }

    public String getVersion(Namespace ns) {
        return ns == null ? null : (String)SUPPORTED_CP_NAMESPACES.get(ns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File unzipManifest(File fileCP) throws IOException {
        File manifest = null;
        DweezilProgressMonitor progressMonitor = null;
        if (!CP_EditorHandler.containsManifest(fileCP)) {
            throw new IOException(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.8"));
        }
        CP_NewDialog dialog = new CP_NewDialog(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.9") + fileCP.getName());
        File targetFolder = dialog.showDialog();
        if (targetFolder == null) {
            return null;
        }
        progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.10"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.11"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.12"), true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
        try {
            manifest = CP_EditorHandler.unzipContentPackage(fileCP, targetFolder, progressMonitor);
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
        }
        return manifest;
    }

    public static boolean containsManifest(File zipFile) throws FileNotFoundException, IOException {
        return ZipUtils.hasZipEntry((File)zipFile, (String)"imsmanifest.xml");
    }

    public static File unzipContentPackage(File zipFile, File targetFolder, DweezilProgressMonitor progressMonitor) throws FileNotFoundException, IOException {
        File manifestFile = null;
        ZipUtils.unpackZip((File)zipFile, (File)targetFolder, (IProgressMonitor)progressMonitor);
        manifestFile = new File(targetFolder, "imsmanifest.xml");
        if (!manifestFile.exists()) {
            return null;
        }
        return manifestFile;
    }

    public static Namespace getSCORM_Namespace(Document doc) {
        boolean found = XMLUtils.containsNamespace((Document)doc, (Namespace)ADLCP_NAMESPACE_12);
        if (found) {
            return ADLCP_NAMESPACE_12;
        }
        found = XMLUtils.containsNamespace((Document)doc, (Namespace)ADLCP_NAMESPACE_13);
        if (found) {
            return ADLCP_NAMESPACE_13;
        }
        return null;
    }

    public static Namespace getLD_Namespace(Document doc) {
        boolean found = XMLUtils.containsNamespace((Document)doc, (Namespace)IMSLD_NAMESPACE_10);
        if (found) {
            return IMSLD_NAMESPACE_10;
        }
        return null;
    }

    public SchemaController getSchemaControllerInstance(String version) throws JDOMException, SchemaException, IOException {
        CP_SchemaController schemaController = null;
        if (IMS_CONTENT_PACKAGING_1_1_2.equals(version)) {
            schemaController = new CP112_SchemaController();
        } else if (IMS_CONTENT_PACKAGING_1_1_3.equals(version)) {
            schemaController = new CP113_SchemaController();
        } else if (IMS_CONTENT_PACKAGING_1_1_1.equals(version)) {
            schemaController = new CP111_SchemaController();
        } else if (IMS_CONTENT_PACKAGING_1_1_4.equals(version)) {
            schemaController = new CP114_SchemaController();
        } else if (IMS_CONTENT_PACKAGING_1_2.equals(version)) {
            schemaController = new CP12_SchemaController();
        }
        return schemaController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipContentPackage(ContentPackage cp) {
        if (cp != null) {
            DweezilProgressMonitor progressMonitor = null;
            DeflaterOutputStream zOut = null;
            try {
                DweezilFileFilter filter = new DweezilFileFilter(new String[]{"zip", "jar"}, Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.19"));
                File file = DweezilFileChooser.askFileNameSave((Component)EditorFrame.getInstance(), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.20"), (FileFilter)filter, (String)"zip");
                if (file != null) {
                    progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.21"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.44"), "", true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    zOut = new ZipOutputStream(out);
                    ZipUtils.addFolderToZip((File)cp.getProjectFolder(), (File)cp.getProjectFolder(), (ZipOutputStream)zOut, (File)file, (IProgressMonitor)progressMonitor);
                }
            }
            catch (IOException ex) {
                ErrorDialogBox.showWarning((Component)EditorFrame.getInstance(), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.21"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.22"), (Exception)ex);
            }
            finally {
                if (zOut != null) {
                    try {
                        zOut.flush();
                        ((ZipOutputStream)zOut).close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (progressMonitor != null) {
                    progressMonitor.close();
                }
            }
        }
    }

    static {
        SUPPORTED_CP_NAMESPACES.put(IMSCP_NAMESPACE_111, IMS_CONTENT_PACKAGING_1_1_1);
        SUPPORTED_CP_NAMESPACES.put(IMSCP_NAMESPACE_112, IMS_CONTENT_PACKAGING_1_1_2);
        SUPPORTED_CP_NAMESPACES.put(IMSCP_NAMESPACE_113, IMS_CONTENT_PACKAGING_1_1_3);
        SUPPORTED_CP_NAMESPACES.put(IMSCP_NAMESPACE_114, IMS_CONTENT_PACKAGING_1_1_4);
        SUPPORTED_CP_NAMESPACES.put(CP_BOGUS_NAMESPACE1, IMS_CONTENT_PACKAGING_1_1_3);
        HELPER_FOLDER = new File(EditorHandler.HELPERFOLDER, "cp");
        PROFILE_FOLDER = new File(HELPER_FOLDER, "profile");
        SCHEMAHELPER_FOLDER = new File(HELPER_FOLDER, "schemahelper");
        VOCAB_FOLDER = new File(HELPER_FOLDER, "vocab");
    }
}

