/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.editor.cp12;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import uk.ac.reload.diva.util.GeneralUtils;

public class IMSPointer {
    private static final String IDENTIFIER = "identifier";
    private static final String IDENTIFIERREF = "identifierref";
    private static final String MANIFEST = "manifest";
    private static final String RESOURCE = "resource";
    private static final String RESOURCES = "resources";
    private static final String HREF = "href";
    public static final String FILE = "file";
    public static int xpathIndx = 9;
    private static Namespace cp12NS = Namespace.getNamespace("", "http://www.imsglobal.org/xsd/imscp_v1p1");
    private String urlStr;
    private String xpathStr;
    private File fileURLBase;
    private List resourceElements;
    private List remoteElements;
    private Document remoteDocument;
    private static Hashtable resolvedIMSPtrs = new Hashtable();

    public IMSPointer(String pntrstring) {
        String[] strs = pntrstring.split("#");
        if (strs.length > 1) {
            this.urlStr = strs[0];
            this.xpathStr = strs[1];
        }
        this.resourceElements = new ArrayList();
        this.remoteElements = new ArrayList();
    }

    public IMSPointer(String value, File baseFolder) {
        this(value);
        this.fileURLBase = baseFolder;
    }

    public static IMSPointer getIMSPointer(String pntrstring, File file) {
        IMSPointer remotePtr = (IMSPointer)resolvedIMSPtrs.get(pntrstring);
        if (remotePtr == null && (remotePtr = new IMSPointer(pntrstring, file)) != null) {
            resolvedIMSPtrs.put(pntrstring, remotePtr);
        }
        return remotePtr;
    }

    public void buildElementLst() {
        NodeList nodeLst;
        URL url;
        block16: {
            url = null;
            nodeLst = null;
            try {
                if (this.urlStr.indexOf("http") == -1) {
                    File file = new File(this.fileURLBase, this.urlStr);
                    if (file.exists()) {
                        url = file.toURL();
                    }
                    break block16;
                }
                if (this.urlStr.endsWith(".zip")) {
                    return;
                }
                url = new URL(this.urlStr);
                try {
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.connect();
                    if (conn.getResponseCode() != 200) {
                        return;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
        }
        if (url != null) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                InputSource inputSource = new InputSource(in);
                String xpathstr1 = this.xpathStr.substring(xpathIndx, this.xpathStr.length() - 1);
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                org.w3c.dom.Document document = builder.parse(inputSource);
                nodeLst = (NodeList)xpath.evaluate(xpathstr1, document, XPathConstants.NODESET);
                DOMBuilder domBuildr = new DOMBuilder();
                this.remoteDocument = domBuildr.build(document);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (nodeLst == null) {
            return;
        }
        int i = 0;
        while (i < nodeLst.getLength()) {
            org.w3c.dom.Element domElmnt;
            if (this.isParentinNodeLst(nodeLst, domElmnt = (org.w3c.dom.Element)nodeLst.item(i++))) continue;
            DOMBuilder buildr = new DOMBuilder();
            Element elmnt = buildr.build(domElmnt);
            elmnt.detach();
            IMSPointer.removeEmptyNSOfChildren(elmnt);
            if (elmnt.getName().equals(RESOURCE) || elmnt.getName().equals(MANIFEST)) {
                this.updateFileHREFs(elmnt);
            }
            this.remoteElements.add(elmnt);
        }
    }

    public static void removeEmptyNSOfChildren(Element current) {
        if (current.getNamespace().getURI().equals("")) {
            current.setNamespace(cp12NS);
        }
        List children = current.getChildren();
        for (Element child : children) {
            IMSPointer.removeEmptyNSOfChildren(child);
        }
    }

    boolean isParentinNodeLst(NodeList nodeLst, Node node) {
        int i = 0;
        while (i < nodeLst.getLength()) {
            if (!nodeLst.item(i++).equals(node.getParentNode())) continue;
            return true;
        }
        return false;
    }

    private void buildResourceList() {
        if (this.remoteDocument == null) {
            return;
        }
        Element manifest = this.remoteDocument.getRootElement();
        if (manifest == null) {
            return;
        }
        Element resources = this.remoteDocument.getRootElement().getChild(RESOURCES, this.remoteDocument.getRootElement().getNamespace());
        if (resources == null) {
            return;
        }
        List list = resources.getChildren(RESOURCE, resources.getNamespace());
        for (Element elmnt : this.remoteElements) {
            if (elmnt.getName().equals(MANIFEST)) continue;
            this.buildResourceList(elmnt, list);
        }
    }

    private void buildResourceList(Element el, List resList) {
        String idref = el.getAttributeValue(IDENTIFIERREF);
        if (idref != null) {
            for (Element resElement : resList) {
                String id = resElement.getAttributeValue(IDENTIFIER);
                if (id == null || !idref.equals(id)) continue;
                Element resourceElement = resElement;
                this.updateFileHREFs(resourceElement);
                this.resourceElements.add(resourceElement.detach());
            }
        }
        List children = el.getChildren();
        for (Element child : children) {
            this.buildResourceList(child, resList);
        }
    }

    private void updateFileHREFs(Element resourceElement) {
        if (resourceElement.getName().equals(FILE) || resourceElement.getName().equals(RESOURCE)) {
            String baseURLStr;
            String href = resourceElement.getAttributeValue(HREF);
            if (href != null) {
                href = href.replace('\\', '/');
            }
            if (href != null && !GeneralUtils.isExternalURL((String)href) && (baseURLStr = this.urlStr.substring(0, this.urlStr.lastIndexOf("/"))) != null) {
                href = baseURLStr + File.separatorChar + href;
                resourceElement.setAttribute(HREF, href);
            }
        }
        List fileElements = resourceElement.getChildren();
        for (Element child : fileElements) {
            this.updateFileHREFs(child);
        }
    }

    public Document getRemoteDocument() {
        return this.remoteDocument;
    }

    public List getRemoteElements() {
        if (this.remoteElements.size() == 0) {
            this.buildElementLst();
        }
        return this.remoteElements;
    }

    public List getResourceElements() {
        if (this.resourceElements.size() == 0) {
            this.buildResourceList();
        }
        return this.resourceElements;
    }
}

