/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.editor.manifestview;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.dnd.DNDUtils;
import uk.ac.reload.dweezil.dnd.DragObject;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.tree.DweezilTree;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeDragDropHandler;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.dweezil.gui.tree.DweezilTreePopupHandler;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.dweezil.util.NativeLauncher;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.datamodel.CP_Resource;
import uk.ac.reload.editor.contentpackaging.editor.CP_Editor;
import uk.ac.reload.editor.contentpackaging.editor.cp12.IMSPointer;
import uk.ac.reload.editor.contentpackaging.editor.manifestview.ManifestInfoPanel;
import uk.ac.reload.editor.contentpackaging.editor.manifestview.ManifestTreeModel;
import uk.ac.reload.editor.contentpackaging.editor.manifestview.ManifestTreeNode;
import uk.ac.reload.editor.contentpackaging.editor.manifestview.ManifestTreeRenderer;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.editor.gui.ElementTreeNode;
import uk.ac.reload.editor.gui.TreeIconInterface;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.editor.MD_EditorDialog;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.editor.scorm.editor.SCORM12_EditorDialog;
import uk.ac.reload.editor.scorm.xml.SCORM12_Package;
import uk.ac.reload.editor.scorm2004.SCORM13_EditorDialog;
import uk.ac.reload.editor.scorm2004.SCORM1_3SequencingEditorDialog;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentClipboard;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class ManifestTree
extends DweezilTree
implements XMLDocumentListener,
IIcons {
    private CP_Editor _cpEditor;
    private ManifestInfoPanel _infoPanel;
    private ManifestTreeModel _treeModel = new ManifestTreeModel();
    private ManifestTreeDragDropHandler _dragdropHandler;
    private DweezilTreePopupHandler _popupMenuHandler;
    private TreePath _currentTreePath;
    private SchemaController _schemaController;
    private Menu_Edit _editMenu;
    private ProxyDeleteHandler _deleteHandler;
    private ProxyCutHandler _cutHandler;
    private ProxyCopyHandler _copyHandler;
    private ProxyPasteHandler _pasteHandler;
    private ProxyMoveUpHandler _moveUpHandler;
    private ProxyMoveDownHandler _moveDownHandler;
    private ProxyLaunchFileHandler _launchFileHandler;
    private ProxyEditMetadataHandler _editMetadataHandler;
    private ProxyEditSCORMHandler _editSCORMHandler;
    protected ProxyEditSequencingHandler _editSequencingHandler;
    protected ProxyEditADLNavigationHandler _editADLNavigationHandler;
    private Action_ResolveIMSPntr actionResolvePntr;
    private ContentPackage _contentPackage;

    public ManifestTree(CP_Editor cpEditor, ManifestInfoPanel infoPanel) {
        this.setModel((TreeModel)((Object)this._treeModel));
        this._cpEditor = cpEditor;
        this._infoPanel = infoPanel;
        this.setCellRenderer(new ManifestTreeRenderer());
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        this._popupMenuHandler = new DweezilTreePopupHandler((JTree)((Object)this));
        this._editMenu = MainMenu.getSharedInstance().editMenu;
        this._editMenu.remapKeyStrokes((JComponent)((Object)this));
        this._dragdropHandler = new ManifestTreeDragDropHandler(this);
        this._cutHandler = new ProxyCutHandler(this._editMenu.actionCut);
        this._copyHandler = new ProxyCopyHandler(this._editMenu.actionCopy);
        this._pasteHandler = new ProxyPasteHandler(this._editMenu.actionPaste);
        this._deleteHandler = new ProxyDeleteHandler(this._editMenu.actionDelete);
        this._moveUpHandler = new ProxyMoveUpHandler(this._editMenu.actionMoveUp);
        this._moveDownHandler = new ProxyMoveDownHandler(this._editMenu.actionMoveDown);
        this._editMetadataHandler = new ProxyEditMetadataHandler();
        this._editSCORMHandler = new ProxyEditSCORMHandler();
        this._launchFileHandler = new ProxyLaunchFileHandler();
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (!e.isAddedPath()) {
                    return;
                }
                TreePath selPath = e.getPath();
                if (selPath != ManifestTree.this._currentTreePath) {
                    ManifestTree.this.updateMenus(selPath);
                    ManifestTree.this.updateInfoPanel(selPath);
                    ManifestTree.this._currentTreePath = selPath;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    ManifestTree.this.updateMenus(ManifestTree.this.getSelectionPath());
                }
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ManifestTree.this.clearMenus();
                }
            }
        });
    }

    public void setContentPackage(ContentPackage cp) {
        this._contentPackage = cp;
        this._schemaController = this._contentPackage.getSchemaController();
        this._treeModel.setContentPackage(this._contentPackage);
        this.selectNode((DefaultMutableTreeNode)this._treeModel.getRootNode());
        this._contentPackage.addXMLDocumentListener(this);
    }

    public void cleanup() {
        this._contentPackage.removeXMLDocumentListener(this);
        this.clearMenus();
    }

    protected synchronized void updateInfoPanel(TreePath selPath) {
        if (this._infoPanel != null) {
            if (selPath == null) {
                this._infoPanel.clear();
                return;
            }
            Object selectedNode = selPath.getLastPathComponent();
            if (selectedNode instanceof ManifestTreeNode) {
                ManifestTreeNode treeNode = (ManifestTreeNode)selectedNode;
                ElementBinding eb = treeNode.createElementBinding();
                this._infoPanel.setElementBinding(eb);
            }
        }
    }

    public void updateMenus() {
        this.updateMenus(this.getSelectionPath());
    }

    private synchronized void updateMenus(TreePath selPath) {
        this.clearMenus();
        if (selPath == null) {
            return;
        }
        Object selectedNode = selPath.getLastPathComponent();
        if (selectedNode instanceof ManifestTreeNode) {
            ManifestTreeNode treeNode = (ManifestTreeNode)selectedNode;
            Element element = treeNode.getElement();
            SchemaElement schemaElement = treeNode.getSchemaElement();
            String elementName = element.getName();
            JPopupMenu popupMenu = this._popupMenuHandler.getPopupMenu();
            this._cutHandler.update(element);
            popupMenu.add((Action)this._cutHandler.getMenuAction());
            this._copyHandler.update(element);
            popupMenu.add((Action)this._copyHandler.getMenuAction());
            this._pasteHandler.update(element);
            popupMenu.add((Action)this._pasteHandler.getMenuAction());
            this._deleteHandler.update(element);
            popupMenu.add((Action)this._deleteHandler.getMenuAction());
            popupMenu.addSeparator();
            this._moveUpHandler.update(element);
            popupMenu.add((Action)this._moveUpHandler.getMenuAction());
            this._moveDownHandler.update(element);
            popupMenu.add((Action)this._moveDownHandler.getMenuAction());
            ManifestTreeNode seqNode = ManifestTree.findSequencingNodeAncestor(treeNode);
            Action_EditSequencing actionEditSequencing = null;
            if (seqNode != null) {
                SchemaElement seqSchemaElement = seqNode.getSchemaElement();
                Element itemElement = seqNode.getElement().getParentElement();
                if (itemElement.getName().equals("item") || itemElement.getName().equals("organization")) {
                    String editSequencing = Messages.getString("ManifestTree.3");
                    actionEditSequencing = new Action_EditSequencing(itemElement, seqSchemaElement, editSequencing);
                    this._editSequencingHandler = new ProxyEditSequencingHandler(itemElement, seqSchemaElement);
                    this._editSequencingHandler.setEnabled(true);
                }
            }
            this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
            popupMenu.addSeparator();
            if (schemaElement != null && schemaElement.hasChildren()) {
                SchemaElement[] children = schemaElement.getChildren();
                ArrayList<Action_AddChildElement> advancedSequencingOptions = new ArrayList<Action_AddChildElement>();
                for (int i = 0; i < children.length; ++i) {
                    SchemaElement childSchemaElement = children[i];
                    String childName = childSchemaElement.getName();
                    Namespace ns = childSchemaElement.getNamespace();
                    if (ns.getPrefix() == "imsss" && childName.equals("sequencing")) {
                        String editSequencing = Messages.getString("ManifestTree.3");
                        actionEditSequencing = new Action_EditSequencing(element, childSchemaElement, editSequencing);
                        this._editSequencingHandler = new ProxyEditSequencingHandler(element, childSchemaElement);
                        this._editSequencingHandler.setEnabled(true);
                        if (!this._treeModel.canAddNode(childSchemaElement)) continue;
                        advancedSequencingOptions.add(new Action_AddChildElement(element, childSchemaElement));
                        continue;
                    }
                    if (this._treeModel.canAddNode(childSchemaElement) && element.getNamespacePrefix().equals("imsss")) {
                        advancedSequencingOptions.add(new Action_AddChildElement(element, childSchemaElement));
                        continue;
                    }
                    if (!this._treeModel.canAddNode(childSchemaElement)) continue;
                    Action_AddChildElement actionAddElement = new Action_AddChildElement(element, childSchemaElement);
                    popupMenu.add(actionAddElement);
                    this._editMenu.addAdditionalItem(actionAddElement);
                }
                if (actionEditSequencing != null) {
                    this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                    popupMenu.addSeparator();
                    popupMenu.add(actionEditSequencing);
                    this._editMenu.addAdditionalItem(actionEditSequencing);
                }
                if (advancedSequencingOptions.size() > 0) {
                    JMenu newMenu = new JMenu(Messages.getString("ManifestTree.4"));
                    JMenu newMenu2 = new JMenu(Messages.getString("ManifestTree.4"));
                    for (int i = 0; i < advancedSequencingOptions.size(); ++i) {
                        newMenu.add((Action_AddChildElement)advancedSequencingOptions.get(i));
                        newMenu2.add((Action_AddChildElement)advancedSequencingOptions.get(i));
                    }
                    popupMenu.add(newMenu);
                    this._editMenu.addAdditionalItem(newMenu2);
                }
            }
            if (this._contentPackage.isMetadataElement(elementName)) {
                this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                popupMenu.addSeparator();
                Action_EditMetadata actionEditMD = new Action_EditMetadata(element);
                popupMenu.add(actionEditMD);
                this._editMenu.addAdditionalItem(actionEditMD);
                this._editMetadataHandler.update(element);
            } else if (elementName.equals("item") && this._contentPackage instanceof SCORM12_Package) {
                if (schemaElement != null) {
                    this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                    popupMenu.addSeparator();
                    Action_EditSCORM actionEditSCORM = new Action_EditSCORM(element, schemaElement);
                    popupMenu.add(actionEditSCORM);
                    this._editMenu.addAdditionalItem(actionEditSCORM);
                    this._editSCORMHandler.update(element, schemaElement);
                }
            } else if (elementName.equals("manifest") && this._contentPackage.isDocumentNamespace(element)) {
                this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                popupMenu.addSeparator();
                Action_ImportManifest actionImportManifest = new Action_ImportManifest(element);
                popupMenu.add(actionImportManifest);
                this._editMenu.addAdditionalItem(actionImportManifest);
                if (!element.isRootElement()) {
                    Action_ExportManifest actionExportManifest = new Action_ExportManifest(element);
                    popupMenu.add(actionExportManifest);
                    this._editMenu.addAdditionalItem(actionExportManifest);
                }
            }
            if (this._contentPackage.isReferencingElement(element)) {
                this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                popupMenu.addSeparator();
                Action_JumpToRefNode actionJumpNode = new Action_JumpToRefNode(element);
                this._editMenu.addAdditionalItem(actionJumpNode);
                popupMenu.add(actionJumpNode);
            }
            this._launchFileHandler.update(element);
        }
    }

    public synchronized void clearMenus() {
        this._popupMenuHandler.setPopupMenu(new JPopupMenu());
        this._editMenu.removeAdditionalItems();
        if (this._cutHandler != null) {
            this._cutHandler.clear();
        }
        if (this._copyHandler != null) {
            this._copyHandler.clear();
        }
        if (this._pasteHandler != null) {
            this._pasteHandler.clear();
        }
        if (this._deleteHandler != null) {
            this._deleteHandler.clear();
        }
        if (this._moveUpHandler != null) {
            this._moveUpHandler.clear();
        }
        if (this._moveDownHandler != null) {
            this._moveDownHandler.clear();
        }
        if (this._launchFileHandler != null) {
            this._launchFileHandler.clear();
        }
        if (this._editMetadataHandler != null) {
            this._editMetadataHandler.clear();
        }
        if (this._editSCORMHandler != null) {
            this._editSCORMHandler.clear();
        }
        if (this._editSequencingHandler != null) {
            this._editSequencingHandler.clear();
        }
        if (this._editADLNavigationHandler != null) {
            this._editADLNavigationHandler.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void editMetadata(Element mdElement) {
        MD_EditorDialog mdDialog = null;
        try {
            if (this._editMetadataHandler != null) {
                this._editMetadataHandler.setEnabled(false);
            }
            EditorFrame.getInstance().setCursor(DweezilUIManager.WAIT_CURSOR);
            mdDialog = new MD_EditorDialog(this._contentPackage, mdElement);
            mdDialog.showDialog();
        }
        catch (Exception ex) {
            if (EditorProperties.getString("DEBUG").equals("true")) {
                ex.printStackTrace();
            }
            if (mdDialog != null) {
                mdDialog.dispose();
            }
            ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.contentpackaging.manifestview.ManifestTree.0"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.manifestview.ManifestTree.1"), (Exception)ex);
        }
        finally {
            EditorFrame.getInstance().setCursor(DweezilUIManager.DEFAULT_CURSOR);
        }
    }

    protected void editSCORM(final Element itemElement, final SchemaElement schemaElement) {
        Thread thread = new Thread(){
            SCORM12_EditorDialog editor;

            public void run() {
                if (ManifestTree.this._editSCORMHandler != null) {
                    ManifestTree.this._editSCORMHandler.setEnabled(false);
                }
                this.editor = new SCORM12_EditorDialog(ManifestTree.this._contentPackage, itemElement, schemaElement);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        editor.showDialog();
                    }
                });
            }
        };
        thread.start();
    }

    public void elementAdded(XMLDocumentListenerEvent event) {
        ManifestTreeNode newNode;
        Element element = event.getElement();
        Element parent = element.getParentElement();
        DweezilTreeNode parentNode = this.getNode(parent);
        if (parentNode != null && (newNode = this.addNode((DefaultMutableTreeNode)parentNode, element)) != null && event.doSelect()) {
            this.selectNode((DefaultMutableTreeNode)((Object)newNode));
        }
    }

    private ManifestTreeNode addNode(DefaultMutableTreeNode parentNode, Element element) {
        ManifestTreeNode newNode = null;
        int index = this.getInsertNodePosition(parentNode, element);
        if (index != -1) {
            newNode = new ManifestTreeNode(element);
            this._treeModel.insertNodeInto((MutableTreeNode)((Object)newNode), parentNode, index);
            for (Element child : element.getChildren()) {
                this.addNode((DefaultMutableTreeNode)((Object)newNode), child);
            }
        }
        return newNode;
    }

    protected int getInsertNodePosition(DefaultMutableTreeNode parentNode, Element element) {
        Element child;
        if (!this._treeModel.doShowNode(element)) {
            return -1;
        }
        int index = 0;
        List children = element.getParentElement().getChildren();
        for (int i = 0; i < children.size() && (child = (Element)children.get(i)) != element; ++i) {
            if (!this._treeModel.doShowNode(child)) continue;
            ++index;
        }
        if (index > parentNode.getChildCount()) {
            index = parentNode.getChildCount();
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    public void elementRemoved(XMLDocumentListenerEvent event) {
        Element element = event.getElement();
        DweezilTreeNode nodeToDelete = this.getNode(element);
        if (nodeToDelete != null) {
            if (nodeToDelete.isNodeDescendant((DefaultMutableTreeNode)this.getSelectedNode())) {
                DefaultMutableTreeNode prevNode = nodeToDelete.getPreviousSibling();
                if (prevNode == null) {
                    prevNode = (DefaultMutableTreeNode)nodeToDelete.getParent();
                }
                this._treeModel.removeNodeFromParent((MutableTreeNode)nodeToDelete);
                this.selectNode(prevNode);
            } else {
                this._treeModel.removeNodeFromParent((MutableTreeNode)nodeToDelete);
                this.updateMenus(this.getSelectionPath());
            }
        }
    }

    public void elementChanged(XMLDocumentListenerEvent event) {
        DweezilTreeNode node = this.getNode(event.getElement());
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable((DefaultMutableTreeNode)node){
                final /* synthetic */ DefaultMutableTreeNode val$node;
                {
                    this.val$node = defaultMutableTreeNode;
                }

                public void run() {
                    ManifestTree.this._treeModel.nodeChanged(this.val$node);
                }
            });
        }
    }

    public void documentSaved(XMLDocument doc) {
    }

    protected void editSequencing(final Element itemElement, final SchemaElement schemaElement) {
        Thread thread = new Thread(){
            SCORM1_3SequencingEditorDialog editor;

            public void run() {
                String title = Messages.getString("ManifestTree.5");
                String id = itemElement.getAttributeValue("identifier");
                if (id != null && id.length() > 0) {
                    title = id;
                }
                List children = itemElement.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    if (!((Element)children.get(i)).getName().equalsIgnoreCase("title")) continue;
                    title = ((Element)children.get(i)).getText();
                }
                if (ManifestTree.this._editSequencingHandler != null) {
                    ManifestTree.this._editSequencingHandler.setEnabled(false);
                }
                this.editor = new SCORM1_3SequencingEditorDialog(ManifestTree.this._contentPackage, itemElement, schemaElement, title);
                this.editor.setLocationRelativeTo((Component)((Object)ManifestTree.this));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        editor.show();
                    }
                });
            }
        };
        thread.start();
    }

    protected void editADLNavigation(final Element itemElement, final SchemaElement schemaElement) {
        Thread thread = new Thread(){
            SCORM13_EditorDialog editor;

            public void run() {
                if (ManifestTree.this._editSequencingHandler != null) {
                    ManifestTree.this._editSequencingHandler.setEnabled(false);
                }
                this.editor = new SCORM13_EditorDialog(ManifestTree.this._contentPackage, itemElement, schemaElement);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        editor.show();
                    }
                });
            }
        };
        thread.start();
    }

    public static ManifestTreeNode findSequencingNodeAncestor(ManifestTreeNode treeNode) {
        if (treeNode != null) {
            String name = treeNode.getName();
            name.toLowerCase();
            if (name.equals("resource") || name.equals("metadata") || name.equals("item") || name.equals("organization") || name.equals("manifest")) {
                return null;
            }
            if (name.equals("sequencing")) {
                return treeNode;
            }
            return ManifestTree.findSequencingNodeAncestor((ManifestTreeNode)((Object)treeNode.getParent()));
        }
        return null;
    }

    public void attachRemoteNode(Element _element) {
        Attribute ptrAtt = _element.getAttribute("href", Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink"));
        Attribute idAtt = _element.getAttribute("identifier");
        IMSPointer imsPtr = IMSPointer.getIMSPointer(ptrAtt.getValue(), this._contentPackage.getProjectFolder());
        List elmnts = imsPtr.getRemoteElements();
        Element parent = _element.getParentElement();
        if (elmnts != null && parent != null && elmnts.size() != 0) {
            int indxToAttach = parent.indexOf(_element);
            parent.removeContent(_element);
            if (idAtt != null && elmnts.size() == 1) {
                Element elmnt = (Element)elmnts.get(0);
                elmnt.getAttribute("identifier").setValue(idAtt.getValue());
            }
            if (indxToAttach == -1) {
                indxToAttach = 0;
            }
            parent.addContent(indxToAttach, elmnts);
            List resElmnts = imsPtr.getResourceElements();
            if (resElmnts != null && resElmnts.size() > 0) {
                Element resources = parent.getDocument().getRootElement().getChild("resources", parent.getDocument().getRootElement().getNamespace());
                resources.addContent(resElmnts);
            }
            this.setContentPackage(this._contentPackage);
        }
    }

    class Action_ResolveIMSPntr
    extends AbstractAction {
        Element _element;

        public Action_ResolveIMSPntr(Element element) {
            super("Attach Remote Node", null);
            this._element = element;
        }

        public void actionPerformed(ActionEvent e) {
            ManifestTree.this.attachRemoteNode(this._element);
        }
    }

    class Action_EditADLNavigation
    extends AbstractAction {
        Element _element;
        SchemaElement _schemaElement;

        public Action_EditADLNavigation(Element element, SchemaElement schemaElement, String text) {
            super(text, DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/new.gif"));
            this._element = element;
            this._schemaElement = schemaElement;
        }

        public void actionPerformed(ActionEvent e) {
            ManifestTree.this.editADLNavigation(this._element, this._schemaElement);
        }
    }

    class Action_EditSequencing
    extends AbstractAction {
        Element _element;
        SchemaElement _schemaElement;

        public Action_EditSequencing(Element element, SchemaElement schemaElement, String text) {
            super(text, null);
            this._element = element;
            this._schemaElement = schemaElement;
        }

        public void actionPerformed(ActionEvent e) {
            ManifestTree.this.editSequencing(this._element, this._schemaElement);
        }
    }

    class ProxyEditADLNavigationHandler
    extends ProxyAction {
        Element _element;
        SchemaElement _schemaElement;

        public ProxyEditADLNavigationHandler(Element element, SchemaElement schemaElement) {
            super((MenuAction)MainMenu.getSharedInstance().actionEditSCORM);
            this._element = element;
            this._schemaElement = schemaElement;
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ManifestTree.this.editADLNavigation(this._element, this._schemaElement);
        }
    }

    class ProxyEditSequencingHandler
    extends ProxyAction {
        Element _element;
        SchemaElement _schemaElement;

        public ProxyEditSequencingHandler(Element element, SchemaElement schemaElement) {
            super((MenuAction)MainMenu.getSharedInstance().actionEditSCORM);
            this._element = element;
            this._schemaElement = schemaElement;
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ManifestTree.this.editSequencing(this._element, this._schemaElement);
        }
    }

    class ManifestTreeDragDropHandler
    extends DweezilTreeDragDropHandler {
        public ManifestTreeDragDropHandler(DweezilTree tree) {
            super(tree);
        }

        public void dragGestureRecognized(DragGestureEvent event) {
            int action = event.getDragAction();
            if ((action & 3) == 0) {
                return;
            }
            ElementTreeNode node = (ElementTreeNode)((Object)this.getDragSourceTreeNode(event));
            if (node != null) {
                ElementBinding eb = node.createElementBinding();
                if (ManifestTree.this._contentPackage.canDragElement(eb.getElement(), action)) {
                    DragObject dragObject = new DragObject((Serializable)eb, (JComponent)((Object)ManifestTree.this));
                    Point ptDragOrigin = event.getDragOrigin();
                    TreePath path = ManifestTree.this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
                    if (path == null) {
                        return;
                    }
                    BufferedImage imgGhost = this.getDragImage(path, ptDragOrigin);
                    event.startDrag(DragSource.DefaultCopyNoDrop, imgGhost, new Point(5, 5), (Transferable)dragObject, (DragSourceListener)((Object)this));
                }
            }
        }

        public boolean isDropOK(DropTargetDragEvent event) {
            ElementTreeNode targetNode = (ElementTreeNode)((Object)this.getDragOverTreeNode(event));
            if (targetNode == null) {
                return false;
            }
            DropTargetDropEvent tempDTDropEvent = new DropTargetDropEvent(event.getDropTargetContext(), event.getLocation(), 1, 0);
            Transferable transferable = tempDTDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(DragObject.flavor)) {
                int action = DNDUtils.getCorrectDropContext((DropTargetDragEvent)event);
                if ((action & 1) != 0 || (action & 2) != 0) {
                    try {
                        Object userObject = transferable.getTransferData(DragObject.flavor);
                        if (userObject instanceof CP_Resource[]) {
                            return ManifestTree.this._contentPackage.acceptsCP_Resources(targetNode.getElement());
                        }
                        if (userObject instanceof ElementBinding) {
                            return ManifestTree.this._contentPackage.acceptElement(((ElementBinding)userObject).getElement(), targetNode.getElement(), action);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent event) {
            Point location = event.getLocation();
            TreePath treePath = ManifestTree.this.getPathForLocation(location.x, location.y);
            if (treePath == null) {
                return;
            }
            ElementTreeNode targetNode = (ElementTreeNode)((Object)treePath.getLastPathComponent());
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DragObject.flavor)) {
                event.acceptDrop(DNDUtils.getCorrectDropContext((DropTargetDropEvent)event));
                try {
                    Object userObject = transferable.getTransferData(DragObject.flavor);
                    int action = DNDUtils.getCorrectDropContext((DropTargetDropEvent)event);
                    ManifestTree.this.setCursor(DweezilUIManager.WAIT_CURSOR);
                    if (userObject instanceof CP_Resource[]) {
                        Element newElement = ManifestTree.this._contentPackage.addCP_Resources((CP_Resource[])userObject, targetNode.getElement());
                        ManifestTree.this.selectNodeByObject(newElement);
                    } else if (userObject instanceof ElementBinding) {
                        ManifestTree.this._contentPackage.shiftElement(((ElementBinding)userObject).getElement(), targetNode.getElement(), action);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    ManifestTree.this.setCursor(DweezilUIManager.DEFAULT_CURSOR);
                }
                this.hiliteNode(this._prevHilitedNode, false);
                event.getDropTargetContext().dropComplete(true);
            } else {
                event.rejectDrop();
            }
        }
    }

    class ProxyLaunchFileHandler
    extends ProxyAction {
        String url;

        public ProxyLaunchFileHandler() {
            super((MenuAction)MainMenu.getSharedInstance().actionViewFile);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            if (this.url != null) {
                Thread thread = new Thread(){

                    public void run() {
                        NativeLauncher.launchURL((String)ProxyLaunchFileHandler.this.url);
                    }
                };
                thread.start();
            }
        }

        public void update(Element element) {
            this.url = ManifestTree.this._contentPackage.getAbsoluteURL(element);
            if (this.url != null) {
                this.addListener();
                this.setEnabled(true);
            } else {
                this.clear();
            }
        }
    }

    class ProxyEditSCORMHandler
    extends ProxyAction {
        Element _element;
        SchemaElement _schemaElement;

        public ProxyEditSCORMHandler() {
            super((MenuAction)MainMenu.getSharedInstance().actionEditSCORM);
        }

        public void update(Element element, SchemaElement schemaElement) {
            this._element = element;
            this._schemaElement = schemaElement;
            this.setEnabled(true);
            this.addListener();
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ManifestTree.this.editSCORM(this._element, this._schemaElement);
        }
    }

    class ProxyEditMetadataHandler
    extends ProxyAction {
        Element _element;

        public ProxyEditMetadataHandler() {
            super((MenuAction)MainMenu.getSharedInstance().actionEditMetadata);
        }

        public void update(Element element) {
            this._element = element;
            this.setEnabled(true);
            this.addListener();
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ManifestTree.this.editMetadata(this._element);
        }
    }

    class ProxyPasteHandler
    extends ProxyAction {
        Element element;

        public ProxyPasteHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (ManifestTree.this._contentPackage.canPasteFromClipboard(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            if (ManifestTree.this._contentPackage.canPasteFromClipboard(this.element)) {
                Element clipBoardElement = XMLDocumentClipboard.getElement();
                ManifestTree.this._contentPackage.pasteElementUndoable(ManifestTree.this, clipBoardElement, this.element, false);
                ManifestTree.this.updateMenus(ManifestTree.this.getSelectionPath());
            }
        }
    }

    class ProxyCopyHandler
    extends ProxyAction {
        Element element;

        public ProxyCopyHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (ManifestTree.this._contentPackage.canCopyElement(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            XMLDocumentClipboard.addCopiedElement((Element)this.element);
            ManifestTree.this.updateMenus(ManifestTree.this.getSelectionPath());
        }
    }

    class ProxyCutHandler
    extends ProxyAction {
        Element element;

        public ProxyCutHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (ManifestTree.this._contentPackage.canCutElement(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ManifestTree.this._contentPackage.cutElementUndoable(ManifestTree.this, this.element);
            XMLDocumentClipboard.addCutElement((Element)this.element);
        }
    }

    class ProxyDeleteHandler
    extends ProxyAction {
        Element element;

        public ProxyDeleteHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (ManifestTree.this._contentPackage.canDeleteElement(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ManifestTree.this._contentPackage.deleteElementUndoable(ManifestTree.this, this.element);
        }
    }

    class ProxyMoveDownHandler
    extends ProxyAction {
        Element element;

        public ProxyMoveDownHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (ManifestTree.this._contentPackage.canMoveElementDown(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ManifestTree.this._contentPackage.moveElementDown(ManifestTree.this, this.element, true);
        }
    }

    class ProxyMoveUpHandler
    extends ProxyAction {
        Element element;

        public ProxyMoveUpHandler(MenuAction proxyMenuAction) {
            super(proxyMenuAction);
        }

        public void update(Element element) {
            this.element = element;
            if (ManifestTree.this._contentPackage.canMoveElementUp(element)) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            ManifestTree.this._contentPackage.moveElementUp(ManifestTree.this, this.element, true);
        }
    }

    class Action_JumpToRefNode
    extends AbstractAction {
        Element element;

        public Action_JumpToRefNode(Element element) {
            super(Messages.getString("uk.ac.reload.editor.contentpackaging.manifestview.ManifestTree.7"), DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/jump.gif"));
            this.element = element;
        }

        public void actionPerformed(ActionEvent e) {
            Element ref_element = ManifestTree.this._contentPackage.getReferencedElement(this.element);
            if (ref_element != null) {
                ManifestTree.this.selectNodeByObject(ref_element);
            }
        }
    }

    class Action_ExportManifest
    extends AbstractAction {
        Element element;

        public Action_ExportManifest(Element element) {
            super(Messages.getString("uk.ac.reload.editor.contentpackaging.manifestview.ManifestTree.5"), ((TreeIconInterface)ManifestTree.this._schemaController).getLeafIcon(element.getName(), element.getNamespace()));
            this.element = element;
        }

        public void actionPerformed(ActionEvent e) {
            Thread thread = new Thread(){

                public void run() {
                    ManifestTree.this._cpEditor.exportManifest(Action_ExportManifest.this.element);
                }
            };
            thread.start();
        }
    }

    class Action_ImportManifest
    extends AbstractAction {
        Element element;

        public Action_ImportManifest(Element element) {
            super(Messages.getString("uk.ac.reload.editor.contentpackaging.manifestview.ManifestTree.5"), ((TreeIconInterface)ManifestTree.this._schemaController).getLeafIcon(element.getName(), element.getNamespace()));
            this.element = element;
        }

        public void actionPerformed(ActionEvent e) {
            Thread thread = new Thread(){

                public void run() {
                    ManifestTree.this._cpEditor.importManifest(Action_ImportManifest.this.element);
                }
            };
            thread.start();
        }
    }

    class Action_EditSCORM
    extends AbstractAction {
        Element _element;
        SchemaElement _schemaElement;

        public Action_EditSCORM(Element element, SchemaElement schemaElement) {
            super(Messages.getString("uk.ac.reload.editor.contentpackaging.manifestview.ManifestTree.4"), DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/adl.gif"));
            this._element = element;
            this._schemaElement = schemaElement;
        }

        public void actionPerformed(ActionEvent e) {
            ManifestTree.this.editSCORM(this._element, this._schemaElement);
        }
    }

    class Action_EditMetadata
    extends AbstractAction {
        Element _element;

        public Action_EditMetadata(Element element) {
            super(Messages.getString("uk.ac.reload.editor.contentpackaging.manifestview.ManifestTree.3"), DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/md.gif"));
            this._element = element;
        }

        public void actionPerformed(ActionEvent e) {
            ManifestTree.this.editMetadata(this._element);
        }
    }

    class Action_AddChildElement
    extends AbstractAction {
        Element parentElement;
        SchemaElement childSchemaElement;
        String name;

        public Action_AddChildElement(Element parentElement, SchemaElement childSchemaElement) {
            this.parentElement = parentElement;
            this.childSchemaElement = childSchemaElement;
            this.name = ManifestTree.this._schemaController.getElementFriendlyName(childSchemaElement.getXMLPath());
            if (this.name == null) {
                this.name = childSchemaElement.getName();
            }
            this.putValue("Name", Messages.getString("uk.ac.reload.editor.contentpackaging.manifestview.ManifestTree.2") + " " + this.name);
            this.putValue("SmallIcon", ((TreeIconInterface)ManifestTree.this._schemaController).getLeafIcon(childSchemaElement.getName(), childSchemaElement.getNamespace()));
            this.setEnabled(ManifestTree.this._contentPackage.canAddElement(parentElement, childSchemaElement));
        }

        public void actionPerformed(ActionEvent e) {
            Element element = ManifestTree.this._contentPackage.addElementBySchemaUndoable(ManifestTree.this, this.parentElement, this.childSchemaElement, true);
        }
    }
}

