/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.editor.resourceview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.dweezil.gui.CoolBarPanel;
import uk.ac.reload.dweezil.gui.DweezilProgressMonitor;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.IComponentSelectionListener;
import uk.ac.reload.dweezil.gui.YesAllNoDialog;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.dweezil.gui.tree.DweezilTreePopupHandler;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.dweezil.util.NativeLauncher;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.datamodel.CP_Resource;
import uk.ac.reload.editor.contentpackaging.editor.resourceview.CP_ResourceChooser;
import uk.ac.reload.editor.contentpackaging.editor.resourceview.CP_ResourceImporter;
import uk.ac.reload.editor.contentpackaging.editor.resourceview.CP_ResourcesTree;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.menu.MenuAction_ImportResources;
import uk.ac.reload.editor.properties.EditorProperties;

public class CP_ResourcesPanel
extends CoolBarPanel
implements IIcons {
    private CP_ResourcesTree _resourcesTree;
    private File _rootFolder;
    private DweezilTreePopupHandler _popupMenuHandler;
    private MenuAction_Refresh _actionRefresh;
    private MenuAction_DeleteResources _actionDeleteResources;
    private MenuAction_NewFolder _actionNewFolder;
    private ProxyImportHandler _proxyImportHandler;
    private ProxyImportHandler _proxyImportHandlerLocal;
    private ProxyLaunchFileHandler _proxylaunchFileHandler;

    public CP_ResourcesPanel() {
        this.setText(Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.11"));
        this.setIcon(DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/resources.gif"));
        MenuAction_ImportResources importMenuAction = new MenuAction_ImportResources();
        importMenuAction.setEnabled(true);
        this._proxyImportHandlerLocal = new ProxyImportHandler(importMenuAction);
        this._proxyImportHandler = new ProxyImportHandler(MainMenu.getSharedInstance().actionImport);
        this._actionRefresh = new MenuAction_Refresh();
        this._actionDeleteResources = new MenuAction_DeleteResources();
        this._actionNewFolder = new MenuAction_NewFolder();
        this._proxylaunchFileHandler = new ProxyLaunchFileHandler();
        this.addMenuActionToCoolBar(this._proxyImportHandlerLocal.getMenuAction());
        this.addMenuActionToCoolBar(this._actionNewFolder);
        this.addMenuActionToCoolBar(this._actionDeleteResources);
        this.addMenuActionToCoolBar(this._actionRefresh);
        this._resourcesTree = new CP_ResourcesTree();
        JScrollPane sp = new JScrollPane((Component)((Object)this._resourcesTree));
        sp.setBorder(null);
        this.setMainComponent(sp);
        this.addComponentSelectionListener(new IComponentSelectionListener(){

            public void componentSelected(Component component) {
                CP_ResourcesPanel.this._resourcesTree.requestFocus();
            }
        });
        this._resourcesTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (!e.isAddedPath()) {
                    return;
                }
                CP_ResourcesPanel.this.updateMenus();
            }
        });
        this._resourcesTree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    CP_ResourcesPanel.this._proxylaunchFileHandler.update();
                    CP_ResourcesPanel.this._proxyImportHandler.update();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    CP_ResourcesPanel.this._proxylaunchFileHandler.clear();
                    CP_ResourcesPanel.this._proxyImportHandler.clear();
                }
            }
        });
    }

    public void setFileView(File rootFolder) {
        this._rootFolder = rootFolder;
        this._resourcesTree.setFileView(rootFolder);
    }

    public void cleanup() {
        this.clearMenus();
    }

    private synchronized void updateMenus() {
        this._actionDeleteResources.update();
        this._actionNewFolder.update();
        this._proxyImportHandler.update();
        this._proxyImportHandlerLocal.update();
        this._proxylaunchFileHandler.update();
        this._resourcesTree.getPopupMenu().removeAll();
        this._resourcesTree.getPopupMenu().add((Action)this._proxyImportHandlerLocal.getMenuAction());
        this._resourcesTree.getPopupMenu().add((Action)((Object)this._actionNewFolder));
        this._resourcesTree.getPopupMenu().add((Action)((Object)this._actionDeleteResources));
        this._resourcesTree.getPopupMenu().add((Action)this._proxylaunchFileHandler.getMenuAction());
    }

    private synchronized void clearMenus() {
        this._proxyImportHandler.clear();
        this._proxyImportHandlerLocal.clear();
        this._proxylaunchFileHandler.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importResources(CP_Resource folder) {
        CP_ResourceChooser fileChooserOption = new CP_ResourceChooser();
        int returnVal = fileChooserOption.showOpenDialog(EditorFrame.getInstance());
        if (returnVal != 0) {
            return;
        }
        File[] files = fileChooserOption.getSelectedFilesAndStore();
        DweezilProgressMonitor progressMonitor = null;
        try {
            this._proxyImportHandler.setEnabled(false);
            this._proxyImportHandlerLocal.setEnabled(false);
            progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.0"), Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.1"), "", true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
            CP_ResourceImporter importRes = new CP_ResourceImporter(files, (File)folder, fileChooserOption.isCheckboxChecked(), progressMonitor);
            if (importRes.hasImportedFiles()) {
                this.refreshResourceTree();
            }
        }
        catch (Exception ex) {
            if (EditorProperties.getString("DEBUG").equals("true")) {
                ex.printStackTrace();
            }
            ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.0"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.2"), (Exception)ex);
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            this._proxyImportHandler.setEnabled(true);
            this._proxyImportHandlerLocal.setEnabled(true);
        }
    }

    protected boolean deleteResources(CP_Resource[] resources) throws IOException {
        boolean yesToAll = false;
        boolean hasDeleted = false;
        for (int i = 0; i < resources.length; ++i) {
            CP_Resource aFile = resources[i];
            if (!aFile.exists()) continue;
            if (!yesToAll) {
                int answer = this.askConfirmDeleteFile(aFile);
                if (answer == 1) {
                    yesToAll = true;
                }
                if (answer == 0 || answer == 1) {
                    if (aFile.isDirectory()) {
                        FileUtils.deleteFolder((File)aFile);
                        hasDeleted = true;
                        continue;
                    }
                    aFile.delete();
                    hasDeleted = true;
                    continue;
                }
                if (answer != 3 && answer != -1) continue;
                return hasDeleted;
            }
            if (aFile.isDirectory()) {
                FileUtils.deleteFolder((File)aFile);
                hasDeleted = true;
                continue;
            }
            aFile.delete();
            hasDeleted = true;
        }
        return hasDeleted;
    }

    protected int askConfirmDeleteFile(CP_Resource res) {
        YesAllNoDialog dialog = new YesAllNoDialog();
        String fileOrFolder = res.isDirectory() ? Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.3") : Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.4");
        String message = res.getAbsoluteFile().toString() + System.getProperty("line.separator") + Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.5") + " " + fileOrFolder + "?";
        return dialog.getUserResponse((JFrame)EditorFrame.getInstance(), message, Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.6"));
    }

    public void refreshResourceTree() {
        this._resourcesTree.refresh();
    }

    class ProxyLaunchFileHandler
    extends ProxyAction {
        CP_Resource _resource;

        public ProxyLaunchFileHandler() {
            super((MenuAction)MainMenu.getSharedInstance().actionViewFile);
        }

        public void update() {
            DweezilTreeNode node = CP_ResourcesPanel.this._resourcesTree.getSelectedNode();
            if (node == null) {
                return;
            }
            this._resource = (CP_Resource)node.getUserObject();
            if (this._resource.isFile()) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            if (this._resource != null) {
                Thread thread = new Thread(){

                    public void run() {
                        CP_ResourcesPanel.this.setCursor(DweezilUIManager.WAIT_CURSOR);
                        NativeLauncher.launchFile((File)ProxyLaunchFileHandler.this._resource);
                        CP_ResourcesPanel.this.setCursor(DweezilUIManager.DEFAULT_CURSOR);
                    }
                };
                thread.start();
            }
        }
    }

    class MenuAction_NewFolder
    extends MenuAction {
        CP_Resource _resource;

        public MenuAction_NewFolder() {
            super(Messages.getString("uk.ac.reload.editor.menu.MenuAction_NewFolder.0"), "uk/ac/reload/editor/resources/images/folder_new.gif");
        }

        public void update() {
            DweezilTreeNode node = CP_ResourcesPanel.this._resourcesTree.getSelectedNode();
            if (node == null) {
                return;
            }
            this._resource = (CP_Resource)node.getUserObject();
            this.setEnabled(this._resource.isDirectory());
        }

        public void actionPerformed(ActionEvent e) {
            File file;
            String s;
            if (this._resource != null && (s = JOptionPane.showInputDialog(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.9"), Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.10"), -1)) != null && !(file = new File(this._resource, s)).exists()) {
                file.mkdir();
                CP_ResourcesPanel.this.refreshResourceTree();
            }
        }
    }

    class MenuAction_Refresh
    extends MenuAction {
        public MenuAction_Refresh() {
            super(Messages.getString("uk.ac.reload.editor.menu.MenuAction_Refresh.0"), "uk/ac/reload/editor/resources/images/refresh.gif");
        }

        public void actionPerformed(ActionEvent e) {
            Thread thread = new Thread(){

                public void run() {
                    CP_ResourcesPanel.this.setCursor(DweezilUIManager.WAIT_CURSOR);
                    MenuAction_Refresh.this.setEnabled(false);
                    CP_ResourcesPanel.this.refreshResourceTree();
                    MenuAction_Refresh.this.setEnabled(true);
                    CP_ResourcesPanel.this.setCursor(DweezilUIManager.DEFAULT_CURSOR);
                }
            };
            thread.start();
        }
    }

    class MenuAction_DeleteResources
    extends MenuAction {
        public MenuAction_DeleteResources() {
            super(Messages.getString("uk.ac.reload.editor.menu.MenuAction_DeleteResources.0"), "uk/ac/reload/editor/resources/images/delete.gif");
        }

        public void update() {
            DweezilTreeNode node = CP_ResourcesPanel.this._resourcesTree.getSelectedNode();
            if (node == null) {
                return;
            }
            CP_Resource resource = (CP_Resource)node.getUserObject();
            this.setEnabled(!resource.equals(CP_ResourcesPanel.this._rootFolder));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CP_Resource[] resources = CP_ResourcesPanel.this._resourcesTree.getSelectedResourcesToDelete();
                boolean hasDeleted = CP_ResourcesPanel.this.deleteResources(resources);
                if (hasDeleted) {
                    CP_ResourcesPanel.this._resourcesTree.setSelectionRow(0);
                    CP_ResourcesPanel.this._resourcesTree.refresh();
                }
            }
            catch (IOException ex) {
                if (EditorProperties.getString("DEBUG").equals("true")) {
                    ex.printStackTrace();
                }
                ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.7"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourcesPanel.8"), (Exception)ex);
            }
        }
    }

    class ProxyImportHandler
    extends ProxyAction {
        CP_Resource _resource;

        public ProxyImportHandler(MenuAction menuAction) {
            super(menuAction);
        }

        public void update() {
            DweezilTreeNode node = CP_ResourcesPanel.this._resourcesTree.getSelectedNode();
            if (node == null) {
                return;
            }
            this._resource = (CP_Resource)node.getUserObject();
            if (this._resource.isDirectory()) {
                this.setEnabled(true);
                this.addListener();
            } else {
                this.clear();
            }
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            Thread thread = new Thread(){

                public void run() {
                    if (ProxyImportHandler.this._resource != null) {
                        CP_ResourcesPanel.this.importResources(ProxyImportHandler.this._resource);
                    }
                }
            };
            thread.start();
        }
    }
}

