/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.editor.gui.AttributeEditor;
import uk.ac.reload.editor.gui.ElementEditor;

public class ElementAttributePanel
extends JPanel {
    private ElementEditor _elementPanel;
    private AttributeEditor _attrPanel;
    private JSplitPane _splitPane;

    public ElementAttributePanel() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this._elementPanel = this.createElementEditor();
        this._attrPanel = this.createAttributeEditor();
        this._splitPane = new JSplitPane(0);
        this._splitPane.setOneTouchExpandable(true);
        this._splitPane.setTopComponent(this._elementPanel);
        this._splitPane.setBottomComponent(this._attrPanel);
        this.add((Component)this._splitPane, "Center");
    }

    public void initView() {
        this._splitPane.setDividerLocation(0.12);
    }

    protected ElementEditor createElementEditor() {
        return new ElementEditor();
    }

    protected AttributeEditor createAttributeEditor() {
        return new AttributeEditor();
    }

    public ElementEditor getElementEditor() {
        return this._elementPanel;
    }

    public AttributeEditor getAttributeEditor() {
        return this._attrPanel;
    }

    public JSplitPane getSplitpane() {
        return this._splitPane;
    }

    public void setElementBinding(ElementBinding elementBinding) {
        this._elementPanel.setElementBinding(elementBinding);
        this._attrPanel.setElementBinding(elementBinding);
    }

    public void clear() {
    }

    public void cleanup() {
        this._elementPanel.cleanup();
        this._attrPanel.cleanup();
    }
}

