/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.editor.gui.widgets.TextPaneWidget;
import uk.ac.reload.editor.gui.widgets.Widget;
import uk.ac.reload.editor.gui.widgets.WidgetFactory;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.moonunit.SchemaDocument;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class ElementEditor
extends JPanel
implements XMLDocumentListener,
DocumentListener {
    protected ElementBinding _elementBinding;
    private Widget _widget;
    private boolean _allowNotification = true;

    public ElementEditor() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
    }

    public void setElementBinding(ElementBinding elementBinding) {
        if (this._elementBinding != null) {
            this._elementBinding.getSchemaDocument().removeXMLDocumentListener((XMLDocumentListener)this);
        }
        this._elementBinding = elementBinding;
        this._elementBinding.getSchemaDocument().addXMLDocumentListener((XMLDocumentListener)this);
        this.setupWidget(this._elementBinding.getSchemaDocument(), this._elementBinding.getElement(), this._elementBinding.getSchemaElement());
    }

    public ElementBinding getElementBinding() {
        return this._elementBinding;
    }

    protected void setupWidget(SchemaDocument doc, Element element, SchemaElement schemaElement) {
        boolean enabled;
        if (this._widget != null) {
            this._widget.removeDocumentListener(this);
        }
        this.removeAll();
        boolean bl = enabled = schemaElement == null ? true : schemaElement.isValue();
        if (enabled) {
            this._widget = WidgetFactory.getWidget(doc.getSchemaController(), schemaElement);
            if (this._widget.isSingleLine()) {
                this.add((Component)((Object)this._widget), "North");
            } else if (this._widget instanceof TextPaneWidget) {
                JScrollPane scrollPane = new JScrollPane((Component)((Object)this._widget));
                this.add((Component)scrollPane, "Center");
            } else {
                this.add((Component)((Object)this._widget), "Center");
            }
            this.setText(element);
            this._widget.addDocumentListener(this);
        }
    }

    public Widget getWidget() {
        return this._widget;
    }

    protected void setText(Element element) {
        this._allowNotification = false;
        if (this._widget != null) {
            this._widget.setTextValue(element == null ? "" : element.getText());
        }
        this._allowNotification = true;
    }

    public void insertText(String text) {
        if (this._widget != null) {
            this._widget.insertTextValue(text);
        }
    }

    public void setFocus() {
        if (this._widget != null) {
            ((Component)((Object)this._widget)).requestFocus();
        }
    }

    public void cleanup() {
        if (this._elementBinding != null) {
            this._elementBinding.getSchemaDocument().removeXMLDocumentListener((XMLDocumentListener)this);
        }
        if (this._widget != null) {
            this._widget.removeDocumentListener(this);
        }
    }

    protected synchronized void fireElementChanged(String text) {
        Element element = this._elementBinding.getElement();
        if (element == null) {
            element = this._elementBinding.createElement(this);
        }
        if (element != null) {
            element.setText(text);
            this._elementBinding.getSchemaDocument().changedElement((Object)this, element);
        }
    }

    public void elementChanged(XMLDocumentListenerEvent event) {
        Element changed_element;
        if (event.getSource() == this) {
            return;
        }
        Element element = this._elementBinding.getElement();
        if (element != null && element == (changed_element = event.getElement())) {
            this.setText(element);
        }
    }

    public void elementRemoved(XMLDocumentListenerEvent event) {
    }

    public void elementAdded(XMLDocumentListenerEvent event) {
    }

    public void documentSaved(XMLDocument doc) {
    }

    public void removeUpdate(DocumentEvent evt) {
        if (this._allowNotification && this._widget != null) {
            this.fireElementChanged(this._widget.getTextValue());
        }
    }

    public void changedUpdate(DocumentEvent evt) {
        if (this._allowNotification && this._widget != null) {
            this.fireElementChanged(this._widget.getTextValue());
        }
    }

    public void insertUpdate(DocumentEvent evt) {
        if (this._allowNotification && this._widget != null) {
            this.fireElementChanged(this._widget.getTextValue());
        }
    }
}

