/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.editor.gui.ElementAttributePanel;
import uk.ac.reload.editor.gui.TipPanel;

public class ElementInfoPanel
extends JPanel {
    private JPanel _mainPanel;
    private TipPanel _tipPanel;
    JSplitPane _splitPane;
    private ElementAttributePanel _elementAttPanel;

    public ElementInfoPanel() {
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(0, 0));
        this._splitPane = new JSplitPane(1);
        this._splitPane.setOneTouchExpandable(true);
        this._elementAttPanel = this.createElementAttributePanel();
        this._tipPanel = new TipPanel();
        this._splitPane.setLeftComponent(this._elementAttPanel);
        this._splitPane.setRightComponent((Component)((Object)this._tipPanel));
        this.add((Component)this._splitPane, "Center");
    }

    public void initView() {
        this._splitPane.setDividerLocation(0.5);
        this._elementAttPanel.initView();
    }

    protected ElementAttributePanel createElementAttributePanel() {
        return new ElementAttributePanel();
    }

    protected JPanel setupMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(1, 2));
        mainPanel.setOpaque(false);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return mainPanel;
    }

    public void setElementBinding(ElementBinding elementBinding) {
        this._tipPanel.setTip(elementBinding.getSchemaController(), elementBinding.getSchemaElement());
        this._elementAttPanel.setElementBinding(elementBinding);
        this.validate();
        this.repaint();
    }

    public void clear() {
        this._tipPanel.clear();
        this._elementAttPanel.clear();
    }

    public void cleanup() {
        this._elementAttPanel.cleanup();
    }
}

