/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.reload.editor.gui.widgets.TextFieldWidget;
import uk.ac.reload.editor.gui.widgets.Widget;

public class ListBoxWidget
extends JPanel
implements Widget,
ListSelectionListener {
    private int _maxLength;
    private TextFieldWidget _textField = new TextFieldWidget();
    private JList _listBox;

    public ListBoxWidget() {
        super(new BorderLayout());
        this.add((Component)this._textField, "North");
        this._listBox = new JList();
        this._listBox.setSelectionMode(0);
        this.add((Component)new JScrollPane(this._listBox), "Center");
        this._listBox.addListSelectionListener(this);
    }

    public TextFieldWidget getTextFieldWidget() {
        return this._textField;
    }

    public JList getListBox() {
        return this._listBox;
    }

    public void setListData(Object[] values) {
        this._listBox.setListData(values);
    }

    public void setTextValue(String value) {
        this._listBox.setSelectedValue(value, true);
        this._textField.setText(value);
    }

    public void insertTextValue(String text) {
    }

    public String getTextValue() {
        return this._textField.getText();
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
        this._textField.setMaxLength(maxLength);
    }

    public boolean isSingleLine() {
        return false;
    }

    public void addDocumentListener(DocumentListener dl) {
        this._textField.addDocumentListener(dl);
    }

    public void removeDocumentListener(DocumentListener dl) {
        this._textField.removeDocumentListener(dl);
    }

    public void setEnabled(boolean enabled) {
        this._textField.setEnabled(enabled);
        this._listBox.setEnabled(enabled);
    }

    public void valueChanged(ListSelectionEvent e) {
        Object object;
        if (e.getSource() == this._listBox && (object = this._listBox.getSelectedValue()) != null) {
            this._textField.setText(object.toString());
        }
    }
}

