/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui.widgets;

import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import uk.ac.reload.editor.gui.widgets.Widget;

public class TextFieldWidget
extends JTextField
implements Widget {
    private int _maxLength;
    private boolean _doVerify = true;

    public TextFieldWidget() {
        this(-1);
    }

    public TextFieldWidget(int maxLength) {
        this.setMaxLength(maxLength);
        this.setDocument(new TextFieldVerifier());
        this.setUI();
    }

    public void insertTextValue(String text) {
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    protected void setUI() {
    }

    public void updateUI() {
        super.updateUI();
        this.setUI();
    }

    public void setTextValue(String value) {
        this.setText(value);
    }

    public void setText(String value) {
        this._doVerify = false;
        super.setText(value);
        this._doVerify = true;
    }

    public String getTextValue() {
        return this.getText();
    }

    public boolean isSingleLine() {
        return true;
    }

    public void addDocumentListener(DocumentListener dl) {
        this.getDocument().addDocumentListener(dl);
    }

    public void removeDocumentListener(DocumentListener dl) {
        this.getDocument().removeDocumentListener(dl);
    }

    protected class TextFieldVerifier
    extends PlainDocument {
        protected TextFieldVerifier() {
        }

        public void insertString(int offset, String str, AttributeSet attSet) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (TextFieldWidget.this._doVerify) {
                boolean valid = this.isLengthOK(str);
                if (!valid) {
                    return;
                }
                valid = this.isStringOK(str);
                if (!valid) {
                    return;
                }
            }
            super.insertString(offset, str, attSet);
        }

        boolean isStringOK(String str) {
            return true;
        }

        boolean isLengthOK(String str) throws BadLocationException {
            String oldStr;
            return TextFieldWidget.this._maxLength == -1 || (oldStr = this.getText(0, this.getLength())).length() + str.length() <= TextFieldWidget.this._maxLength;
        }
    }
}

