/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.environments;

import java.util.Vector;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.learningdesign.datamodel.ItemType;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.MetadataType;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Learner;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Learner_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Role;
import uk.ac.reload.jdom.XMLPath;

public class Conference
extends Service {
    public static XMLPath XMLPATH = new XMLPath(XMLPATH_ROOT_LD).appendElementName("components/environments/environment/service/conference");
    static final String DESCRIPTION = "Conference Service.";
    private ItemType _itemType;
    private MetadataType _mdType;
    private Role[] _participants;
    private Role[] _observers;

    public Conference(LD_DataModel ldDataModel, Element element) {
        super(ldDataModel, element);
        this.setDescription(DESCRIPTION);
        ldDataModel.addIDataModelListener(this);
    }

    public void setElement(Element element) {
        super.setElement(element);
        this.ensureDefaults();
    }

    protected void ensureDefaults() {
        this.ensureAllReferences();
        this.ensureDefaultParticipant();
        this.ensureAttribute(this.getElement(), "conference-type", "synchronous");
    }

    protected boolean ensureAllReferences() {
        boolean modified = this.ensureReferences(this.getElement(), "participant", "role-ref", this.getLD_DataModel().getRoles_Grouping());
        modified |= this.ensureReferences(this.getElement(), "observer", "role-ref", this.getLD_DataModel().getRoles_Grouping());
        modified |= this.ensureReferences(this.getElement(), "conference-manager", "role-ref", this.getLD_DataModel().getRoles_Grouping());
        return modified |= this.ensureReferences(this.getElement(), "moderator", "role-ref", this.getLD_DataModel().getRoles_Grouping());
    }

    protected boolean ensureDefaultParticipant() {
        Learner_Grouping learnerGrouping;
        Learner learner;
        boolean modified = false;
        Role[] participants = this.getParticipants();
        if (participants.length == 0 && (learner = (Learner)(learnerGrouping = this.getLD_DataModel().getRoles_Grouping().getLearner_Grouping()).getChildAt(0)) != null) {
            this.addParticipant(learner);
            modified = true;
        }
        return modified;
    }

    public Role[] getParticipants() {
        if (this._participants == null) {
            Vector<LD_Component> v = new Vector<LD_Component>();
            for (Element element : this.getElement().getChildren("participant", this.getElement().getNamespace())) {
                String ref = element.getAttributeValue("role-ref");
                LD_Component component = this.getLD_DataModel().getRoles_Grouping().getChildByIdentifer(ref);
                if (component == null) continue;
                v.add(component);
            }
            this._participants = new Role[v.size()];
            v.copyInto(this._participants);
        }
        return this._participants;
    }

    public void addParticipant(Role role) {
        this.addRef(role, this.getElement(), "participant", "role-ref");
        this._participants = null;
    }

    public void removeParticipant(Role role) {
        this.removeRef(role, this.getElement(), "participant", "role-ref");
        this._participants = null;
    }

    public boolean isParticipant(Role role) {
        if (role == null) {
            return false;
        }
        String id = role.getIdentifier();
        if (id == null || "".equals(id)) {
            return false;
        }
        Role[] participants = this.getParticipants();
        for (int i = 0; i < participants.length; ++i) {
            String id2 = participants[i].getIdentifier();
            if (!id.equals(id2)) continue;
            return true;
        }
        return false;
    }

    public boolean isLastParticipant() {
        return this.getElement().getChildren("participant", this.getElement().getNamespace()).size() == 1;
    }

    public Role[] getObservers() {
        if (this._observers == null) {
            Vector<LD_Component> v = new Vector<LD_Component>();
            for (Element element : this.getElement().getChildren("observer", this.getElement().getNamespace())) {
                String ref = element.getAttributeValue("role-ref");
                LD_Component component = this.getLD_DataModel().getRoles_Grouping().getChildByIdentifer(ref);
                if (component == null) continue;
                v.add(component);
            }
            this._observers = new Role[v.size()];
            v.copyInto(this._observers);
        }
        return this._observers;
    }

    public void addObserver(Role role) {
        this.addRef(role, this.getElement(), "observer", "role-ref");
        this._observers = null;
    }

    public void removeObserver(Role role) {
        this.removeRef(role, this.getElement(), "observer", "role-ref");
        this._observers = null;
    }

    public boolean isObserver(Role role) {
        if (role == null) {
            return false;
        }
        String id = role.getIdentifier();
        if (id == null || "".equals(id)) {
            return false;
        }
        Role[] observers = this.getObservers();
        for (int i = 0; i < observers.length; ++i) {
            String id2 = observers[i].getIdentifier();
            if (!id.equals(id2)) continue;
            return true;
        }
        return false;
    }

    public Role getManager() {
        Role manager = null;
        Element element = this.getElement().getChild("conference-manager", this.getElement().getNamespace());
        if (element != null) {
            String ref = element.getAttributeValue("role-ref");
            manager = (Role)this.getLD_DataModel().getRoles_Grouping().getChildByIdentifer(ref);
        }
        return manager;
    }

    public void addManager(Role role) {
        this.removeManager(this.getManager());
        this.addRef(role, this.getElement(), "conference-manager", "role-ref");
    }

    public void removeManager(Role role) {
        this.removeRef(role, this.getElement(), "conference-manager", "role-ref");
    }

    public boolean isManager(Role role) {
        String id2;
        if (role == null) {
            return false;
        }
        String id = role.getIdentifier();
        if (id == null || "".equals(id)) {
            return false;
        }
        Role manager = this.getManager();
        return manager != null && id.equals(id2 = manager.getIdentifier());
    }

    public Role getModerator() {
        Role moderator = null;
        Element element = this.getElement().getChild("moderator", this.getElement().getNamespace());
        if (element != null) {
            String ref = element.getAttributeValue("role-ref");
            moderator = (Role)this.getLD_DataModel().getRoles_Grouping().getChildByIdentifer(ref);
        }
        return moderator;
    }

    public void addModerator(Role role) {
        this.removeModerator(this.getModerator());
        this.addRef(role, this.getElement(), "moderator", "role-ref");
    }

    public void removeModerator(Role role) {
        this.removeRef(role, this.getElement(), "moderator", "role-ref");
    }

    public boolean isModerator(Role role) {
        String id2;
        if (role == null) {
            return false;
        }
        String id = role.getIdentifier();
        if (id == null || "".equals(id)) {
            return false;
        }
        Role moderator = this.getModerator();
        return moderator != null && id.equals(id2 = moderator.getIdentifier());
    }

    public ItemType getItemType() {
        if (this._itemType == null) {
            this._itemType = new ItemType(this.getDataElement(), "Conference", "Conference");
        }
        return this._itemType;
    }

    public MetadataType getMetadataType() {
        if (this._mdType == null) {
            this._mdType = new MetadataType(this.getDataElement(), "Metadata", "Metadata for the Conference.");
        }
        return this._mdType;
    }

    public String getDefaultTitle() {
        return "Conference";
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/conference.gif");
    }

    public XMLPath getXMLPath() {
        return XMLPATH;
    }

    public void componentRemoved(DataComponent component) {
        boolean modified;
        if (component instanceof Role && (modified = this.ensureAllReferences())) {
            this._participants = null;
            this._observers = null;
            this.ensureDefaultParticipant();
            this.getDataModel().fireDataComponentChanged(this);
        }
    }
}

