/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.environments;

import java.util.Vector;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.LearningObject;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.SchemaDocument;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class Environments_Grouping
extends LD_Grouping
implements IDataComponentIcon {
    public static XMLPath XMLPATH = new XMLPath(XMLPATH_ROOT_LD).appendElementName("components/environments");
    static final String TITLE = "Environments";
    static final String DESCRIPTION = "Add Environments to the Learning Design.";

    public Environments_Grouping(LD_DataModel ldDataModel) {
        this.setDataModel(ldDataModel);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.addChildren();
        this.updateEnvironmentRefs();
        ldDataModel.addIDataModelListener(this);
    }

    protected Element ensureEnvironmentsElement() {
        Element elementEnvs = this.getEnvironmentsElement();
        if (elementEnvs == null) {
            SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
            SchemaElement schemaElement = (SchemaElement)schemaDocument.getSchemaController().getSchemaNode(XMLPATH);
            elementEnvs = schemaDocument.addElementUniqueBySchema((Object)this, schemaElement, false);
            this.setElement(elementEnvs);
        }
        return elementEnvs;
    }

    public Element getEnvironmentsElement() {
        SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
        return schemaDocument.getElement(XMLPATH);
    }

    public LearningObject[] getLearningObjects() {
        Vector<DataComponent> v = new Vector<DataComponent>();
        DataComponent[] envs = this.getChildren();
        for (int i = 0; i < envs.length; ++i) {
            Environment env = (Environment)envs[i];
            DataComponent[] los = env.getLearningObject_Grouping().getChildren();
            for (int j = 0; j < los.length; ++j) {
                v.add(los[j]);
            }
        }
        Object[] los = new LearningObject[v.size()];
        v.copyInto(los);
        return los;
    }

    public Service[] getServices() {
        Vector<DataComponent> v = new Vector<DataComponent>();
        DataComponent[] envs = this.getChildren();
        for (int i = 0; i < envs.length; ++i) {
            Environment env = (Environment)envs[i];
            DataComponent[] los = env.getService_Grouping().getChildren();
            for (int j = 0; j < los.length; ++j) {
                v.add(los[j]);
            }
        }
        Object[] services = new Service[v.size()];
        v.copyInto(services);
        return services;
    }

    protected void addChildren() {
        Element elementEnvs = this.getEnvironmentsElement();
        if (elementEnvs != null) {
            this.setElement(elementEnvs);
            for (Element child : elementEnvs.getChildren("environment", elementEnvs.getNamespace())) {
                Environment env = new Environment(this.getLD_DataModel(), child);
                this.addChild(env);
            }
        }
    }

    private void updateEnvironmentRefs() {
        DataComponent[] envs = this.getChildren();
        for (int i = 0; i < envs.length; ++i) {
            Environment env = (Environment)envs[i];
            env.getEnvironmentRef_Grouping().updateEnvironmentRefs(this);
        }
    }

    public DataComponent addChildElement(String elementName, String title) {
        if (!"environment".equals(elementName)) {
            return null;
        }
        Element element = null;
        Environment environment = null;
        Element elementEnvs = this.getEnvironmentsElement();
        if (elementEnvs == null) {
            elementEnvs = this.ensureEnvironmentsElement();
            element = elementEnvs.getChild("environment", elementEnvs.getNamespace());
        } else {
            element = this.addChildElement(this.getElement(), elementName);
        }
        if (element != null) {
            environment = new Environment(this.getLD_DataModel(), element);
            this.addChild(environment);
            if (title != null) {
                environment.setTitle(title);
            }
            this.getDataModel().fireDataComponentAdded(environment);
        }
        return environment;
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/environments.gif");
    }

    public void componentRemoved(DataComponent component) {
        Element elementEnvs;
        if (component instanceof Environment && !this.hasChildren() && (elementEnvs = this.getEnvironmentsElement()) != null) {
            elementEnvs.getParent().getContent().remove(elementEnvs);
        }
    }
}

