/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.environments;

import java.util.Vector;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.MetadataType;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.SchemaDocument;

public class IndexSearch
extends Service {
    public static XMLPath XMLPATH = new XMLPath(XMLPATH_ROOT_LD).appendElementName("components/environments/environment/service/index-search");
    public static final String DESCRIPTION = "Index Search Service.";
    public static final String[] ELEMENT_NAMES = new String[]{"environment", "learning-object", "send-mail", "conference", "index-search", "learning-activity", "support-activity", "activity-structure"};
    private MetadataType _mdType;

    protected IndexSearch(LD_DataModel ldDataModel, Element element) {
        super(ldDataModel, element);
        this.setDescription(DESCRIPTION);
        ldDataModel.addIDataModelListener(this);
    }

    public void setElement(Element element) {
        super.setElement(element);
        this.ensureDefaults();
    }

    protected void ensureDefaults() {
        Element searchElement = this.ensureChildElement(this.getElement(), "search");
        this.ensureAttribute(searchElement, "search-type", "free-text-search");
    }

    public DataElement getIndexDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("index"));
    }

    public DataElement getSearchDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("search"));
    }

    public String[] getIndexClasses() {
        Vector<String> v = new Vector<String>();
        Element elIndex = this.getElement().getChild("index", this.getElement().getNamespace());
        if (elIndex != null) {
            for (Element element : elIndex.getChildren("index-class", elIndex.getNamespace())) {
                v.add(element.getText());
            }
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public void addIndexClass(String name) {
        if (name == null || "".equals(name)) {
            return;
        }
        Element elIndex = this.getElement().getChild("index", this.getElement().getNamespace());
        Element element = this.getChildElementByTextValue(elIndex, "index-class", name);
        if (element != null) {
            return;
        }
        elIndex = this.ensureChildElement(this.getElement(), "index");
        element = this.addChildElement(elIndex, "index-class");
        element.setText(name);
        this.getDataModel().fireDataComponentChanged(this);
    }

    public void removeIndexClass(String name) {
        Element element;
        if (name == null) {
            return;
        }
        Element elIndex = this.getElement().getChild("index", this.getElement().getNamespace());
        if (elIndex != null && (element = this.getChildElementByTextValue(elIndex, "index-class", name)) != null) {
            SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
            schemaDocument.removeElement((Object)this, element);
            this.getDataModel().fireDataComponentChanged(this);
        }
    }

    public LD_Component[] getIndexElements() {
        Vector<LD_Component> v = new Vector<LD_Component>();
        Element elIndex = this.getElement().getChild("index", this.getElement().getNamespace());
        if (elIndex != null) {
            for (Element element : elIndex.getChildren("index-element", elIndex.getNamespace())) {
                String index = element.getAttributeValue("index");
                LD_Component component = this.getLD_DataModel().getChildByIdentifer(index);
                if (component == null) continue;
                v.add(component);
            }
        }
        Object[] components = new LD_Component[v.size()];
        v.copyInto(components);
        return components;
    }

    public void addIndexElement(LD_Component component) {
        Element elIndex = this.ensureChildElement(this.getElement(), "index");
        this.addRef(component, elIndex, "index-element", "index");
    }

    public void removeIndexElement(LD_Component component) {
        Element elIndex = this.getElement().getChild("index", this.getElement().getNamespace());
        this.removeRef(component, elIndex, "index-element", "index");
    }

    public String[] getIndexTypeOfElements() {
        Vector<String> v = new Vector<String>();
        Element elIndex = this.getElement().getChild("index", this.getElement().getNamespace());
        if (elIndex != null) {
            for (Element element : elIndex.getChildren("index-type-of-element", elIndex.getNamespace())) {
                v.add(element.getText());
            }
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public void addIndexTypeOfElement(String name) {
        if (name == null || "".equals(name)) {
            return;
        }
        Element elIndex = this.getElement().getChild("index", this.getElement().getNamespace());
        Element element = this.getChildElementByTextValue(elIndex, "index-type-of-element", name);
        if (element != null) {
            return;
        }
        elIndex = this.ensureChildElement(this.getElement(), "index");
        element = this.addChildElement(elIndex, "index-type-of-element");
        element.setText(name);
        this.getDataModel().fireDataComponentChanged(this);
    }

    public void removeIndexTypeOfElement(String name) {
        Element element;
        if (name == null) {
            return;
        }
        Element elIndex = this.getElement().getChild("index", this.getElement().getNamespace());
        if (elIndex != null && (element = this.getChildElementByTextValue(elIndex, "index-type-of-element", name)) != null) {
            SchemaDocument schemaDocument = this.getDataModel().getSchemaDocument();
            schemaDocument.removeElement((Object)this, element);
            this.getDataModel().fireDataComponentChanged(this);
        }
    }

    public MetadataType getMetadataType() {
        if (this._mdType == null) {
            this._mdType = new MetadataType(this.getDataElement(), "Metadata", "Metadata for the Index Search.");
        }
        return this._mdType;
    }

    public String getDefaultTitle() {
        return "Index Search";
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/index_search.gif");
    }

    public XMLPath getXMLPath() {
        return XMLPATH;
    }

    public void componentRemoved(DataComponent component) {
        this.removeIndexElement((LD_Component)component);
    }
}

