/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.environments;

import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.LearningObject;

public class LearningObject_Grouping
extends LD_Grouping
implements IDataComponentIcon {
    static final String TITLE = "Learning Objects";
    static final String DESCRIPTION = "Add Learning Objects to the Learning Design.";

    public LearningObject_Grouping(LD_DataModel ldDataModel, Environment environment) {
        this.setDataModel(ldDataModel);
        this.setElement(environment.getElement());
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.addChildren();
    }

    protected void addChildren() {
        for (Element element : this.getElement().getChildren("learning-object", this.getElement().getNamespace())) {
            LearningObject ldComponent = new LearningObject(this.getLD_DataModel(), element);
            this.addChild(ldComponent);
        }
    }

    public DataComponent addChildElement(String elementName, String title) {
        if (!"learning-object".equals(elementName)) {
            return null;
        }
        LearningObject ldComponent = null;
        Element element = this.addChildElement(this.getElement(), elementName);
        if (element != null) {
            ldComponent = new LearningObject(this.getLD_DataModel(), element);
            this.addChild(ldComponent);
            if (title != null) {
                ((DataComponent)ldComponent).setTitle(title);
            }
            this.getDataModel().fireDataComponentAdded(ldComponent);
        }
        return ldComponent;
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/learning_objects.gif");
    }
}

