/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.method;

import java.util.Vector;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.ItemModelType;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.MetadataType;
import uk.ac.reload.editor.learningdesign.datamodel.method.RolePart;
import uk.ac.reload.jdom.XMLPath;

public class Act
extends LD_Component
implements IDataComponentIcon {
    public static XMLPath XMLPATH = new XMLPath(XMLPATH_ROOT_LD).appendElementName("method/play/act");
    static final String DEFAULT_TITLE = "Act";
    static final String DESCRIPTION = "This section provides information about the Act.";
    static final String FEEDBACKDESCRIPTION_TITLE = "Completion Feedback Description";
    static final String FEEDBACKDESCRIPTION_DESCRIPTION = "May be used to provide additional information about the Completion of this Act.";
    private ItemModelType _feedbackdescription;
    private MetadataType _mdType;

    public Act(LD_DataModel ldDataModel, Element element) {
        this.setDataModel(ldDataModel);
        this.setElement(element);
        this.setDescription(DESCRIPTION);
        this.addChildren();
        ldDataModel.addIDataModelListener(this);
    }

    public void setElement(Element element) {
        super.setElement(element);
        if (this.getIdentifier() == null) {
            this.addIdentifier();
        }
        this.ensureTitleElement();
    }

    protected void addChildren() {
        for (Element child : this.getElement().getChildren("role-part", this.getElement().getNamespace())) {
            RolePart rolePart = new RolePart(this.getLD_DataModel(), child);
            this.addChild(rolePart);
        }
        this.ensureChildElement(this.getElement(), "role-part");
    }

    public DataComponent addChildElement(String elementName, String title) {
        if (!"role-part".equals(elementName)) {
            return null;
        }
        RolePart rolePart = null;
        Element element = this.addChildElement(this.getElement(), elementName);
        if (element != null) {
            rolePart = new RolePart(this.getLD_DataModel(), element);
            this.addChild(rolePart);
            if (title != null) {
                rolePart.setTitle(title);
            }
            this.getDataModel().fireDataComponentAdded(rolePart);
        }
        return rolePart;
    }

    public RolePart[] getRolePartsCompleted() {
        Vector<LD_Component> v = new Vector<LD_Component>();
        Element elementCompleteAct = this.getElement().getChild("complete-act", this.getElement().getNamespace());
        if (elementCompleteAct != null) {
            for (Element element : elementCompleteAct.getChildren("when-role-part-completed", elementCompleteAct.getNamespace())) {
                String ref = element.getAttributeValue("ref");
                LD_Component component = this.getChildByIdentifer(ref);
                if (component == null) continue;
                v.add(component);
            }
        }
        Object[] roleparts = new RolePart[v.size()];
        v.copyInto(roleparts);
        return roleparts;
    }

    public void addRolePartCompleted(RolePart rolePart) {
        DataElement completeAct = this.getCompleteActDataElement();
        Element element = completeAct.createElement();
        this.addRef(rolePart, element, "when-role-part-completed", "ref");
    }

    public void removeRolePartCompleted(RolePart rolePart) {
        DataElement completeAct = this.getCompleteActDataElement();
        this.removeRef(rolePart, completeAct.getElement(), "when-role-part-completed", "ref");
        if (this.getRolePartsCompleted().length == 0) {
            completeAct.deleteElement();
        }
    }

    public void moveRolePartCompletedUp(RolePart rolePart) {
        DataElement completeAct = this.getCompleteActDataElement();
        this.moveRefUp(rolePart, completeAct.getElement(), "when-role-part-completed", "ref");
    }

    public void moveRolePartCompletedDown(RolePart rolePart) {
        DataElement completeAct = this.getCompleteActDataElement();
        this.moveRefDown(rolePart, completeAct.getElement(), "when-role-part-completed", "ref");
    }

    protected boolean ensureAllReferences() {
        DataElement completeAct = this.getCompleteActDataElement();
        Element parent = completeAct.getElement();
        if (parent == null) {
            return false;
        }
        boolean modified = this.ensureReferences(parent, "when-role-part-completed", "ref", this);
        if (this.getRolePartsCompleted().length == 0) {
            completeAct.deleteElement();
        }
        return modified;
    }

    public ItemModelType getFeedbackDescriptionItemModelType() {
        if (this._feedbackdescription == null) {
            DataElement dataElement = new DataElement(this.getDataModel(), this.getElement(), new XMLPath("on-completion/feedback-description"));
            this._feedbackdescription = new ItemModelType(dataElement, FEEDBACKDESCRIPTION_TITLE, FEEDBACKDESCRIPTION_DESCRIPTION);
        }
        return this._feedbackdescription;
    }

    public DataElement getCompleteActDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("complete-act"));
    }

    public DataElement getWhenRolePartCompletedDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("complete-act/when-role-part-completed"));
    }

    public DataElement getTimeLimitDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("complete-act/time-limit"));
    }

    public DataElement getWhenPropertyValueSetDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("complete-act/when-property-value-is-set"));
    }

    public DataElement getWhenConditionTrueDataElement() {
        return new DataElement(this.getDataModel(), this.getElement(), new XMLPath("complete-act/when-condition-true"));
    }

    public void setTitle(String title) {
        this.setTitleElement(title);
    }

    public boolean canDelete() {
        return this.getParent() == null ? true : this.getParent().getChildren().length > 1;
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/act.gif");
    }

    public XMLPath getXMLPath() {
        return XMLPATH;
    }

    public String getDefaultTitle() {
        return DEFAULT_TITLE;
    }

    public MetadataType getMetadataType() {
        if (this._mdType == null) {
            this._mdType = new MetadataType(this.getDataElement(), "Metadata", "Metadata for the Act.");
        }
        return this._mdType;
    }

    public void componentRemoved(DataComponent component) {
        boolean modified;
        if (component instanceof RolePart && (modified = this.ensureAllReferences())) {
            this.getDataModel().fireDataComponentChanged(this);
        }
    }
}

