/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.resources;

import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.MetadataType;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Dependency;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_File;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;

public class LD_Resource
extends LD_Component
implements IDataComponentIcon {
    private MetadataType _mdType;

    public LD_Resource(LD_DataModel ldDataModel, Element resourceElement) {
        this.setDataModel(ldDataModel);
        this.setElement(resourceElement);
        this.addChildren();
        ldDataModel.getLearningDesign().addXMLDocumentListener(this);
    }

    public void setElement(Element element) {
        String val;
        super.setElement(element);
        if (element != null && ((val = element.getAttributeValue("type")) == null || "".equals(val))) {
            element.setAttribute("type", "webcontent");
        }
    }

    protected void addChildren() {
        if (this.getElement() != null) {
            this.addChildren(this.getElement(), "file");
            this.addChildren(this.getElement(), "dependency");
        }
    }

    protected void addChildren(Element parentElement, String childName) {
        for (Element element : parentElement.getChildren(childName, parentElement.getNamespace())) {
            LD_Component ldComponent = this.createComponent(element);
            if (ldComponent == null) continue;
            this.addChild(ldComponent);
        }
    }

    protected LD_Component createComponent(Element element) {
        LD_Component ldComponent = null;
        String elementName = element.getName();
        if ("file".equals(elementName)) {
            ldComponent = new LD_File(this.getLD_DataModel(), element);
        } else if ("dependency".equals(elementName)) {
            ldComponent = new LD_Dependency(this.getLD_DataModel(), element);
        }
        return ldComponent;
    }

    public void setTitle(String title) {
        Element element = this.getElement();
        if (element != null) {
            element.setAttribute("href", title);
        }
    }

    public DataComponent addChildElement(String elementName, String title) {
        if (!"file".equals(elementName) && !"dependency".equals(elementName)) {
            return null;
        }
        LD_Component ldComponent = null;
        Element element = this.addChildElement(this.getElement(), elementName);
        if (element != null) {
            ldComponent = "file".equals(elementName) ? new LD_File(this.getLD_DataModel(), element) : new LD_Dependency(this.getLD_DataModel(), element);
            this.addChild(ldComponent);
            this.getDataModel().fireDataComponentAdded(ldComponent);
        }
        return ldComponent;
    }

    public String toString() {
        Element element = this.getElement();
        if (element == null) {
            return "";
        }
        String name = element.getAttributeValue("href");
        if (name == null || "".equals(name)) {
            name = element.getAttributeValue("identifier");
        }
        return name;
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/resource.gif");
    }

    public MetadataType getMetadataType() {
        if (this._mdType == null) {
            this._mdType = new MetadataType(this.getDataElement(), "Metadata", "Metadata for the Resource.");
        }
        return this._mdType;
    }

    public void elementAdded(XMLDocumentListenerEvent event) {
        Element element;
        String name;
        if (event.getSource() instanceof LearningDesign && "file".equals(name = (element = event.getElement()).getName()) && element.getParent() == this.getElement()) {
            LD_File ldFile = new LD_File(this.getLD_DataModel(), element);
            this.addChild(ldFile);
            this.getDataModel().fireDataComponentAdded(ldFile);
        }
    }

    public void elementChanged(XMLDocumentListenerEvent event) {
        Element element = event.getElement();
        if (element.equals(this.getElement())) {
            this.getDataModel().fireDataComponentChanged(this);
        }
    }
}

