/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.resources;

import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Resource;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;
import uk.ac.reload.jdom.XMLPath;

public class LD_Resources
extends LD_Component
implements IDataComponentIcon {
    public static XMLPath XMLPATH = new XMLPath("manifest/resources");
    static final String TITLE = "Resources";
    static final String DESCRIPTION = "Resources to include in the Learning Design";

    public LD_Resources(LD_DataModel ldDataModel) {
        this.setDataModel(ldDataModel);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.addChildren();
        ldDataModel.addIDataModelListener(this);
        ldDataModel.getLearningDesign().addXMLDocumentListener(this);
    }

    protected void addChildren() {
        LearningDesign ld = (LearningDesign)this.getDataModel().getSchemaDocument();
        this.setElement(ld.getResourcesElement());
        Element[] elResources = ld.getResourceElements();
        for (int i = 0; i < elResources.length; ++i) {
            LD_Resource ldResource = new LD_Resource(this.getLD_DataModel(), elResources[i]);
            this.addChild(ldResource);
        }
    }

    public DataComponent addChildElement(String elementName, String title) {
        if (!"resource".equals(elementName)) {
            return null;
        }
        LD_Resource ldResource = null;
        Element element = this.addChildElement(this.getElement(), elementName);
        if (element != null) {
            ldResource = new LD_Resource(this.getLD_DataModel(), element);
            this.addChild(ldResource);
            if (title != null) {
                ldResource.setTitle(title);
            }
            this.getDataModel().fireDataComponentAdded(ldResource);
        }
        return ldResource;
    }

    public LD_Resource getLD_Resource(String idRef) {
        if (idRef == null || "".equals(idRef)) {
            return null;
        }
        DataComponent[] ldresources = this.getChildren();
        for (int i = 0; i < ldresources.length; ++i) {
            String id = ((LD_Component)ldresources[i]).getIdentifier();
            if (!idRef.equals(id)) continue;
            return (LD_Resource)ldresources[i];
        }
        return null;
    }

    public boolean canDelete() {
        return false;
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/resources.gif");
    }

    public void elementAdded(XMLDocumentListenerEvent event) {
        Element element;
        String name;
        if (event.getSource() instanceof LearningDesign && "resource".equals(name = (element = event.getElement()).getName())) {
            LD_Resource ldResource = new LD_Resource(this.getLD_DataModel(), element);
            this.addChild(ldResource);
            this.getDataModel().fireDataComponentAdded(ldResource);
        }
    }

    public void componentRemoved(DataComponent component) {
        if (component instanceof LD_Resource) {
            String ref;
            int i;
            String id = ((LD_Resource)component).getIdentifier();
            if (id == null || "".equals(id)) {
                return;
            }
            LearningDesign ld = (LearningDesign)this.getDataModel().getSchemaDocument();
            Element[] elements = ld.getElementsInManifest(ld.getLDElement(), "item", ld.getLDNamespace());
            for (i = 0; i < elements.length; ++i) {
                ref = elements[i].getAttributeValue("identifierref");
                if (!id.equals(ref)) continue;
                elements[i].removeAttribute("identifierref");
                ld.changedElement(this, elements[i]);
            }
            elements = ld.getElementsInManifest(ld.getRootElement(), "dependency", ld.getRootElement().getNamespace());
            for (i = 0; i < elements.length; ++i) {
                ref = elements[i].getAttributeValue("identifierref");
                if (!id.equals(ref)) continue;
                elements[i].removeAttribute("identifierref");
                ld.changedElement(this, elements[i]);
            }
        }
    }
}

