/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import uk.ac.reload.diva.util.IProgressMonitor;
import uk.ac.reload.dweezil.gui.DweezilProgressMonitor;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.menu.DweezilMenuEvent;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.EditorInternalFrame;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.editor.CP_NewDialog;
import uk.ac.reload.editor.learningdesign.LD_EditorHandler;
import uk.ac.reload.editor.learningdesign.datamodel.ILD_DataModelHandler;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.editor.activities.ActivitiesPanel;
import uk.ac.reload.editor.learningdesign.editor.environment.EnvironmentsPanel;
import uk.ac.reload.editor.learningdesign.editor.general.GeneralPanel;
import uk.ac.reload.editor.learningdesign.editor.method.MethodPanel;
import uk.ac.reload.editor.learningdesign.editor.resources.LD_ResourcesPanel;
import uk.ac.reload.editor.learningdesign.editor.roles.RolesPanel;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLDocumentListener;
import uk.ac.reload.jdom.XMLDocumentListenerEvent;

public class LD_Editor
extends EditorInternalFrame
implements XMLDocumentListener,
IIcons {
    private LD_DataModel _ldDataModel;
    private ProxySaveHandler _saveHandler;
    private ProxySaveHandler _saveAsHandler;
    private ProxyZipHandler _zipHandler;
    private JTabbedPane _tabPane;
    private ILD_DataModelHandler[] _panels;
    private GeneralPanel _generalPanel;
    private LD_ResourcesPanel _resourcesPanel;
    private RolesPanel _rolesPanel;
    private ActivitiesPanel _activitiesPanel;
    private EnvironmentsPanel _envPanel;
    private MethodPanel _methodPanel;

    public LD_Editor() {
        this.setFrameIcon("uk/ac/reload/editor/resources/images/ld.gif");
        this.setTitle("Learning Design");
        this._tabPane = new JTabbedPane(3);
        this.getContentPane().add(this._tabPane);
        ILD_DataModelHandler[] iLD_DataModelHandlerArray = new ILD_DataModelHandler[6];
        this._generalPanel = new GeneralPanel();
        iLD_DataModelHandlerArray[0] = this._generalPanel;
        this._resourcesPanel = new LD_ResourcesPanel();
        iLD_DataModelHandlerArray[1] = this._resourcesPanel;
        this._rolesPanel = new RolesPanel();
        iLD_DataModelHandlerArray[2] = this._rolesPanel;
        this._envPanel = new EnvironmentsPanel();
        iLD_DataModelHandlerArray[3] = this._envPanel;
        this._activitiesPanel = new ActivitiesPanel();
        iLD_DataModelHandlerArray[4] = this._activitiesPanel;
        this._methodPanel = new MethodPanel();
        iLD_DataModelHandlerArray[5] = this._methodPanel;
        this._panels = iLD_DataModelHandlerArray;
        this._tabPane.addTab("General", DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/ld.gif"), (Component)((Object)this._generalPanel));
        this._tabPane.addTab("Roles", DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/roles.gif"), (Component)((Object)this._rolesPanel));
        this._tabPane.addTab("Environments", DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/environments.gif"), (Component)((Object)this._envPanel));
        this._tabPane.addTab("Activities", DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/activities.gif"), (Component)((Object)this._activitiesPanel));
        this._tabPane.addTab("Method", DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/method.gif"), (Component)((Object)this._methodPanel));
        this._tabPane.addTab("Resources", DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/resources.gif"), (Component)((Object)this._resourcesPanel));
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        boolean ok = LD_Editor.this.checkNeedsSaving();
                        if (ok) {
                            LD_Editor.this.dispose();
                        }
                    }
                });
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                LD_Editor.this.setFocusGained();
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                LD_Editor.this.setFocusLost();
            }
        });
        this._saveHandler = new ProxySaveHandler(MainMenu.getSharedInstance().actionSave);
        this._saveAsHandler = new ProxySaveHandler(MainMenu.getSharedInstance().actionSaveAs);
        this._zipHandler = new ProxyZipHandler();
    }

    public void setDataModel(LD_DataModel ldDataModel) {
        this._ldDataModel = ldDataModel;
        LearningDesign ld = this._ldDataModel.getLearningDesign();
        this.setTitle("Learning Design " + ld.getLevel() + " - " + ld.getProjectName());
        for (int i = 0; i < this._panels.length; ++i) {
            this._panels[i].setDataModel(this._ldDataModel);
        }
        ld.addXMLDocumentListener(this);
        EditorHandler.getSharedInstance().registerOpenedFile(ld.getFile(), this);
    }

    public void show() {
        super.show();
        this._rolesPanel.initView();
        this._envPanel.initView();
        this._activitiesPanel.initView();
        this._methodPanel.initView();
        this._resourcesPanel.initView();
    }

    public LD_DataModel get_LD_DataModel() {
        return this._ldDataModel;
    }

    protected void zipIt() {
        LearningDesign ld = this._ldDataModel.getLearningDesign();
        if (ld != null) {
            boolean doSave = this.checkNeedsSaving();
            if (!doSave) {
                return;
            }
            this._zipHandler.setEnabled(false);
            LD_EditorHandler.zipContentPackage(ld);
            this._zipHandler.setEnabled(true);
        }
    }

    public void elementAdded(XMLDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(true);
        }
    }

    public void elementChanged(XMLDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(true);
        }
    }

    public void elementRemoved(XMLDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(true);
        }
    }

    public void documentSaved(XMLDocument doc) {
        if (this.isSelected()) {
            LearningDesign ld = this._ldDataModel.getLearningDesign();
            this._saveHandler.setEnabled(ld.isDirty() && this._saveHandler.isEnabled());
        }
    }

    private void setFocusGained() {
        LearningDesign ld = this._ldDataModel.getLearningDesign();
        this._saveHandler.setEnabled(ld.isDirty());
        this._saveHandler.addListener();
        this._saveAsHandler.setEnabled(true);
        this._saveAsHandler.addListener();
        this._zipHandler.setEnabled(true);
        this._zipHandler.addListener();
    }

    private void setFocusLost() {
        this._saveHandler.clear();
        this._saveAsHandler.clear();
        this._zipHandler.clear();
    }

    public boolean applicationClosing() {
        return this.checkNeedsSaving();
    }

    protected boolean checkNeedsSaving() {
        boolean isOK = true;
        LearningDesign ld = this._ldDataModel.getLearningDesign();
        if (this._saveHandler.isEnabled()) {
            String name = ld.getProjectName();
            String msg = name != null ? name + " " + "has been modified." : "Unsaved Learning Design.";
            int doSave = JOptionPane.showConfirmDialog((Component)((Object)this), msg + " " + "Do you wish to save these changes?", "Save Learning Design", 1);
            if (doSave == 0) {
                isOK = this.saveDocument();
                for (int i = 0; i < this._panels.length; ++i) {
                    isOK = isOK && this._panels[i].doSave();
                }
            } else if (doSave == 2) {
                isOK = false;
            }
        }
        return isOK;
    }

    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    public void cleanup() {
        if (this._saveHandler != null) {
            this._saveHandler.clear();
        }
        if (this._saveAsHandler != null) {
            this._saveAsHandler.clear();
        }
        if (this._zipHandler != null) {
            this._zipHandler.clear();
        }
        for (int i = 0; i < this._panels.length; ++i) {
            this._panels[i].cleanup();
        }
        this._ldDataModel.destroy();
        this._ldDataModel = null;
    }

    protected boolean saveDocument() {
        try {
            LearningDesign ld = this._ldDataModel.getLearningDesign();
            if (ld.isDirty()) {
                ld.saveDocument();
            }
        }
        catch (IOException ex) {
            ErrorDialogBox.showWarning((Component)((Object)this), (String)"Could not save file: ", (String)"Save Learning Design", (Exception)ex);
            return false;
        }
        return true;
    }

    protected boolean saveDocumentAs() {
        DweezilProgressMonitor progressMonitor = null;
        try {
            CP_NewDialog dialog = new CP_NewDialog(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.29"));
            File targetFolder = dialog.showDialog();
            if (targetFolder == null || !targetFolder.exists()) {
                return false;
            }
            progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.31"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
            LearningDesign ld = this._ldDataModel.getLearningDesign();
            ld.saveDocumentAs(targetFolder, (IProgressMonitor)progressMonitor);
            progressMonitor.close();
            this.setDataModel(this._ldDataModel);
            JOptionPane.showMessageDialog((Component)((Object)this), "Learning Design Saved", "Save As", 1, null);
            return true;
        }
        catch (Exception ex) {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            ErrorDialogBox.showWarning((Component)((Object)this), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.32"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.33"), (Exception)ex);
            return false;
        }
    }

    class ProxyZipHandler
    extends ProxyAction {
        public ProxyZipHandler() {
            super((MenuAction)MainMenu.getSharedInstance().actionZipIt);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            Thread thread = new Thread(){

                public void run() {
                    LD_Editor.this.zipIt();
                }
            };
            if (LD_Editor.this.isSelected()) {
                thread.start();
            }
        }
    }

    class ProxySaveHandler
    extends ProxyAction {
        public ProxySaveHandler(MenuAction menuAction) {
            super(menuAction);
        }

        public void menuActionPerformed(DweezilMenuEvent event) {
            if (LD_Editor.this.isSelected() && event.getSource() == MainMenu.getSharedInstance().actionSave) {
                LD_Editor.this.saveDocument();
            }
            if (LD_Editor.this.isSelected() && event.getSource() == MainMenu.getSharedInstance().actionSaveAs) {
                Thread thread = new Thread(){

                    public void run() {
                        LD_Editor.this.saveDocumentAs();
                    }
                };
                thread.start();
            }
        }
    }
}

