/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.environment;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import uk.ac.reload.dweezil.gui.ShortcutIcon;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.PopupMenuAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.gui.Editor_Tree;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.EnvironmentRef;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.EnvironmentRef_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environments_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.LearningObject;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.LearningObject_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Service_Grouping;
import uk.ac.reload.editor.learningdesign.editor.environment.EnvironmentTree;
import uk.ac.reload.editor.learningdesign.editor.shared.LD_TreePanel;

public class EnvironmentTreePanel
extends LD_TreePanel {
    private EnvironmentTree _tree;
    private MenuAction_Add _menuAdd;
    private LD_TreePanel.MenuAction_Delete _menuDelete;
    private LD_TreePanel.MenuAction_Rename _menuRename;
    private LD_TreePanel.MenuAction_MoveUp _menuMoveUp;
    private LD_TreePanel.MenuAction_MoveDown _menuMoveDown;
    private boolean _isLevelA;

    public EnvironmentTreePanel() {
        this.setText("Environments");
        this.setIcon(DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/environments.gif"));
        this._menuAdd = new MenuAction_Add();
        this.addMenuActionToCoolBar((MenuAction)this._menuAdd);
        this._menuDelete = new LD_TreePanel.MenuAction_Delete(this);
        this.addMenuActionToCoolBar(this._menuDelete);
        this._menuMoveUp = new LD_TreePanel.MenuAction_MoveUp(this);
        this.addMenuActionToCoolBar(this._menuMoveUp);
        this._menuMoveDown = new LD_TreePanel.MenuAction_MoveDown(this);
        this.addMenuActionToCoolBar(this._menuMoveDown);
        this._menuRename = new LD_TreePanel.MenuAction_Rename(this);
    }

    public void setDataModel(DataModel dataModel) {
        super.setDataModel(dataModel);
        String level = ((LD_DataModel)this.getDataModel()).getLearningDesign().getLevel();
        if ("A".equals(level)) {
            this._isLevelA = true;
        }
        this._menuAdd.addMenuItems();
    }

    public Editor_Tree getTree() {
        if (this._tree == null) {
            this._tree = new EnvironmentTree();
        }
        return this._tree;
    }

    public synchronized void updateMenus() {
        super.updateMenus();
        DataComponent component = null;
        DweezilTreeNode selNode = this.getTree().getSelectedNode();
        if (selNode != null) {
            component = (DataComponent)selNode.getUserObject();
        }
        this._menuAdd.newEnvironment.setEnabled(component instanceof Environments_Grouping);
        this._menuAdd.newLO.setEnabled(component instanceof LearningObject_Grouping);
        this._menuAdd.newSendMail.setEnabled(component instanceof Service_Grouping);
        this._menuAdd.newConference.setEnabled(component instanceof Service_Grouping);
        this._menuAdd.newIndexSearch.setEnabled(component instanceof Service_Grouping);
        this._menuAdd.newMonitor.setEnabled(component instanceof Service_Grouping);
        if (component instanceof EnvironmentRef_Grouping) {
            Environment env = (Environment)component.getParent();
            Environment[] envs = env.getAllowedEnvironmentsToReference();
            this._menuAdd.newEnvironmentRef.setEnabled(envs.length != 0);
        } else {
            this._menuAdd.newEnvironmentRef.setEnabled(false);
        }
        this._menuDelete.setEnabled(component != null && component.canDelete());
        this._menuRename.setEnabled(component instanceof Environment || component instanceof Service || component instanceof LearningObject);
        this._menuMoveUp.setEnabled(component != null && component.canMoveUp());
        this._menuMoveDown.setEnabled(component != null && component.canMoveDown());
        this.getTree().getPopupMenu().removeAll();
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newEnvironment);
        this.getTree().getPopupMenu().addSeparator();
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newLO);
        this.getTree().getPopupMenu().addSeparator();
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newSendMail);
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newConference);
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newIndexSearch);
        if (!this._isLevelA) {
            this.getTree().getPopupMenu().add((Action)this._menuAdd.newMonitor);
        }
        this.getTree().getPopupMenu().addSeparator();
        this.getTree().getPopupMenu().add((Action)this._menuAdd.newEnvironmentRef);
        this.getTree().getPopupMenu().addSeparator();
        this.getTree().getPopupMenu().add((Action)((Object)this._menuDelete));
        this.getTree().getPopupMenu().add((Action)((Object)this._menuRename));
    }

    private void addNewEnvironmentRef(String message, Icon icon) {
        EnvironmentRef envRef;
        DataComponent component = null;
        DweezilTreeNode selNode = this.getTree().getSelectedNode();
        if (selNode != null) {
            component = (DataComponent)selNode.getUserObject();
        }
        if (!(component instanceof EnvironmentRef_Grouping)) {
            return;
        }
        Environment environment = (Environment)component.getParent();
        Object[] envs = environment.getAllowedEnvironmentsToReference();
        if (envs.length == 0) {
            return;
        }
        Environment env = (Environment)JOptionPane.showInputDialog(EditorFrame.getInstance(), "Environment", message, 3, icon, envs, null);
        if (env != null && (envRef = (EnvironmentRef)this.getTree().addNewElement("environment-ref", null)) != null) {
            envRef.setLD_ComponentRef(env);
        }
    }

    class MenuAction_Add
    extends PopupMenuAction {
        MenuAction newEnvironment;
        MenuAction newLO;
        MenuAction newSendMail;
        MenuAction newConference;
        MenuAction newIndexSearch;
        MenuAction newMonitor;
        MenuAction newEnvironmentRef;

        public MenuAction_Add() {
            super("Add", "uk/ac/reload/editor/resources/images/add.gif");
            this.newEnvironment = new MenuAction("New Environment", "uk/ac/reload/editor/resources/images/environment.gif"){

                public void actionPerformed(ActionEvent e) {
                    EnvironmentTreePanel.this.addNewElement("New Environment", this.getMenuIcon(), "environment");
                }
            };
            this.newLO = new MenuAction("New Learning Object", "uk/ac/reload/editor/resources/images/learning_object.gif"){

                public void actionPerformed(ActionEvent e) {
                    EnvironmentTreePanel.this.addNewElement("New Learning Object", this.getMenuIcon(), "learning-object");
                }
            };
            this.newSendMail = new MenuAction("New Send Mail", "uk/ac/reload/editor/resources/images/sendmail.gif"){

                public void actionPerformed(ActionEvent e) {
                    EnvironmentTreePanel.this.addNewElement("New Send Mail", this.getMenuIcon(), "send-mail");
                }
            };
            this.newConference = new MenuAction("New Conference", "uk/ac/reload/editor/resources/images/conference.gif"){

                public void actionPerformed(ActionEvent e) {
                    EnvironmentTreePanel.this.addNewElement("New Conference", this.getMenuIcon(), "conference");
                }
            };
            this.newIndexSearch = new MenuAction("New Index Search", "uk/ac/reload/editor/resources/images/index_search.gif"){

                public void actionPerformed(ActionEvent e) {
                    EnvironmentTreePanel.this.addNewElement("New Index Search", this.getMenuIcon(), "index-search");
                }
            };
            this.newMonitor = new MenuAction("New Monitor", "uk/ac/reload/editor/resources/images/monitor.gif"){

                public void actionPerformed(ActionEvent e) {
                    EnvironmentTreePanel.this.addNewElement("New Monitor", this.getMenuIcon(), "monitor");
                }
            };
            this.newEnvironmentRef = new MenuAction("New Environment Reference"){
                {
                    super(x0);
                    ImageIcon icon = DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/environment.gif");
                    this.setMenuIcon((Icon)new ShortcutIcon((Icon)icon));
                }

                public void actionPerformed(ActionEvent e) {
                    EnvironmentTreePanel.this.addNewEnvironmentRef("New Environment Reference", this.getMenuIcon());
                }
            };
        }

        public void addMenuItems() {
            this.getPopupMenu().add((Action)this.newEnvironment);
            this.getPopupMenu().addSeparator();
            this.getPopupMenu().add((Action)this.newLO);
            this.getPopupMenu().addSeparator();
            this.getPopupMenu().add((Action)this.newSendMail);
            this.getPopupMenu().add((Action)this.newConference);
            this.getPopupMenu().add((Action)this.newIndexSearch);
            if (!EnvironmentTreePanel.this._isLevelA) {
                this.getPopupMenu().add((Action)this.newMonitor);
            }
            this.getPopupMenu().addSeparator();
            this.getPopupMenu().add((Action)this.newEnvironmentRef);
        }
    }
}

