/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.environment;

import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.datamodel.IDataModelListener;
import uk.ac.reload.editor.gui.Editor_TreeNode;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.SendMail;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Role;
import uk.ac.reload.editor.learningdesign.editor.roles.RoleSelectorTree;

public class SendMailRoleSelectorTree
extends RoleSelectorTree
implements IDataModelListener {
    private SendMail _sendMail;

    public void setSendMailComponent(SendMail sendMail) {
        this._sendMail = sendMail;
        if (this.getDataModel() == null) {
            this.setDataModel(sendMail.getDataModel());
            this.expandTree(true);
        }
        this.setSelectedNodes(this._sendMail.getRoles());
    }

    public void setDataModel(DataModel ldDataModel) {
        super.setDataModel(ldDataModel);
        ldDataModel.addIDataModelListener(this);
    }

    public void nodeSelected(Editor_TreeNode node) {
        if (this._sendMail.isLastRoleRef() && node.isSelected()) {
            return;
        }
        Object o = node.getUserObject();
        if (o instanceof Role) {
            Role role = (Role)o;
            if (!node.isSelected()) {
                this._sendMail.addRoleRef(role);
            } else {
                this._sendMail.removeRoleRef(role);
            }
        }
    }

    public void cleanup() {
        if (this.getDataModel() != null) {
            this.getDataModel().removeIDataModelListener(this);
        }
        super.cleanup();
    }

    public void componentAdded(DataComponent component) {
    }

    public void componentRemoved(DataComponent component) {
    }

    public void componentMoved(DataComponent component) {
    }

    public void componentChanged(DataComponent component) {
        if (component == this._sendMail) {
            this.setSelectedNodes(this._sendMail.getRoles());
        }
    }
}

