/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.shared;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.FlatCheckBox;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.gui.Editor_Tree;
import uk.ac.reload.editor.gui.Editor_TreeNode;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;

public abstract class LD_SelectorTree
extends Editor_Tree {
    protected LD_SelectorTree() {
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new NodeSelectionListener());
    }

    public void setSelectedNodes(LD_Component[] components) {
        this.clearSelectedNodes();
        if (components == null) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            Editor_TreeNode node = (Editor_TreeNode)this.getNode(components[i]);
            if (node == null) continue;
            node.setSelected(true);
            this.updateNode(node);
        }
    }

    public LD_Component[] getSelectedComponents() {
        Vector<Object> v = new Vector<Object>();
        Enumeration nodes = this.getNodes();
        if (nodes != null) {
            while (nodes.hasMoreElements()) {
                Editor_TreeNode node = (Editor_TreeNode)((Object)nodes.nextElement());
                if (!node.isSelected() || !(node.getUserObject() instanceof LD_Component)) continue;
                v.add(node.getUserObject());
            }
        }
        Object[] components = new LD_Component[v.size()];
        v.copyInto(components);
        return components;
    }

    public void clearSelectedNodes() {
        Enumeration nodes = this.getNodes();
        if (nodes != null) {
            while (nodes.hasMoreElements()) {
                Editor_TreeNode node = (Editor_TreeNode)((Object)nodes.nextElement());
                node.setSelected(false);
                this.updateNode(node);
            }
        }
    }

    public abstract void nodeSelected(Editor_TreeNode var1);

    public class LD_TreeGrouping
    extends LD_Grouping {
        public void addChild(DataComponent child) {
            if (this._children == null) {
                this._children = new Vector();
            }
            if (child != null && !this._children.contains(child)) {
                this._children.add(child);
            }
        }

        public void addChildAt(DataComponent child, int index) {
            if (this._children == null) {
                this._children = new Vector();
            }
            if (child != null && !this._children.contains(child)) {
                this._children.add(index, child);
            }
        }

        public void removeChild(DataComponent child) {
            if (child != null && this._children != null) {
                this._children.remove(child);
            }
        }

        public void removeChildren() {
            if (this._children != null) {
                this._children.clear();
            }
        }
    }

    public static class LD_SelectorTreeTreeRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected FlatCheckBox cb;
        protected DefaultTreeCellRenderer label;
        protected Font normalFont;
        protected Font boldFont;

        public LD_SelectorTreeTreeRenderer() {
            super(new BorderLayout());
            this.setBackground(null);
            this.cb = new FlatCheckBox();
            this.cb.setBackground(UIManager.getColor("Tree.textBackground"));
            this.add((Component)this.cb, "West");
            this.label = new DefaultTreeCellRenderer();
            this.add((Component)this.label, "Center");
            this.normalFont = this.label.getFont();
            this.boldFont = this.label.getFont().deriveFont(1);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof Editor_TreeNode) {
                Editor_TreeNode selNode = (Editor_TreeNode)((Object)value);
                Object obj = selNode.getUserObject();
                this.cb.setSelected(selNode.isSelected());
                if (selNode.isSelected()) {
                    this.label.setFont(this.boldFont);
                } else {
                    this.label.setFont(this.normalFont);
                }
                this.label.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (obj instanceof IDataComponentIcon) {
                    this.label.setIcon(((IDataComponentIcon)obj).getIcon());
                }
            }
            return this;
        }

        public Dimension getPreferredSize() {
            int cbWidth = this.cb.isVisible() ? this.cb.getPreferredSize().width : 0;
            return new Dimension(cbWidth + this.label.getPreferredSize().width, super.getPreferredSize().height);
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        NodeSelectionListener() {
        }

        public void mousePressed(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = LD_SelectorTree.this.getRowForLocation(x, y = e.getY());
            TreePath path = LD_SelectorTree.this.getPathForRow(row);
            if (path != null) {
                Editor_TreeNode node = (Editor_TreeNode)((Object)path.getLastPathComponent());
                LD_SelectorTree.this.nodeSelected(node);
                LD_SelectorTree.this.updateNode(node);
                if (row == 0) {
                    LD_SelectorTree.this.revalidate();
                    LD_SelectorTree.this.repaint();
                }
            }
        }
    }
}

