/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.xml;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.diva.util.RandomGUID;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.contentpackaging.xml.CP_SchemaController;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.learningdesign.xml.ILD_SchemaController;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaException;
import uk.ac.reload.moonunit.schema.SchemaModel;

public class LearningDesign
extends ContentPackage {
    static final String[] ld_comments = new String[]{"This is a Reload version " + EditorProperties.getString("VERSION") + " Learning Design document", "Spawned from the Reload Learning Design Generator - http://www.reload.ac.uk"};

    public LearningDesign() {
    }

    public LearningDesign(File projectFolder, CP_SchemaController ldController, MD_SchemaController mdController) throws IOException {
        super(projectFolder, ldController, mdController);
    }

    public LearningDesign(File file) throws JDOMException, SchemaException, IOException {
        String version;
        this.setFile(file);
        this.setDocument(XMLUtils.readXMLFile((File)file));
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)this.getDocument());
        String versionLD = EditorHandler.LD_EDITORHANDLER.getVersion(nameSpace, this.getLevel());
        CP_SchemaController ldController = (CP_SchemaController)EditorHandler.LD_EDITORHANDLER.getSchemaControllerInstance(versionLD);
        this.setSchemaController((SchemaController)ldController);
        Namespace nsMD = this.getDocument().getRootElement().getNamespace("imsmd");
        if (nsMD != null && (version = EditorHandler.MD_EDITORHANDLER.getVersion(nsMD)) != null) {
            MD_SchemaController mdController = (MD_SchemaController)EditorHandler.MD_EDITORHANDLER.getSchemaControllerInstance(version);
            ldController.setMD_SchemaController(mdController);
        }
    }

    protected void init(File projectFolder, CP_SchemaController cpController) {
        super.init(projectFolder, cpController);
        Element root = this.getDocument().getRootElement();
        SchemaModel cpSchema = cpController.getSchemaModel();
        root.addNamespaceDeclaration(this.getLDNamespace());
        Attribute att = root.getAttribute(XMLUtils.XSI_SchemaLocation, XMLUtils.XSI_Namespace);
        if (att != null) {
            String value = att.getValue();
            if (value == null) {
                value = "";
            }
            StringBuffer schemaLocationURI = new StringBuffer(value);
            schemaLocationURI.append(" ");
            schemaLocationURI.append(this.getLDNamespace().getURI());
            schemaLocationURI.append(" ");
            schemaLocationURI.append(cpSchema.getSchemaName(this.getLDNamespace().getURI()));
            att.setValue(schemaLocationURI.toString());
        }
        this.setLevel(((ILD_SchemaController)((Object)cpController)).getLevel());
    }

    public String[] getComments() {
        return ld_comments;
    }

    public Namespace getLDNamespace() {
        return CP_EditorHandler.IMSLD_NAMESPACE_10;
    }

    public void setLevel(String level) {
        level = level == null ? "C" : level.toUpperCase();
        this.getLDElement().setAttribute("level", level);
    }

    public String getLevel() {
        String level = this.getLDElement().getAttributeValue("level");
        if (level == null) {
            level = "C";
            this.setLevel(level);
        } else if (!((level = level.toUpperCase()).equals("A") || level.equals("B") || level.equals("C"))) {
            level = "C";
            this.setLevel(level);
        }
        return level;
    }

    public String generateUniqueID(Element element) {
        if (element.getNamespace().equals(this.getLDNamespace())) {
            String prefix = "LD-";
            return RandomGUID.getUniqueID((String)prefix);
        }
        return super.generateUniqueID(element);
    }

    public Element getLDElement() {
        Element ld;
        Element organizations = this.getRootElement().getChild("organizations", this.getRootElement().getNamespace());
        if (organizations == null) {
            organizations = this.addElementByXMLPath((Object)this, this.getRootElement(), new XMLPath("organizations"), false);
        }
        if ((ld = organizations.getChild("learning-design", this.getLDNamespace())) == null) {
            ld = this.addElementByXMLPath((Object)this, organizations, new XMLPath("imsld:learning-design"), false);
        }
        return ld;
    }

    public Element getResourcesElement() {
        Element elResources = this.getResourcesElement(this.getRootElement());
        if (elResources == null) {
            elResources = this.addElementByXMLPath((Object)this, this.getRootElement(), new XMLPath("resources"), false);
        }
        return elResources;
    }

    public Element[] getResourceElements() {
        Element elResources = this.getResourcesElement();
        List list = elResources.getChildren("resource", elResources.getNamespace());
        Element[] elements = new Element[list.size()];
        list.toArray(elements);
        return elements;
    }
}

