/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.menu;

import java.awt.Toolkit;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import uk.ac.reload.diva.util.GeneralUtils;
import uk.ac.reload.dweezil.gui.DweezilToolBar;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.EditorInternalFrame;
import uk.ac.reload.editor.IEditorHandler;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.menu.MenuAction_About;
import uk.ac.reload.editor.menu.MenuAction_CascadeWindow;
import uk.ac.reload.editor.menu.MenuAction_EditMetadata;
import uk.ac.reload.editor.menu.MenuAction_EditSCORM;
import uk.ac.reload.editor.menu.MenuAction_Exit;
import uk.ac.reload.editor.menu.MenuAction_ExportCPPreview;
import uk.ac.reload.editor.menu.MenuAction_Help;
import uk.ac.reload.editor.menu.MenuAction_ImportResources;
import uk.ac.reload.editor.menu.MenuAction_New;
import uk.ac.reload.editor.menu.MenuAction_NewFromSCORMTemplate;
import uk.ac.reload.editor.menu.MenuAction_Open;
import uk.ac.reload.editor.menu.MenuAction_Prefs;
import uk.ac.reload.editor.menu.MenuAction_RecentOpen;
import uk.ac.reload.editor.menu.MenuAction_SCMTValidate;
import uk.ac.reload.editor.menu.MenuAction_Save;
import uk.ac.reload.editor.menu.MenuAction_SaveAs;
import uk.ac.reload.editor.menu.MenuAction_StatusWindow;
import uk.ac.reload.editor.menu.MenuAction_TileHorizontalWindow;
import uk.ac.reload.editor.menu.MenuAction_TileVerticalWindow;
import uk.ac.reload.editor.menu.MenuAction_Validate;
import uk.ac.reload.editor.menu.MenuAction_ViewCP;
import uk.ac.reload.editor.menu.MenuAction_ViewFile;
import uk.ac.reload.editor.menu.MenuAction_ViewSchema;
import uk.ac.reload.editor.menu.MenuAction_ZipIt;
import uk.ac.reload.editor.menu.MenuXSLBatchExport;
import uk.ac.reload.editor.menu.MenuXSLExport;
import uk.ac.reload.editor.menu.MenuXSLTImport;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.prefs.EditorPrefs;
import uk.ac.reload.editor.properties.EditorProperties;

public class MainMenu
extends JMenuBar
implements IIcons {
    private static MainMenu _sharedInstance;
    public MenuAction_Save actionSave;
    public MenuAction_SaveAs actionSaveAs;
    public MenuAction_ImportResources actionImport;
    public MenuAction_ExportCPPreview exportPreview;
    public MenuAction_EditMetadata actionEditMetadata;
    public MenuAction_EditSCORM actionEditSCORM;
    public MenuAction_ZipIt actionZipIt;
    public MenuAction_ViewFile actionViewFile;
    public MenuAction_ViewCP actionViewCP;
    public MenuAction_Validate actionValidate;
    public MenuAction_SCMTValidate actionSCMTValidate;
    public MenuXSLExport menuCRTExport;
    public MenuXSLBatchExport menuCRTBatch;
    public MenuXSLTImport menuCRTImport;
    private DweezilToolBar toolBar;
    private int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public JMenu fileMenu;
    public Menu_Edit editMenu;
    public JMenu schemaViewerMenu;
    public JMenu toolsMenu;
    public JMenu viewMenu;
    public JMenu windowMenu;
    public JMenu helpMenu;

    public static MainMenu getSharedInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new MainMenu();
        }
        return _sharedInstance;
    }

    private MainMenu() {
        this.actionSave = new MenuAction_Save();
        this.actionSaveAs = new MenuAction_SaveAs();
        this.actionImport = new MenuAction_ImportResources();
        this.exportPreview = new MenuAction_ExportCPPreview();
        this.actionEditMetadata = new MenuAction_EditMetadata();
        this.actionEditSCORM = new MenuAction_EditSCORM();
        this.actionZipIt = new MenuAction_ZipIt();
        this.actionViewFile = new MenuAction_ViewFile();
        this.actionViewCP = new MenuAction_ViewCP();
        this.actionValidate = new MenuAction_Validate();
        this.actionSCMTValidate = new MenuAction_SCMTValidate();
        this.createMenuBar();
        this.toolBar = this.createToolBar();
    }

    public void addInternalFrame(EditorInternalFrame frame) {
        this.windowMenu.add(frame.getMenuItem());
    }

    public void removeInternalFrame(EditorInternalFrame frame) {
        this.windowMenu.remove(frame.getMenuItem());
    }

    private void createMenuBar() {
        this.fileMenu = this.createFileMenu();
        this.editMenu = new Menu_Edit();
        this.add((JMenu)((Object)this.editMenu));
        if (EditorProperties.getString("DEBUG").equals("true")) {
            this.schemaViewerMenu = this.createSchemaViewerMenu();
        }
        this.toolsMenu = this.createToolsMenu();
        this.viewMenu = this.createViewMenu();
        this.windowMenu = this.createWindowMenu();
        this.helpMenu = this.createHelpMenu();
    }

    private JMenu createFileMenu() {
        String menuText = Messages.getString("uk.ac.reload.editor.menu.MainMenu.0");
        JMenu jmenu = this.add(new JMenu(MenuAction.getRemoveMnemonicText((String)menuText)));
        jmenu.setMnemonic(MenuAction.getMnemonic((String)menuText));
        menuText = Messages.getString("uk.ac.reload.editor.menu.MainMenu.1");
        JMenu newMenu = new JMenu(MenuAction.getRemoveMnemonicText((String)menuText));
        newMenu.setMnemonic(MenuAction.getMnemonic((String)menuText));
        newMenu.setIcon(DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/new.gif"));
        jmenu.add(newMenu);
        Vector<MenuAction> newMenus = new Vector<MenuAction>();
        newMenus.addAll(Arrays.asList(EditorHandler.getSharedInstance().getNewDocumentMenuActions()));
        MenuAction_NewFromSCORMTemplate scorm2004Template = new MenuAction_NewFromSCORMTemplate();
        if (newMenus.size() > 4) {
            newMenus.insertElementAt(scorm2004Template, 4);
        }
        Iterator iter = newMenus.iterator();
        while (iter.hasNext()) {
            newMenu.add((Action)((MenuAction)iter.next()));
        }
        newMenus = null;
        MenuAction_Open actionOpen = new MenuAction_Open();
        JMenuItem item = jmenu.add((Action)((Object)actionOpen));
        item.setMnemonic(actionOpen.getMnemonic());
        item = jmenu.add((Action)((Object)this.actionImport));
        item.setMnemonic(this.actionImport.getMnemonic());
        jmenu.addSeparator();
        this.menuCRTImport = new MenuXSLTImport();
        jmenu.add((Action)((Object)this.menuCRTImport));
        this.menuCRTExport = new MenuXSLExport();
        jmenu.add((Action)((Object)this.menuCRTExport));
        this.menuCRTBatch = new MenuXSLBatchExport();
        jmenu.add((Action)((Object)this.menuCRTBatch));
        jmenu.addSeparator();
        item = jmenu.add((Action)((Object)this.actionSave));
        item.setMnemonic(this.actionSave.getMnemonic());
        item.setAccelerator(KeyStroke.getKeyStroke(83, this.keyMask));
        item = jmenu.add((Action)((Object)this.actionSaveAs));
        item.setMnemonic(this.actionSaveAs.getMnemonic());
        item.setAccelerator(KeyStroke.getKeyStroke(83, 1 + this.keyMask));
        jmenu.addSeparator();
        item = jmenu.add((Action)((Object)this.actionZipIt));
        item.setMnemonic(this.actionZipIt.getMnemonic());
        item = jmenu.add((Action)((Object)this.exportPreview));
        item.setMnemonic(this.exportPreview.getMnemonic());
        jmenu.addSeparator();
        menuText = Messages.getString("uk.ac.reload.editor.menu.MainMenu.2");
        final JMenu recentMenu = new JMenu(MenuAction.getRemoveMnemonicText((String)menuText));
        recentMenu.setMnemonic(MenuAction.getMnemonic((String)menuText));
        jmenu.add(recentMenu);
        recentMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                recentMenu.removeAll();
                String[] s = EditorPrefs.getInstance().getFileHistory();
                for (int i = 0; i < s.length; ++i) {
                    File file = new File(s[i]);
                    recentMenu.add((Action)((Object)new MenuAction_RecentOpen(i + 1, file)));
                }
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        if (GeneralUtils.getOS() != 0) {
            jmenu.addSeparator();
            MenuAction_Exit actionExit = new MenuAction_Exit();
            item = jmenu.add((Action)((Object)actionExit));
            item.setMnemonic(actionExit.getMnemonic());
        }
        return jmenu;
    }

    private JMenu createSchemaViewerMenu() {
        JMenu jmenu = this.add(new JMenu("Schemas"));
        jmenu.setMnemonic('s');
        IEditorHandler[] handlers = EditorHandler.getSharedInstance().getRegisteredEditorHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            IEditorHandler handler = handlers[i];
            String[] versions = handler.getSupportedVersions();
            Icon icon = handler.getIcon();
            for (int j = 0; j < versions.length; ++j) {
                String version = versions[j];
                jmenu.add(new JMenuItem((Action)((Object)new MenuAction_ViewSchema(version, icon))));
            }
            jmenu.addSeparator();
        }
        return jmenu;
    }

    private JMenu createToolsMenu() {
        JMenu jmenu = null;
        if (GeneralUtils.getOS() != 0) {
            String menuText = Messages.getString("uk.ac.reload.editor.menu.MainMenu.3");
            jmenu = this.add(new JMenu(MenuAction.getRemoveMnemonicText((String)menuText)));
            jmenu.setMnemonic(MenuAction.getMnemonic((String)menuText));
            MenuAction_Prefs actionOptions = new MenuAction_Prefs();
            JMenuItem item = jmenu.add((Action)((Object)actionOptions));
            item.setMnemonic(actionOptions.getMnemonic());
        }
        return jmenu;
    }

    private JMenu createViewMenu() {
        String menuText = Messages.getString("uk.ac.reload.editor.menu.MainMenu.4");
        JMenu jmenu = this.add(new JMenu(MenuAction.getRemoveMnemonicText((String)menuText)));
        jmenu.setMnemonic(MenuAction.getMnemonic((String)menuText));
        JMenuItem item = jmenu.add((Action)((Object)this.actionViewFile));
        item.setMnemonic(this.actionViewFile.getMnemonic());
        item = jmenu.add((Action)((Object)this.actionViewCP));
        item.setMnemonic(this.actionViewCP.getMnemonic());
        jmenu.addSeparator();
        MenuAction_StatusWindow actionStatus = new MenuAction_StatusWindow();
        item = jmenu.add((Action)((Object)actionStatus));
        item.setMnemonic(actionStatus.getMnemonic());
        return jmenu;
    }

    private JMenu createWindowMenu() {
        String menuText = Messages.getString("uk.ac.reload.editor.menu.MainMenu.5");
        JMenu jmenu = this.add(new JMenu(MenuAction.getRemoveMnemonicText((String)menuText)));
        jmenu.setMnemonic(MenuAction.getMnemonic((String)menuText));
        MenuAction_CascadeWindow actionCascade = new MenuAction_CascadeWindow();
        JMenuItem item = jmenu.add((Action)((Object)actionCascade));
        item.setMnemonic(actionCascade.getMnemonic());
        MenuAction_TileHorizontalWindow actionTileHorizontal = new MenuAction_TileHorizontalWindow();
        item = jmenu.add((Action)((Object)actionTileHorizontal));
        item.setMnemonic(actionTileHorizontal.getMnemonic());
        MenuAction_TileVerticalWindow actionTileVertical = new MenuAction_TileVerticalWindow();
        item = jmenu.add((Action)((Object)actionTileVertical));
        item.setMnemonic(actionTileVertical.getMnemonic());
        jmenu.addSeparator();
        return jmenu;
    }

    private JMenu createHelpMenu() {
        String menuText = Messages.getString("uk.ac.reload.editor.menu.MainMenu.6");
        JMenu jmenu = this.add(new JMenu(MenuAction.getRemoveMnemonicText((String)menuText)));
        jmenu.setMnemonic(MenuAction.getMnemonic((String)menuText));
        MenuAction_Help actionHelp = new MenuAction_Help();
        JMenuItem item = jmenu.add((Action)((Object)actionHelp));
        item.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        item.setMnemonic(actionHelp.getMnemonic());
        if (GeneralUtils.getOS() != 0) {
            jmenu.addSeparator();
            MenuAction_About actionAbout = new MenuAction_About();
            item = jmenu.add((Action)((Object)actionAbout));
            item.setMnemonic(actionAbout.getMnemonic());
        }
        return jmenu;
    }

    private DweezilToolBar createToolBar() {
        DweezilToolBar tBar = new DweezilToolBar();
        MenuAction_New actionNew = new MenuAction_New();
        tBar.add((MenuAction)actionNew);
        MenuAction_Open actionOpen = new MenuAction_Open();
        tBar.add((MenuAction)actionOpen);
        tBar.add((MenuAction)this.actionSave);
        tBar.addSeparator();
        tBar.add((MenuAction)this.editMenu.actionUndo);
        tBar.add((MenuAction)this.editMenu.actionRedo);
        tBar.addSeparator();
        tBar.add((MenuAction)this.editMenu.actionCut);
        tBar.add((MenuAction)this.editMenu.actionCopy);
        tBar.add((MenuAction)this.editMenu.actionPaste);
        tBar.add((MenuAction)this.editMenu.actionDelete);
        tBar.addSeparator();
        tBar.add((MenuAction)this.editMenu.actionMoveUp);
        tBar.add((MenuAction)this.editMenu.actionMoveDown);
        tBar.addSeparator();
        tBar.add((MenuAction)this.actionEditMetadata);
        tBar.add((MenuAction)this.actionEditSCORM);
        tBar.addSeparator();
        tBar.add((MenuAction)this.actionZipIt);
        tBar.add((MenuAction)this.actionViewFile);
        tBar.add((MenuAction)this.actionViewCP);
        tBar.addSeparator();
        tBar.add((MenuAction)this.actionValidate);
        tBar.add((MenuAction)this.actionSCMTValidate);
        return tBar;
    }

    public void updateUI() {
        super.updateUI();
        if (this.toolBar != null) {
            this.toolBar.updateUI();
        }
    }

    public DweezilToolBar getToolBar() {
        return this.toolBar;
    }
}

