/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.menu;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.gui.schemaviewer.SchemaWindow;
import uk.ac.reload.moonunit.SchemaController;

public class MenuAction_ViewSchema
extends MenuAction {
    private String _version;
    private Icon _icon;

    public MenuAction_ViewSchema(String version, Icon icon) {
        this._version = version;
        this._icon = icon;
        this.setText(version);
        this.setMenuIcon(icon);
    }

    public void actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SchemaController schemaController = EditorHandler.getSharedInstance().getSchemaControllerInstance(MenuAction_ViewSchema.this._version);
                if (schemaController == null) {
                    ErrorDialogBox.showWarning((String)("Could not get SchemaController for version: " + MenuAction_ViewSchema.this._version), (String)"Schema Viewer", null);
                    return;
                }
                EditorFrame.getInstance().setCursor(DweezilUIManager.WAIT_CURSOR);
                final SchemaWindow testWindow = new SchemaWindow(schemaController, MenuAction_ViewSchema.this._version);
                testWindow.setFrameIcon(MenuAction_ViewSchema.this._icon);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditorHandler.getSharedInstance().addInternalFrame(testWindow);
                        testWindow.show();
                    }
                });
                EditorFrame.getInstance().setCursor(DweezilUIManager.DEFAULT_CURSOR);
            }
        };
        thread.start();
    }
}

