/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor.formPlus.widgets;

import java.awt.Color;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import uk.ac.reload.editor.gui.widgets.FormattedTextFieldWidget;

public class DateFieldWidget
extends FormattedTextFieldWidget {
    public DateFieldWidget() {
        super(new SimpleDateFormat("yyyy-MM-dd"));
        this.setValue(new Date());
        this.setPreferredSize(this.getPreferredSize());
        this.setInputVerifier(new FormattedTextFieldVerifier());
        this.setUI();
    }

    public void insertTextValue(String text) {
        this.setValue(text);
    }

    public void setMaxLength(int maxLength) {
    }

    public boolean isSingleLine() {
        return false;
    }

    public class FormattedTextFieldVerifier
    extends InputVerifier {
        public boolean verify(JComponent input) {
            JFormattedTextField ftf;
            JFormattedTextField.AbstractFormatter formatter;
            if (input instanceof JFormattedTextField && (formatter = (ftf = (JFormattedTextField)input).getFormatter()) != null) {
                String text = ftf.getText();
                try {
                    formatter.stringToValue(text);
                    if (ftf.getBackground() == Color.PINK) {
                        ftf.setBackground(Color.WHITE);
                    }
                    return true;
                }
                catch (ParseException pe) {
                    ftf.setBackground(Color.PINK);
                    return true;
                }
            }
            return true;
        }

        public boolean shouldYieldFocus(JComponent input) {
            return this.verify(input);
        }
    }
}

