/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata.editor.tableview;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultMutableTreeNode;
import uk.ac.reload.editor.gui.ElementInfoPanel;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.editor.tableview.MD_TreeNode;
import uk.ac.reload.editor.metadata.editor.tableview.MD_TreeTable;
import uk.ac.reload.editor.metadata.editor.tableview.MD_TreeTableModel;
import uk.ac.reload.editor.metadata.xml.Metadata;

public class MD_TablePanel
extends JPanel {
    private MD_TreeTable _treeTable;
    private ElementInfoPanel _infoPanel;
    private JScrollPane _scrollPane;
    private JSplitPane splitPane;
    private Menu_Edit _editMenu;

    public MD_TablePanel(Menu_Edit editMenu) {
        this._editMenu = editMenu;
        this.setLayout(new BorderLayout());
        this._scrollPane = new JScrollPane();
        this._infoPanel = new ElementInfoPanel();
        this.splitPane = new JSplitPane(0);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setTopComponent(this._scrollPane);
        this.splitPane.setBottomComponent(this._infoPanel);
        this.add((Component)this.splitPane, "Center");
    }

    public void setDocument(Metadata metadata) {
        this.cleanup();
        MD_TreeTableModel model = new MD_TreeTableModel(metadata);
        this._treeTable = new MD_TreeTable(model, this._infoPanel, this._editMenu);
        this._scrollPane.setViewportView((Component)((Object)this._treeTable));
        this._treeTable.selectNode((DefaultMutableTreeNode)((Object)((MD_TreeNode)((Object)model.getRoot()))));
    }

    public void cleanup() {
        if (this._treeTable != null) {
            this._treeTable.cleanup();
        }
        if (this._infoPanel != null) {
            this._infoPanel.cleanup();
        }
    }

    public void refresh() {
        this._treeTable.refresh();
    }

    public void initView() {
        this.splitPane.setDividerLocation(0.7);
        this._infoPanel.initView();
    }

    public MD_TreeTable getMD_TreeTable() {
        return this._treeTable;
    }
}

