/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.scorm2004;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.layout.XYConstraints;
import uk.ac.reload.dweezil.gui.layout.XYLayout;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.datamodel.ElementBinding;
import uk.ac.reload.editor.gui.ElementAttributePanel;
import uk.ac.reload.editor.gui.ElementEditor;
import uk.ac.reload.editor.scorm.xml.scorm2004.SCORM13Constants;
import uk.ac.reload.editor.simplesequencing.scormgui.SimpleSequencingTabsPane;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaElement;

public class SCORM1_3SequencingEditorDialog
extends JDialog {
    protected ContentPackage _contentPackage;
    protected Element _itemElement;
    protected SchemaElement _schema_itemElement;
    protected JList _itemListBox;
    public static int WIDTH = 780;
    public static int WIDTH_MAC = 1025;
    public static int HEIGHT = 555;
    private SimpleSequencingTabsPane _simpleSequencingTabsPane;

    public SCORM1_3SequencingEditorDialog(ContentPackage contentPackage, Element itemElement, SchemaElement schema_itemElement, String title) {
        super(EditorFrame.getInstance(), title, true);
        this._itemElement = itemElement;
        this._contentPackage = contentPackage;
        this._schema_itemElement = schema_itemElement;
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SCORM1_3SequencingEditorDialog.this.dispose();
            }
        });
        JPanel mainPanel = this.createMainPanel();
        this.getContentPane().add((Component)mainPanel, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(WIDTH, HEIGHT);
        this.pack();
        this.setLocationRelativeTo(EditorFrame.getInstance());
    }

    protected JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        this._simpleSequencingTabsPane = new SimpleSequencingTabsPane(this._contentPackage, this._itemElement, this._schema_itemElement);
        mainPanel.add((Component)this._simpleSequencingTabsPane, "Center");
        return mainPanel;
    }

    protected JPanel createSCORMElementsPanel() {
        JPanel panel = new JPanel((LayoutManager)new XYLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        int x = 5;
        int y = 0;
        SchemaElement schemaElement = this._schema_itemElement.getChild("timeLimitAction", SCORM13Constants.ADLCP_NAMESPACE_13);
        this.addElement(schemaElement, panel, x, y += 60, 320, 100);
        x = 360;
        y = 0;
        schemaElement = this._schema_itemElement.getChild("dataFromLMS", SCORM13Constants.ADLCP_NAMESPACE_13);
        this.addElement(schemaElement, panel, x, y, 200, 25);
        y += 60;
        return panel;
    }

    protected void addElement(SchemaElement schemaElement, JPanel panel, int x, int y, int width, int height) {
        if (schemaElement != null) {
            SchemaController schemaController = this._contentPackage.getSchemaController();
            String name = schemaController.getElementFriendlyName(schemaElement.getXMLPath());
            JLabel nameLabel = new JLabel();
            nameLabel.setForeground(Color.BLUE);
            nameLabel.setFont(DweezilUIManager.boldFont12);
            nameLabel.setText(name);
            panel.add((Component)nameLabel, new XYConstraints(x, y, 100, 25));
            y += 30;
            Element element = this._itemElement.getChild(schemaElement.getName(), schemaElement.getNamespace());
            ElementBinding eb = new ElementBinding(element, schemaElement, this._contentPackage);
            if (element == null) {
                eb.setParentElement(this._itemElement);
            }
            ElementEditor elementEditor = new ElementEditor();
            elementEditor.setElementBinding(eb);
            panel.add((Component)elementEditor, new XYConstraints(x, y, width, height));
        }
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton btnOK = new JButton(Messages.getString("SCORM1_3SequencingEditorDialog.0"));
        btnOK.addActionListener(new OKClick());
        this.getRootPane().setDefaultButton(btnOK);
        buttonPanel.add(btnOK);
        return buttonPanel;
    }

    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
            }
        });
        super.show();
    }

    protected void finish() {
        this.dispose();
    }

    public void dispose() {
        try {
            super.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class ItemListModel
    extends AbstractListModel {
        Vector v = new Vector();

        public ItemListModel() {
            Element manifestElement = SCORM1_3SequencingEditorDialog.this._contentPackage.getParentManifestElement(SCORM1_3SequencingEditorDialog.this._itemElement);
            if (manifestElement != null) {
                Element[] items = SCORM1_3SequencingEditorDialog.this._contentPackage.getElementsInManifest(manifestElement, "item", manifestElement.getNamespace());
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].equals(SCORM1_3SequencingEditorDialog.this._itemElement)) continue;
                    ID_Mapping mapping = new ID_Mapping(items[i]);
                    this.v.add(mapping);
                }
            }
        }

        public int getSize() {
            return this.v.size();
        }

        public Object getElementAt(int index) {
            return this.v.elementAt(index);
        }
    }

    class ID_Mapping {
        Element _element;

        ID_Mapping(Element element) {
            this._element = element;
        }

        public String getIdentifier() {
            return this._element.getAttributeValue("identifier");
        }

        public String toString() {
            return SCORM1_3SequencingEditorDialog.this._contentPackage.getElementDisplayName(this._element) + "   (" + this.getIdentifier() + ")";
        }
    }

    private class AddClick
    extends AbstractAction
    implements MouseListener {
        ElementAttributePanel _elementEditor;

        public AddClick(ElementAttributePanel elementEditor) {
            this._elementEditor = elementEditor;
        }

        public void actionPerformed(ActionEvent e) {
            this.addText();
        }

        private void addText() {
            String id;
            Object object = SCORM1_3SequencingEditorDialog.this._itemListBox.getSelectedValue();
            if (object instanceof ID_Mapping && (id = ((ID_Mapping)object).getIdentifier()) != null) {
                this._elementEditor.getElementEditor().insertText(id);
                this._elementEditor.getElementEditor().setFocus();
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.addText();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class OKClick
    extends AbstractAction {
        private OKClick() {
        }

        public void actionPerformed(ActionEvent e) {
            int choice = JOptionPane.showConfirmDialog(null, Messages.getString("SCORM1_3SequencingEditorDialog.1"), Messages.getString("SCORM1_3SequencingEditorDialog.2"), 0);
            if (choice == 0) {
                SCORM1_3SequencingEditorDialog.this._simpleSequencingTabsPane.cleanUp();
                SCORM1_3SequencingEditorDialog.this.finish();
            }
        }
    }
}

