/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.transform;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.transform.ListFiles;
import uk.ac.reload.jdom.XMLUtils;

public class ScriptLoader {
    private List ioList;
    private static Document ctXRef = null;
    public static final File XFORM_FOLDER = new File("transform");
    private static ScriptLoader sl;

    public ScriptLoader(String rootDir) throws FileNotFoundException, JDOMException, IOException {
        if (ctXRef == null) {
            ListFiles ls = new ListFiles("xml");
            this.setIoList(ls.getFileListing(rootDir));
            this.setCtXRef();
        }
    }

    public ScriptLoader(File rootDir) throws FileNotFoundException, JDOMException, IOException {
        if (ctXRef == null) {
            ListFiles ls = new ListFiles("iotransform");
            this.setIoList(ls.getFileListing(rootDir));
            this.setCtXRef();
        }
    }

    public static ScriptLoader getScriptLoader() {
        if (sl == null) {
            try {
                sl = new ScriptLoader(XFORM_FOLDER);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sl;
    }

    public List getIoList() {
        return this.ioList;
    }

    public void setIoList(List list) {
        this.ioList = list;
    }

    public Document getCtXRef() {
        return ctXRef;
    }

    public void setCtXRef() {
        Element root = new Element("iotransforms");
        root.setText("Available xsl transforms");
        for (File file : this.ioList) {
            Document ioDoc = null;
            try {
                ioDoc = XMLUtils.readXMLFile((File)file);
            }
            catch (IOException e) {
                ErrorDialogBox.showWarning((String)Messages.getString("ScriptLoader.4"), (String)Messages.getString("ScriptLoader.5"), (Exception)e);
            }
            catch (JDOMException e) {
                ErrorDialogBox.showWarning((String)Messages.getString("ScriptLoader.6"), (String)Messages.getString("ScriptLoader.7"), (Exception)e);
            }
            if (ioDoc == null || !this.validateIODoc(ioDoc)) continue;
            Element sSchema = (Element)ioDoc.getRootElement().getChild("sourceSchema").clone();
            Element rootSSchema = this.findElementwithContent(root, sSchema);
            Element sLabel = (Element)ioDoc.getRootElement().getChild("sourceSchemaLabel").clone();
            Element tSchema = (Element)ioDoc.getRootElement().getChild("targetSchema").clone();
            Element tLabel = (Element)ioDoc.getRootElement().getChild("targetSchemaLabel").clone();
            Element xslLocn = (Element)ioDoc.getRootElement().getChild("XSLTfileLocation").clone();
            tSchema.addContent(tLabel);
            tSchema.addContent(xslLocn);
            Element folderToCopy = ioDoc.getRootElement().getChild("folderToCopy");
            if (folderToCopy != null) {
                tSchema.addContent((Element)folderToCopy.clone());
            }
            if (rootSSchema != null) {
                rootSSchema.addContent(tSchema);
                continue;
            }
            sSchema.addContent(sLabel);
            sSchema.addContent(tSchema);
            root.addContent(sSchema);
        }
        ctXRef = new Document(root);
    }

    private Element findElementwithContent(Element root, Element sSchema) {
        for (Element child : root.getChildren("sourceSchema")) {
            if (!child.getTextTrim().equalsIgnoreCase(sSchema.getTextTrim())) continue;
            return child;
        }
        return null;
    }

    public boolean hasXSLT(String sourceSchema) {
        for (Element child : ctXRef.getRootElement().getChildren("sourceSchema")) {
            String schemaLbl = child.getChild("sourceSchemaLabel").getText().trim();
            if (!schemaLbl.equalsIgnoreCase(sourceSchema.trim())) continue;
            return true;
        }
        return false;
    }

    public String getXSLT(String sourceSchema, String targetSchema) {
        for (Element child : ctXRef.getRootElement().getChildren("sourceSchema")) {
            String schemaLbl = child.getChild("sourceSchemaLabel").getText().trim();
            if (!schemaLbl.equalsIgnoreCase(sourceSchema.trim())) continue;
            for (Element tSchema : child.getChildren("targetSchema")) {
                String tschemaLbl = tSchema.getChild("targetSchemaLabel").getText().trim();
                if (!tschemaLbl.equalsIgnoreCase(targetSchema.trim())) continue;
                return tSchema.getChild("XSLTfileLocation").getText();
            }
        }
        return "";
    }

    public String getFolderToCopy(String sourceSchema, String targetSchema) {
        if (ctXRef.getRootElement().getChildren("sourceSchema") != null) {
            for (Element child : ctXRef.getRootElement().getChildren("sourceSchema")) {
                String schemaLbl = child.getChild("sourceSchemaLabel").getText().trim();
                if (!schemaLbl.equalsIgnoreCase(sourceSchema.trim())) continue;
                for (Element tSchema : child.getChildren("targetSchema")) {
                    Element folderLocn;
                    String tschemaLbl = tSchema.getChild("targetSchemaLabel").getText().trim();
                    if (!tschemaLbl.equalsIgnoreCase(targetSchema.trim()) || (folderLocn = tSchema.getChild("folderToCopy")) == null) continue;
                    return folderLocn.getText();
                }
            }
        }
        return "";
    }

    public boolean validateIODoc(Document ioDoc) {
        boolean result = true;
        if (ioDoc.getRootElement().getChild("sourceSchema") == null || ioDoc.getRootElement().getChild("sourceSchema").getTextTrim() == null || ioDoc.getRootElement().getChild("sourceSchema").getTextTrim().equals("")) {
            return false;
        }
        if (ioDoc.getRootElement().getChild("sourceSchemaLabel") == null || ioDoc.getRootElement().getChild("sourceSchemaLabel").getTextTrim() == null || ioDoc.getRootElement().getChild("sourceSchemaLabel").getTextTrim().equals("")) {
            return false;
        }
        if (ioDoc.getRootElement().getChild("targetSchema") == null || ioDoc.getRootElement().getChild("targetSchema").getTextTrim() == null || ioDoc.getRootElement().getChild("targetSchema").getTextTrim().equals("")) {
            return false;
        }
        if (ioDoc.getRootElement().getChild("targetSchemaLabel") == null || ioDoc.getRootElement().getChild("targetSchemaLabel").getTextTrim() == null || ioDoc.getRootElement().getChild("targetSchemaLabel").getTextTrim().equals("")) {
            return false;
        }
        if (ioDoc.getRootElement().getChild("XSLTfileLocation") == null || ioDoc.getRootElement().getChild("XSLTfileLocation").getTextTrim() == null || ioDoc.getRootElement().getChild("XSLTfileLocation").getTextTrim().equals("")) {
            return false;
        }
        return result;
    }
}

