/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.transform;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public class StylesheetCache {
    private static Map cache = new HashMap();

    public static synchronized void flushAll() {
        cache.clear();
    }

    public static synchronized Transformer newTransformer(File xsltFile, boolean useCache) throws TransformerConfigurationException {
        Templates entry = null;
        if (useCache) {
            entry = (Templates)cache.get(xsltFile);
        }
        if (entry == null) {
            Templates templates;
            StreamSource xslSource = new StreamSource(xsltFile);
            TransformerFactory transFact = TransformerFactory.newInstance();
            entry = templates = transFact.newTemplates(xslSource);
            cache.put(xsltFile, entry);
        }
        return entry.newTransformer();
    }

    private StylesheetCache() {
    }
}

