/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.transform;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.diva.util.IProgressMonitor;
import uk.ac.reload.dweezil.gui.DweezilProgressMonitor;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.contentpackaging.editor.CP_Editor;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.transform.ScriptLoader;
import uk.ac.reload.editor.transform.XSLTransfomer;
import uk.ac.reload.editor.transform.gui.CTFileOpenDialog;
import uk.ac.reload.editor.transform.gui.FileFilterDialog;
import uk.ac.reload.editor.transform.gui.SourceTargetDialog;
import uk.ac.reload.editor.transform.helper.RelativePath;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.schema.SchemaException;

public class XMLConverter {
    private static SourceTargetDialog stDialog;
    private static ScriptLoader scriptLoader;
    private static String srcVersion;
    private static String targVersion;
    private static String xsltLocn;
    private static File sFile;
    private static File tFile;
    private static DweezilProgressMonitor progressMonitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ctImport() throws JDOMException, SchemaException, IOException {
        srcVersion = "";
        targVersion = "";
        xsltLocn = "";
        sFile = null;
        tFile = null;
        progressMonitor = null;
        stDialog = new SourceTargetDialog(EditorFrame.getInstance(), null);
        srcVersion = stDialog.showDialog();
        if (srcVersion == null) {
            return;
        }
        targVersion = stDialog.getSchemaTName();
        scriptLoader = ScriptLoader.getScriptLoader();
        xsltLocn = scriptLoader.getXSLT(srcVersion, targVersion);
        CTFileOpenDialog ctDialog = new CTFileOpenDialog(srcVersion, targVersion, EditorFrame.getInstance());
        ctDialog.showDialog();
        sFile = ctDialog.getSourceFile();
        tFile = ctDialog.getTargetFile();
        if (xsltLocn.equalsIgnoreCase("") || sFile == null || tFile == null) {
            return;
        }
        if (sFile.getName().toLowerCase().endsWith(".zip")) {
            if (!CP_EditorHandler.containsManifest(sFile)) {
                throw new IOException(Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.8"));
            }
            progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.10"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.11"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_EditorHandler.12"), true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
            try {
                sFile = CP_EditorHandler.unzipContentPackage(sFile, tFile, progressMonitor);
            }
            finally {
                progressMonitor.close();
            }
        }
        try {
            String folder;
            File supportFolder;
            String[] schLocns;
            progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.38"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
            FileUtils.copyFolder((File)sFile.getParentFile(), (File)tFile, (IProgressMonitor)progressMonitor);
            if (ctDialog.isExcludeControlSchema() && (schLocns = XMLConverter.getSchemaLocations(sFile)) != null) {
                for (int i = 0; i < schLocns.length; ++i) {
                    new File(tFile + File.separator + schLocns[i]).delete();
                }
            }
            progressMonitor.close();
            String folderLocn = scriptLoader.getFolderToCopy(srcVersion, targVersion);
            if (!"".equals(folderLocn) && (supportFolder = new File(folder = ScriptLoader.XFORM_FOLDER.getAbsolutePath() + File.separatorChar + File.separatorChar + folderLocn.trim())).exists() && supportFolder.isDirectory()) {
                FileUtils.copyFolder((File)supportFolder, (File)tFile);
            }
        }
        catch (Exception ex) {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            ErrorDialogBox.showWarning((String)Messages.getString("XSLConvertor.0"), (String)Messages.getString("XSLConvertor.1"), (Exception)ex);
            return;
        }
        File manifestLocn = new File(tFile, "imsmanifest.xml");
        Document manifestDoc = XMLUtils.readXMLFile((File)manifestLocn);
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)manifestDoc);
        String versionCP = "";
        if (srcVersion.indexOf("SCORM") != -1) {
            nameSpace = XMLUtils.getDocumentNamespace((Document)manifestDoc, (String)"adlcp");
            versionCP = EditorHandler.SCORM12_EDITORHANDLER.getVersion(nameSpace);
            versionCP = versionCP.substring(0, versionCP.indexOf(",")).trim();
        } else {
            versionCP = EditorHandler.CP_EDITORHANDLER.getVersion(nameSpace);
        }
        if (versionCP == null) {
            JOptionPane.showMessageDialog(null, Messages.getString("XSLConvertor.2"), Messages.getString("XSLConvertor.3"), 0);
            return;
        }
        if (!versionCP.equalsIgnoreCase(srcVersion)) {
            return;
        }
        xsltLocn = ScriptLoader.XFORM_FOLDER.getAbsolutePath() + File.separatorChar + xsltLocn.trim();
        if (manifestLocn.exists()) {
            manifestLocn.delete();
        }
        if ((manifestLocn = XSLTransfomer.transform(sFile, new File(xsltLocn), manifestLocn, true)) == null) {
            return;
        }
        EditorHandler.getSharedInstance().openFile(manifestLocn);
    }

    public static void ctExport(CP_Editor cpEditor) throws JDOMException, SchemaException, IOException {
        String folder;
        File supportFolder;
        String[] schLocns;
        targVersion = "";
        xsltLocn = "";
        sFile = null;
        tFile = null;
        String versionCP = "";
        scriptLoader = ScriptLoader.getScriptLoader();
        ContentPackage cp = cpEditor.getContentPackage();
        Document manifestDoc = cp.getDocument();
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)manifestDoc);
        Namespace nameSpace1 = XMLUtils.getDocumentNamespace((Document)manifestDoc, (String)"adlcp");
        if (nameSpace1 != null) {
            versionCP = EditorHandler.SCORM12_EDITORHANDLER.getVersion(nameSpace1);
            versionCP = versionCP.substring(0, versionCP.indexOf(",")).trim();
        } else {
            versionCP = EditorHandler.CP_EDITORHANDLER.getVersion(nameSpace);
        }
        if (!scriptLoader.hasXSLT(versionCP)) {
            JOptionPane.showMessageDialog(EditorFrame.getInstance(), Messages.getString("XSLConvertor.4"));
            return;
        }
        stDialog = new SourceTargetDialog(EditorFrame.getInstance(), versionCP);
        stDialog.showDialog();
        targVersion = stDialog.getSchemaTName();
        if (targVersion == null) {
            return;
        }
        xsltLocn = scriptLoader.getXSLT(versionCP, targVersion);
        String manifestPath = cp.getFile().getAbsolutePath();
        CTFileOpenDialog ctDialog = new CTFileOpenDialog(versionCP, targVersion, manifestPath, (JFrame)EditorFrame.getInstance());
        ctDialog.showDialog();
        sFile = new File(manifestPath);
        tFile = ctDialog.getTargetFile();
        if (xsltLocn.equalsIgnoreCase("") || tFile == null) {
            return;
        }
        XMLConverter.copyCP(cp, tFile);
        if (ctDialog.isExcludeControlSchema() && (schLocns = XMLConverter.getSchemaLocations(manifestDoc)) != null) {
            for (int i = 0; i < schLocns.length; ++i) {
                new File(tFile + File.separator + schLocns[i]).delete();
            }
        }
        xsltLocn = ScriptLoader.XFORM_FOLDER.getAbsolutePath() + File.separatorChar + xsltLocn.trim();
        File manifestLocn = new File(tFile, "imsmanifest.xml");
        if (manifestLocn.exists()) {
            manifestLocn.delete();
        }
        if ((manifestLocn = XSLTransfomer.transform(sFile, new File(xsltLocn), manifestLocn, true)) == null) {
            return;
        }
        String folderLocn = scriptLoader.getFolderToCopy(versionCP, targVersion);
        if (!"".equals(folderLocn) && (supportFolder = new File(folder = ScriptLoader.XFORM_FOLDER.getAbsolutePath() + File.separatorChar + File.separatorChar + folderLocn.trim())).exists() && supportFolder.isDirectory()) {
            FileUtils.copyFolder((File)supportFolder, (File)tFile);
        }
        EditorHandler.getSharedInstance().openFile(manifestLocn);
    }

    public static void ctBatchExport() throws JDOMException, SchemaException, IOException {
        srcVersion = "";
        targVersion = "";
        xsltLocn = "";
        sFile = null;
        tFile = null;
        progressMonitor = null;
        stDialog = new SourceTargetDialog(EditorFrame.getInstance(), null);
        srcVersion = stDialog.showDialog();
        if (srcVersion == null) {
            return;
        }
        targVersion = stDialog.getSchemaTName();
        if (targVersion == null) {
            return;
        }
        scriptLoader = ScriptLoader.getScriptLoader();
        xsltLocn = scriptLoader.getXSLT(srcVersion, targVersion);
        CTFileOpenDialog ctDialog = new CTFileOpenDialog(srcVersion, targVersion, true, (JFrame)EditorFrame.getInstance());
        ctDialog.showDialog();
        sFile = ctDialog.getSourceFile();
        tFile = ctDialog.getTargetFile();
        if (xsltLocn.equalsIgnoreCase("") || sFile == null || tFile == null) {
            return;
        }
        try {
            progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.38"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
            FileUtils.copyFolder((File)sFile, (File)tFile, (IProgressMonitor)progressMonitor);
            progressMonitor.close();
        }
        catch (Exception ex) {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.32"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.33"), (Exception)ex);
            return;
        }
        FileFilterDialog filesDialog = new FileFilterDialog(sFile);
        ArrayList fileLst = filesDialog.showDialog();
        xsltLocn = ScriptLoader.XFORM_FOLDER.getAbsolutePath() + File.separatorChar + xsltLocn.trim();
        if (fileLst != null && fileLst.size() > 0) {
            int docCount = 0;
            for (File file : fileLst) {
                String relPath = RelativePath.getRelativePath(sFile, file);
                File xmlLocn = new File(tFile, relPath);
                if (file.exists() && file.isFile()) {
                    if (xmlLocn.exists()) {
                        xmlLocn.delete();
                    }
                    if ((xmlLocn = XSLTransfomer.transform(file, new File(xsltLocn), xmlLocn, true)) == null) {
                        System.err.println(Messages.getString("CTDialog.11"));
                        continue;
                    }
                    ++docCount;
                    continue;
                }
                System.err.println(Messages.getString("CTDialog.12"));
            }
            String message = Messages.getString("CTDialog.13") + docCount + Messages.getString("CTDialog.14");
            JOptionPane.showMessageDialog(EditorFrame.getInstance(), message);
        }
    }

    public static void copyCP(ContentPackage cp, File tFolder) {
        DweezilProgressMonitor progressMonitor = null;
        progressMonitor = new DweezilProgressMonitor((Component)EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.31"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), Messages.getString("uk.ac.reload.editor.contentpackaging.CP_Editor.16"), true, (Icon)DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/app16.gif"));
        try {
            cp.saveDocumentAs(tFolder, (IProgressMonitor)progressMonitor);
        }
        catch (Exception ex) {
            progressMonitor.close();
        }
        progressMonitor.close();
    }

    public static void convertXML() throws FileNotFoundException, JDOMException, IOException {
        String srcVersion = "";
        String targVersion = "";
        String xsltLocn = "";
        File sFile = null;
        File tFile = null;
        stDialog = new SourceTargetDialog(EditorFrame.getInstance(), "adl & imscp");
        srcVersion = stDialog.showDialog();
        if (srcVersion == null) {
            return;
        }
        targVersion = stDialog.getSchemaTName();
        if (targVersion == null) {
            return;
        }
        scriptLoader = ScriptLoader.getScriptLoader();
        xsltLocn = scriptLoader.getXSLT(srcVersion, targVersion);
        CTFileOpenDialog ctDialog = new CTFileOpenDialog(srcVersion, targVersion, EditorFrame.getInstance());
        ctDialog.showDialog();
        sFile = ctDialog.getSourceFile();
        tFile = ctDialog.getTargetFile();
        if (xsltLocn.equalsIgnoreCase("") || sFile == null || tFile == null) {
            return;
        }
        if (sFile.getName().indexOf(".xml") == -1) {
            return;
        }
        xsltLocn = ScriptLoader.XFORM_FOLDER.getAbsolutePath() + File.separatorChar + xsltLocn.trim();
        String sourceFileName = sFile.getName();
        File xsltResultLocn = new File(tFile, sourceFileName = sourceFileName.substring(0, sourceFileName.lastIndexOf(".")) + "copy.xml");
        if (xsltResultLocn.exists()) {
            xsltResultLocn.delete();
        }
        if ((xsltResultLocn = XSLTransfomer.transform(sFile, new File(xsltLocn), xsltResultLocn, true)) == null) {
            return;
        }
        EditorHandler.getSharedInstance().openFile(xsltResultLocn);
    }

    private static String[] getSchemaLocations(File file) {
        Document xmlDoc;
        try {
            xmlDoc = XMLUtils.readXMLFile((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
        return XMLConverter.getSchemaLocations(xmlDoc);
    }

    private static String[] getSchemaLocations(Document xmlDoc) {
        String[] schemaLocns = null;
        if (xmlDoc.hasRootElement()) {
            Element root = xmlDoc.getRootElement();
            String schLocnStr = root.getAttributeValue(XMLUtils.XSI_SchemaLocation, XMLUtils.XSI_Namespace);
            if (schLocnStr == null) {
                schLocnStr = root.getAttributeValue(XMLUtils.XSI_SchemaLocation, XMLUtils.XSI_NamespaceOLD);
            }
            if (schLocnStr != null && !"".equals(schLocnStr)) {
                StringTokenizer parser = new StringTokenizer(schLocnStr);
                int noOfLocn = parser.countTokens() / 2;
                String[] locns = new String[noOfLocn];
                while (parser.hasMoreTokens()) {
                    parser.nextToken();
                    String schemaLoc = parser.nextToken();
                    if (schemaLoc.indexOf("http") != -1) continue;
                    locns[--noOfLocn] = schemaLoc;
                }
                schemaLocns = locns;
            }
            return schemaLocns;
        }
        return null;
    }

    static {
        srcVersion = "";
        targVersion = "";
        xsltLocn = "";
        sFile = null;
        tFile = null;
        progressMonitor = null;
    }
}

