/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.transform.gui;

import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.Constraint;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import uk.ac.reload.dweezil.gui.DweezilFileChooser;
import uk.ac.reload.dweezil.gui.DweezilFileFilter;
import uk.ac.reload.dweezil.gui.DweezilFolderChooser;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.Messages;

public class CTFileOpenDialog
extends JDialog {
    private DweezilFileChooser _sourceChooser;
    private File sourceFile;
    private DweezilFolderChooser _targetChooser;
    private File targetFile;
    private RelativeLayout layout;
    private DweezilFileFilter filter;
    private JButton targetOpenBtn;
    private JButton srcOpenBtn;
    private JTextField txtSourceFile;
    private JTextField txtTargetFile;
    boolean excludeControlSchema;
    private JLabel lblSourceFile;

    public CTFileOpenDialog(String sName, String tName, JFrame parent) throws HeadlessException {
        super(parent, Messages.getString("CTFileOpenDialog.0"), true);
        this.init(sName, tName);
        this.srcOpenBtn.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                CTFileOpenDialog.this.sourceFile = DweezilFileChooser.askFileNameOpen((Component)CTFileOpenDialog.this, (String)Messages.getString("CTFileOpenDialog.1"), (FileFilter)CTFileOpenDialog.this.filter);
                if (CTFileOpenDialog.this.sourceFile != null) {
                    CTFileOpenDialog.this.txtSourceFile.setText(CTFileOpenDialog.this.sourceFile.getName());
                }
            }
        });
    }

    public CTFileOpenDialog(String sName, String tName, String manifest, JFrame parent) throws HeadlessException {
        super(parent, Messages.getString("CTFileOpenDialog.2"), true);
        this.init(sName, tName);
        this.txtSourceFile.setText(manifest);
        this.txtSourceFile.setEditable(false);
        this.srcOpenBtn.setEnabled(false);
    }

    public CTFileOpenDialog(String sName, String tName, boolean batch, JFrame parent) throws HeadlessException {
        super(parent, Messages.getString("CTFileOpenDialog.4"), true);
        this.init(sName, tName);
        this._sourceChooser = new DweezilFolderChooser();
        this.lblSourceFile.setText(Messages.getString("CTFileOpenDialog.72"));
        this.srcOpenBtn.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                int rtn = CTFileOpenDialog.this._sourceChooser.showDialog((Component)CTFileOpenDialog.this, Messages.getString("CTFileOpenDialog.71"));
                if (rtn != 0) {
                    return;
                }
                CTFileOpenDialog.this.sourceFile = CTFileOpenDialog.this._sourceChooser.getSelectedFile();
                if (CTFileOpenDialog.this.sourceFile != null) {
                    CTFileOpenDialog.this.txtSourceFile.setText(CTFileOpenDialog.this.sourceFile.getName());
                }
            }
        });
    }

    public DweezilFileChooser getSourceFileChooser() {
        return this._sourceChooser;
    }

    public DweezilFolderChooser getTargetFolderChooser() {
        return this._targetChooser;
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    protected void init(String sName, String tName) {
        this.setSize(500, 200);
        this.layout = new RelativeLayout();
        this.getContentPane().setLayout((LayoutManager)this.layout);
        this._sourceChooser = new DweezilFileChooser();
        this._targetChooser = new DweezilFolderChooser();
        this.filter = new DweezilFileFilter(new String[]{"xml", "zip"}, Messages.getString("uk.ac.reload.editor.EditorHandler.1"));
        JLabel title = new JLabel(Messages.getString("CTFileOpenDialog.6"));
        title.setFont(title.getFont().deriveFont(14.0f));
        this.getContentPane().add((Component)title, "title");
        this.layout.addConstraint("title", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 10));
        this.layout.addConstraint("title", AttributeType.HORIZONTAL_CENTER, (Constraint)new AttributeConstraint("_container", AttributeType.HORIZONTAL_CENTER));
        JLabel lblSchema = new JLabel(Messages.getString("CTFileOpenDialog.10"));
        this.getContentPane().add((Component)lblSchema, "lblSchema");
        this.layout.addConstraint("lblSchema", AttributeType.TOP, (Constraint)new AttributeConstraint("title", AttributeType.BOTTOM, 5));
        this.layout.addConstraint("lblSchema", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 20));
        JLabel lbltchema = new JLabel(Messages.getString("CTFileOpenDialog.15"));
        this.getContentPane().add((Component)lbltchema, "lbltchema");
        this.layout.addConstraint("lbltchema", AttributeType.TOP, (Constraint)new AttributeConstraint("lblSchema", AttributeType.TOP));
        this.layout.addConstraint("lbltchema", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 250));
        JTextField txtSource = new JTextField(sName);
        txtSource.setEditable(false);
        this.getContentPane().add((Component)txtSource, "txtSource");
        this.layout.addConstraint("txtSource", AttributeType.TOP, (Constraint)new AttributeConstraint("lblSchema", AttributeType.BOTTOM, 5));
        this.layout.addConstraint("txtSource", AttributeType.LEFT, (Constraint)new AttributeConstraint("lblSchema", AttributeType.LEFT));
        this.layout.addConstraint("txtSource", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 180));
        JTextField txtTarget = new JTextField(tName);
        txtTarget.setEditable(false);
        this.getContentPane().add((Component)txtTarget, "txtTarget");
        this.layout.addConstraint("txtTarget", AttributeType.TOP, (Constraint)new AttributeConstraint("lbltchema", AttributeType.BOTTOM, 5));
        this.layout.addConstraint("txtTarget", AttributeType.LEFT, (Constraint)new AttributeConstraint("lbltchema", AttributeType.LEFT));
        this.layout.addConstraint("txtTarget", AttributeType.RIGHT, (Constraint)new AttributeConstraint("lbltchema", AttributeType.LEFT, 180));
        this.lblSourceFile = new JLabel(Messages.getString("CTFileOpenDialog.33"));
        this.getContentPane().add((Component)this.lblSourceFile, "lblSourceFile");
        this.layout.addConstraint("lblSourceFile", AttributeType.TOP, (Constraint)new AttributeConstraint("txtSource", AttributeType.BOTTOM, 10));
        this.layout.addConstraint("lblSourceFile", AttributeType.LEFT, (Constraint)new AttributeConstraint("txtSource", AttributeType.LEFT));
        this.txtSourceFile = new JTextField("");
        this.txtSourceFile.setEditable(false);
        this.getContentPane().add((Component)this.txtSourceFile, "txtSourceFile");
        this.layout.addConstraint("txtSourceFile", AttributeType.TOP, (Constraint)new AttributeConstraint("lblSourceFile", AttributeType.BOTTOM, 5));
        this.layout.addConstraint("txtSourceFile", AttributeType.LEFT, (Constraint)new AttributeConstraint("lblSourceFile", AttributeType.LEFT));
        this.layout.addConstraint("txtSourceFile", AttributeType.RIGHT, (Constraint)new AttributeConstraint("txtSource", AttributeType.RIGHT));
        this.srcOpenBtn = new JButton();
        this.srcOpenBtn.setText("...");
        this.getContentPane().add((Component)this.srcOpenBtn, "srcOpenBtn");
        this.layout.addConstraint("srcOpenBtn", AttributeType.TOP, (Constraint)new AttributeConstraint("lblSourceFile", AttributeType.BOTTOM, 5));
        this.layout.addConstraint("srcOpenBtn", AttributeType.LEFT, (Constraint)new AttributeConstraint("txtSourceFile", AttributeType.RIGHT));
        this.layout.addConstraint("srcOpenBtn", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("txtSourceFile", AttributeType.BOTTOM));
        JLabel lblTargetFile = new JLabel(Messages.getString("CTFileOpenDialog.55"));
        this.getContentPane().add((Component)lblTargetFile, "lblTargetFile");
        this.layout.addConstraint("lblTargetFile", AttributeType.TOP, (Constraint)new AttributeConstraint("txtTarget", AttributeType.BOTTOM, 5));
        this.layout.addConstraint("lblTargetFile", AttributeType.LEFT, (Constraint)new AttributeConstraint("txtTarget", AttributeType.LEFT));
        this.txtTargetFile = new JTextField("");
        this.txtTargetFile.setEditable(false);
        this.getContentPane().add((Component)this.txtTargetFile, "txtTargetFile");
        this.layout.addConstraint("txtTargetFile", AttributeType.TOP, (Constraint)new AttributeConstraint("lblTargetFile", AttributeType.BOTTOM, 5));
        this.layout.addConstraint("txtTargetFile", AttributeType.LEFT, (Constraint)new AttributeConstraint("lblTargetFile", AttributeType.LEFT));
        this.layout.addConstraint("txtTargetFile", AttributeType.RIGHT, (Constraint)new AttributeConstraint("txtTarget", AttributeType.RIGHT));
        this.targetOpenBtn = new JButton();
        this.targetOpenBtn.setText("...");
        this.targetOpenBtn.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                int rtn = CTFileOpenDialog.this.getTargetFolderChooser().showDialog((Component)CTFileOpenDialog.this, Messages.getString("CTFileOpenDialog.70"));
                if (rtn != 0) {
                    return;
                }
                CTFileOpenDialog.this.targetFile = CTFileOpenDialog.this.getTargetFolderChooser().getSelectedFileAndStore();
                if (CTFileOpenDialog.this.targetFile != null) {
                    CTFileOpenDialog.this.txtTargetFile.setText(CTFileOpenDialog.this.targetFile.getName());
                }
            }
        });
        this.getContentPane().add((Component)this.targetOpenBtn, "targetOpenBtn");
        this.layout.addConstraint("targetOpenBtn", AttributeType.TOP, (Constraint)new AttributeConstraint("lblTargetFile", AttributeType.BOTTOM, 5));
        this.layout.addConstraint("targetOpenBtn", AttributeType.LEFT, (Constraint)new AttributeConstraint("txtTargetFile", AttributeType.RIGHT));
        this.layout.addConstraint("targetOpenBtn", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("txtTargetFile", AttributeType.BOTTOM));
        AbstractAction action = new AbstractAction("Exclude control schema while copying this CP"){

            public void actionPerformed(ActionEvent evt) {
                JCheckBox cb = (JCheckBox)evt.getSource();
                boolean isSel = cb.isSelected();
                CTFileOpenDialog.this.excludeControlSchema = isSel;
            }
        };
        JCheckBox checkBox = new JCheckBox(action);
        this.getContentPane().add((Component)checkBox, "checkBox");
        this.layout.addConstraint("checkBox", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        this.layout.addConstraint("checkBox", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM, -5));
        JButton btnCancel = new JButton(Messages.getString("CTFileOpenDialog.3"));
        btnCancel.addActionListener(new CancelClick());
        this.getContentPane().add((Component)btnCancel, "btnCancel");
        this.layout.addConstraint("btnCancel", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        this.layout.addConstraint("btnCancel", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM, -5));
        JButton btnOK = new JButton(Messages.getString("CTFileOpenDialog.82"));
        btnOK.addActionListener(new OKClick());
        this.getContentPane().add((Component)btnOK, "btnOK");
        this.layout.addConstraint("btnOK", AttributeType.RIGHT, (Constraint)new AttributeConstraint("btnCancel", AttributeType.LEFT, -5));
        this.layout.addConstraint("btnOK", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM, -5));
        this.setLocationRelativeTo(EditorFrame.getInstance());
    }

    public boolean isExcludeControlSchema() {
        return this.excludeControlSchema;
    }

    private class CancelClick
    extends AbstractAction {
        private CancelClick() {
        }

        public void actionPerformed(ActionEvent e) {
            CTFileOpenDialog.this.sourceFile = null;
            CTFileOpenDialog.this.dispose();
        }
    }

    private class OKClick
    extends AbstractAction {
        private OKClick() {
        }

        public void actionPerformed(ActionEvent e) {
            CTFileOpenDialog.this.dispose();
        }
    }
}

