/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.dnd;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class JTreeDragDropHandler
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    private JTree _tree;

    protected JTreeDragDropHandler(JTree tree) {
        this._tree = tree;
        new DropTarget(this._tree, this);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this._tree, 3, this);
    }

    public JTree getTree() {
        return this._tree;
    }

    protected TreeNode getDragSourceTreeNode(DragGestureEvent event) {
        TreeNode node = null;
        Point location = event.getDragOrigin();
        TreePath dragPath = this._tree.getPathForLocation(location.x, location.y);
        if (dragPath != null && this._tree.isPathSelected(dragPath)) {
            node = (TreeNode)dragPath.getLastPathComponent();
        }
        return node;
    }

    protected TreeNode getDragOverTreeNode(DropTargetDragEvent event) {
        TreeNode node = null;
        Point location = event.getLocation();
        TreePath dragPath = this._tree.getPathForLocation(location.x, location.y);
        if (dragPath != null) {
            node = (TreeNode)dragPath.getLastPathComponent();
        }
        return node;
    }

    public BufferedImage getDragImage(TreePath path, Point ptDragOrigin) {
        Point ptOffset = new Point();
        Rectangle raPath = this._tree.getPathBounds(path);
        ptOffset.setLocation(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
        JLabel lbl = (JLabel)this._tree.getCellRenderer().getTreeCellRendererComponent(this._tree, path.getLastPathComponent(), false, this._tree.isExpanded(path), this._tree.getModel().isLeaf(path.getLastPathComponent()), 0, false);
        lbl.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
        BufferedImage imgGhost = new BufferedImage((int)raPath.getWidth(), (int)raPath.getHeight(), 3);
        Graphics2D g2 = imgGhost.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        lbl.paint(g2);
        return imgGhost;
    }

    public abstract boolean isDropOK(DropTargetDragEvent var1);
}

