/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import uk.ac.reload.dweezil.util.DweezilUIManager;

public class ComponentHiderButton
extends JButton {
    private JComponent _component;
    private boolean hidden = false;
    public static Dimension zeroSize = new Dimension(0, 0);
    public static Icon iconSouth = DweezilUIManager.getIcon("uk/ac/reload/dweezil/resources/south.gif");
    public static Icon iconEast = DweezilUIManager.getIcon("uk/ac/reload/dweezil/resources/east.gif");

    public ComponentHiderButton() {
        this.setIcon(iconSouth);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentHiderButton.this.showComponent(ComponentHiderButton.this.hidden);
            }
        });
    }

    public ComponentHiderButton(JComponent component) {
        this();
        this.setComponent(component);
    }

    public void setComponent(JComponent component) {
        this._component = component;
    }

    public JComponent getComponent() {
        return this._component;
    }

    public void showComponent(boolean show) {
        if (show) {
            if (this._component != null) {
                this._component.setPreferredSize(null);
            }
            this.setIcon(iconSouth);
            this.hidden = false;
        } else {
            if (this._component != null) {
                this._component.setPreferredSize(zeroSize);
            }
            this.setIcon(iconEast);
            this.hidden = true;
        }
        if (this._component != null) {
            this._component.revalidate();
            for (Container parent = this._component.getParent(); parent != null; parent = parent.getParent()) {
                ((Component)parent).validate();
            }
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    protected void setUI() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void updateUI() {
        super.updateUI();
        this.setUI();
    }

    public Dimension getPreferredSize() {
        return new Dimension(12, 12);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }
}

