/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import uk.ac.reload.dweezil.gui.DweezilToolBar;
import uk.ac.reload.dweezil.gui.IComponentSelectionListener;
import uk.ac.reload.dweezil.menu.MenuAction;

public class CoolBar
extends JPanel {
    private DweezilToolBar _toolBar;
    private JLabel _label;
    private boolean _isSelected;
    private int _height = 26;
    private Color _color = new Color(128, 128, 255);
    protected MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            CoolBar.this.setSelected(true);
        }
    };
    private Vector _listeners;

    public CoolBar() {
        super(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 5, 0, 0));
        this._label = new JLabel();
        this.add((Component)this._label, "West");
        this._toolBar = new DweezilToolBar();
        this.add((Component)this._toolBar, "East");
        this.addMouseListener(this.mouseListener);
        this._label.addMouseListener(this.mouseListener);
    }

    public CoolBar(String text) {
        this();
        this.setText(text);
    }

    public CoolBar(String text, Icon icon) {
        this(text);
        this.setIcon(icon);
    }

    public void setText(String text) {
        this._label.setText(text);
    }

    public void setIcon(Icon icon) {
        this._label.setIcon(icon);
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public void setGradientColor(Color color) {
        this._color = color;
    }

    public void addMenuAction(MenuAction action) {
        this.addButton(action.getButton());
    }

    public void addButton(JButton button) {
        button.setPreferredSize(new Dimension(this._height - 2, this._height - 2));
        button.addMouseListener(this.mouseListener);
        this._toolBar.add(button);
    }

    public void addComponent(Component component) {
        component.addMouseListener(this.mouseListener);
        this._toolBar.add(component);
    }

    public void setSelected(boolean selected) {
        if (selected == this._isSelected) {
            return;
        }
        this._isSelected = selected;
        if (selected) {
            this._label.setForeground(Color.white);
            this.fireComponentSelected();
        } else {
            this._label.setForeground(Color.black);
        }
        this.repaint();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._label.setEnabled(enabled);
    }

    public DweezilToolBar getToolBar() {
        return this._toolBar;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this._label.getWidth() + this._toolBar.getWidth() + 10, super.getMinimumSize().height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this._height);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this._isSelected && this.isEnabled()) {
            Graphics2D g2d = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this._color, (int)((double)this.getWidth() * 0.7), this.getHeight(), this.getBackground());
            g2d.setPaint(gradient);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public synchronized void addComponentSelectionListener(IComponentSelectionListener listener) {
        if (this._listeners == null) {
            this._listeners = new Vector();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.addElement(listener);
        }
    }

    public synchronized void removeComponentSelectionListener(IComponentSelectionListener listener) {
        if (this._listeners != null) {
            this._listeners.removeElement(listener);
        }
    }

    protected void fireComponentSelected() {
        if (this._listeners != null) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                IComponentSelectionListener listener = (IComponentSelectionListener)this._listeners.elementAt(i);
                listener.componentSelected(this);
            }
        }
    }
}

