/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import uk.ac.reload.dweezil.gui.CoolBar;
import uk.ac.reload.dweezil.gui.IComponentSelectionListener;
import uk.ac.reload.dweezil.menu.MenuAction;

public class CoolBarPanel
extends JPanel {
    private CoolBar _coolBar;
    private Component _component;
    protected MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            CoolBarPanel.this._coolBar.setSelected(true);
        }
    };
    private Vector _listeners;

    public CoolBarPanel() {
        super(new BorderLayout());
        this._coolBar = new CoolBar();
        this.add((Component)this._coolBar, "North");
        this.setBackground(Color.white);
        this._coolBar.addComponentSelectionListener(new IComponentSelectionListener(){

            public void componentSelected(Component component) {
                CoolBarPanel.this.fireComponentSelected();
            }
        });
    }

    public CoolBarPanel(String text) {
        this();
        this.setText(text);
    }

    public CoolBarPanel(String text, Icon icon) {
        this(text);
        this.setIcon(icon);
    }

    public void setText(String text) {
        this._coolBar.setText(text);
    }

    public void setIcon(Icon icon) {
        this._coolBar.setIcon(icon);
    }

    public void setSelected(boolean selected) {
        this._coolBar.setSelected(selected);
    }

    public void addMenuActionToCoolBar(MenuAction action) {
        this._coolBar.addMenuAction(action);
    }

    public void addButtonToCoolBar(JButton button) {
        this._coolBar.addButton(button);
    }

    public void addComponentToCoolBar(Component component) {
        this._coolBar.addComponent(component);
    }

    public CoolBar getCoolBar() {
        return this._coolBar;
    }

    public void setMainComponent(Component component) {
        if (this._component != null) {
            this.removeMouseListeners(this._component);
            this.remove(this._component);
        }
        this._component = component;
        this.add(this._component, "Center");
        this.addMouseListeners(this._component);
    }

    public Component getMainComponent() {
        return this._component;
    }

    protected void addMouseListeners(Component component) {
        component.addMouseListener(this.mouseListener);
        if (component instanceof Container) {
            Component[] children = ((Container)component).getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addMouseListeners(children[i]);
            }
        }
    }

    protected void removeMouseListeners(Component component) {
        component.removeMouseListener(this.mouseListener);
        if (component instanceof Container) {
            Component[] children = ((Container)component).getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeMouseListeners(children[i]);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._coolBar.setEnabled(enabled);
    }

    public synchronized void addComponentSelectionListener(IComponentSelectionListener listener) {
        if (this._listeners == null) {
            this._listeners = new Vector();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.addElement(listener);
        }
    }

    public synchronized void removeComponentSelectionListener(IComponentSelectionListener listener) {
        if (this._listeners != null) {
            this._listeners.removeElement(listener);
        }
    }

    protected void fireComponentSelected() {
        if (this._listeners != null) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                IComponentSelectionListener listener = (IComponentSelectionListener)this._listeners.elementAt(i);
                listener.componentSelected(this);
            }
        }
    }
}

