/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import uk.ac.reload.dweezil.gui.DweezilInternalFrame;

public class DweezilInternalFrameManager {
    private static int _xpos = -25;
    private static int _ypos = -25;
    private static final int WINDOWGAP = 25;
    private static final double SIZE_FACTOR = 0.9;
    private JDesktopPane _desktop;
    private static Hashtable FileToWindowMAP = new Hashtable();

    public DweezilInternalFrameManager(JDesktopPane desktop) {
        this._desktop = desktop;
    }

    public void addInternalFrame(DweezilInternalFrame frame, boolean autoSize) {
        if (autoSize) {
            int height;
            int width = (int)((double)this._desktop.getWidth() * 0.9);
            if (width < 100) {
                width = 100;
            }
            if ((height = (int)((double)this._desktop.getHeight() * 0.9)) < 100) {
                height = 100;
            }
            if ((_xpos += 25) + width > this._desktop.getWidth() || (_ypos += 25) + height > this._desktop.getHeight()) {
                _xpos = 0;
                _ypos = 0;
            }
            frame.setBounds(_xpos, _ypos, width, height);
        }
        this._desktop.add(frame);
    }

    public void removeInternalFrame(DweezilInternalFrame frame) {
        this._desktop.remove(frame);
        JInternalFrame[] frames = this._desktop.getAllFrames();
        if (frames.length > 0) {
            try {
                frames[frames.length - 1].setSelected(true);
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
        DweezilInternalFrameManager.removeInternalFrameFromWindowMap(frame);
    }

    public void cascade() {
        int height;
        int width = (int)((double)this._desktop.getWidth() * 0.9);
        if (width < 100) {
            width = 100;
        }
        if ((height = (int)((double)this._desktop.getHeight() * 0.9)) < 100) {
            height = 100;
        }
        _xpos = -25;
        _ypos = -25;
        JInternalFrame[] frames = this._desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame f = frames[i];
            if ((_xpos += 25) + width > this._desktop.getWidth() || (_ypos += 25) + height > this._desktop.getHeight()) {
                _xpos = 0;
                _ypos = 0;
            }
            try {
                f.setIcon(false);
                f.setMaximum(false);
                f.setBounds(_xpos, _ypos, width, height);
                f.setSelected(true);
                continue;
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    public void tileVertical() {
        JInternalFrame[] frames = this._desktop.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        int height = this._desktop.getHeight();
        int width = this._desktop.getWidth() / frames.length;
        _xpos = 0;
        _ypos = 0;
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame f = frames[i];
            try {
                f.setIcon(false);
                f.setMaximum(false);
                f.setBounds(_xpos, _ypos, width, height);
                f.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            _xpos += width;
        }
    }

    public void tileHorizontal() {
        JInternalFrame[] frames = this._desktop.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        int height = this._desktop.getHeight() / frames.length;
        int width = this._desktop.getWidth();
        _xpos = 0;
        _ypos = 0;
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame f = frames[i];
            try {
                f.setIcon(false);
                f.setMaximum(false);
                f.setBounds(_xpos, _ypos, width, height);
                f.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            _ypos += height;
        }
    }

    public static DweezilInternalFrame getInternalFrame(File file) {
        if (file == null) {
            return null;
        }
        String key = file.getPath().toLowerCase();
        return (DweezilInternalFrame)FileToWindowMAP.get(key);
    }

    public static void addInternalFrameToWindowMap(File file, DweezilInternalFrame frame) {
        if (file != null && frame != null) {
            DweezilInternalFrameManager.removeInternalFrameFromWindowMap(frame);
            String key = file.getPath().toLowerCase();
            FileToWindowMAP.put(key, frame);
        }
    }

    private static void removeInternalFrameFromWindowMap(DweezilInternalFrame frame) {
        if (frame != null && FileToWindowMAP.contains(frame)) {
            Enumeration e = FileToWindowMAP.keys();
            while (e.hasMoreElements()) {
                String filePath = (String)e.nextElement();
                DweezilInternalFrame f = (DweezilInternalFrame)FileToWindowMAP.get(filePath);
                if (frame != f) continue;
                FileToWindowMAP.remove(filePath);
            }
        }
    }
}

