/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.dweezil.gui.DweezilFileChooser;
import uk.ac.reload.dweezil.gui.DweezilFolderChooser;
import uk.ac.reload.dweezil.util.DweezilUIManager;

public class FileTextField
extends JPanel {
    private JTextField _textField;
    private JButton _buttonFileOpen;
    private Icon _iconFileOpen;
    private DweezilFileChooser _fileChooser;
    private String _text;
    private int _type;
    private File _relativePath;
    public static int FILE_TYPE = 1;
    public static int FOLDER_TYPE = 2;

    public FileTextField(int type, String text, Icon iconFileOpen) {
        this._type = type;
        this._text = text;
        this._iconFileOpen = iconFileOpen;
        this.setup();
    }

    protected void setup() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTextField(), "Center");
        this.add((Component)this.getFileOpenButton(), "East");
        this.setupFileOpenAction();
    }

    protected void setUI() {
        this.setOpaque(false);
    }

    public void updateUI() {
        super.updateUI();
        this.setUI();
    }

    protected void setupFileOpenAction() {
        if (this.getFileOpenButton() != null) {
            this.getFileOpenButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int returnVal;
                    if (FileTextField.this._fileChooser == null) {
                        if (FileTextField.this._type == FILE_TYPE) {
                            FileTextField.this._fileChooser = new DweezilFileChooser();
                        } else {
                            FileTextField.this._fileChooser = new DweezilFolderChooser();
                        }
                        FileTextField.this._fileChooser.setDialogTitle(FileTextField.this._text);
                        FileTextField.this._fileChooser.setApproveButtonText("Select");
                    }
                    if ((returnVal = FileTextField.this._fileChooser.showOpenDialog(null)) == 0) {
                        File file = FileTextField.this._fileChooser.getSelectedFileAndStore();
                        String path = FileTextField.this._relativePath != null && FileTextField.this._relativePath.exists() ? FileUtils.getRelativePath((File)FileTextField.this._relativePath, (File)file) : file.getPath();
                        FileTextField.this.setTextValue(path);
                    }
                }
            });
        }
    }

    public JTextField getTextField() {
        if (this._textField == null) {
            this._textField = new JTextField();
            this._textField.setFont(DweezilUIManager.plainFont11);
        }
        return this._textField;
    }

    public JButton getFileOpenButton() {
        if (this._buttonFileOpen == null) {
            this._buttonFileOpen = new JButton(this._iconFileOpen);
            if (this._iconFileOpen == null) {
                this._buttonFileOpen.setText("...");
            }
        }
        return this._buttonFileOpen;
    }

    public void setTextValue(String value) {
        this.getTextField().setText(value);
    }

    public String getTextValue() {
        return this.getTextField().getText();
    }

    public File getRelativePath() {
        return this._relativePath;
    }

    public void setRelativePath(File relativePath) {
        this._relativePath = relativePath;
    }

    public void setEnabled(boolean enabled) {
        this.getTextField().setEnabled(enabled);
        this.getFileOpenButton().setEnabled(enabled);
    }
}

