/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLLabelTextField
extends JPanel
implements MouseListener,
ActionListener,
FocusListener,
KeyListener {
    public static final String HTML_STRING = "<html>";
    private JLabel _label;
    private JTextField _textField;
    private boolean _editing;
    private String _text;
    private JPanel _textPanel;
    private JLabel _iconLabel;
    private boolean _editable = true;

    public HTMLLabelTextField() {
        this("");
    }

    public HTMLLabelTextField(String text, Icon icon) {
        this(text);
        this.setIcon(icon);
    }

    public HTMLLabelTextField(String text) {
        this.setText(text);
        this.setup();
    }

    protected void setup() {
        this.setLayout(new BorderLayout());
        this.add(this.getLabel());
        this.setUI();
        this.getLabel().addMouseListener(this);
        this.getTextField().addActionListener(this);
        this.getTextField().addFocusListener(this);
        this.getTextField().addKeyListener(this);
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public String getText() {
        String text = this._text;
        if (text.startsWith(HTML_STRING)) {
            text = text.substring(HTML_STRING.length());
        }
        return text;
    }

    public void setText(String text) {
        this._text = text == null ? "" : text;
        if (!this._text.startsWith(HTML_STRING)) {
            this._text = HTML_STRING + this._text;
        }
        if (this.getLabel() != null) {
            this.getLabel().setText(this._text);
            this.revalidate();
        }
    }

    protected void startEdit() {
        if (this.isEditable()) {
            this._editing = true;
            this.remove(this.getLabel());
            this.getTextField().setText(this.getText());
            this.add(this.getTextPanel());
            this.getTextField().requestFocus();
            this.revalidate();
        }
    }

    protected void finishEdit() {
        this._editing = false;
        this.remove(this.getTextPanel());
        this._text = this.validateTextField();
        this.getLabel().setText(this._text);
        this.add(this.getLabel());
        this.revalidate();
        this.repaint();
    }

    protected void cancelEdit() {
        this._editing = false;
        this.remove(this.getTextPanel());
        this.add(this.getLabel());
        this.revalidate();
        this.repaint();
    }

    public boolean isEditing() {
        return this._editing;
    }

    protected void focusLost() {
        if (this.isEditing()) {
            this.finishEdit();
        }
    }

    public JLabel getLabel() {
        if (this._label == null) {
            this._label = new JLabel();
        }
        return this._label;
    }

    public JTextField getTextField() {
        if (this._textField == null) {
            this._textField = new JTextField();
        }
        return this._textField;
    }

    public JPanel getTextPanel() {
        if (this._textPanel == null) {
            this._textPanel = new JPanel();
            this._textPanel.setLayout(new BorderLayout());
            this._textPanel.setOpaque(false);
            this._textPanel.add((Component)this.getIconLabel(), "West");
            this._textPanel.add((Component)this.getTextField(), "Center");
        }
        return this._textPanel;
    }

    public JLabel getIconLabel() {
        if (this._iconLabel == null) {
            this._iconLabel = new JLabel();
        }
        return this._iconLabel;
    }

    public void setFont(Font font) {
        if (this.getLabel() != null) {
            this.getLabel().setFont(font);
        }
        if (this.getTextField() != null) {
            this.getTextField().setFont(font);
        }
    }

    public Font getFont() {
        if (this.getLabel() != null) {
            return this.getLabel().getFont();
        }
        return null;
    }

    public void setIcon(Icon icon) {
        if (this.getLabel() != null) {
            this.getLabel().setIcon(icon);
        }
        if (this.getIconLabel() != null) {
            this.getIconLabel().setIcon(icon);
        }
    }

    protected String validateTextField() {
        String text = this.getTextField().getText();
        text = "".equals(text) ? this._text : HTML_STRING + text;
        return text;
    }

    protected void setUI() {
        this.setOpaque(false);
    }

    public void updateUI() {
        super.updateUI();
        this.setUI();
    }

    public void mouseClicked(MouseEvent e) {
        int clicks = e.getClickCount();
        if (clicks == 2 && e.getButton() == 1) {
            this.startEdit();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        this.finishEdit();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.focusLost();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == '\u001b') {
            this.cancelEdit();
        }
    }
}

