/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.layout;

import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;

public class RelativeLayoutManager {
    private Container _container;
    private RelativeLayout _layout;
    public static final String ROOT_NAME = "_container";
    public static final int BOTTOM = 1;
    public static final int TOP = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int HEIGHT = 5;
    public static final int WIDTH = 6;
    public static final int HORIZONTAL_CENTER = 7;
    public static final int VERTICAL_CENTER = 8;

    public RelativeLayoutManager(Container container) {
        this._container = container;
        this._layout = new RelativeLayout();
        this._container.setLayout(this._layout);
    }

    public RelativeLayout getLayout() {
        return this._layout;
    }

    public void setWidth(String componentName, int width) {
        this._layout.addConstraint(componentName, AttributeType.WIDTH, new AttributeConstraint(componentName, AttributeType.LEFT, width));
    }

    public void setHeight(String componentName, int height) {
        this._layout.addConstraint(componentName, AttributeType.HEIGHT, new AttributeConstraint(componentName, AttributeType.TOP, height));
    }

    public void removeLayoutComponent(Component component) {
        this._layout.removeLayoutComponent(component);
    }

    public void addFromRightEdgeComponent(JComponent component, String componentName, String anchorName, int verticalConstraint, int topOffset, int leftOffset) {
        this._container.add((Component)component, componentName);
        AttributeType attType = this.getAttributeType(verticalConstraint);
        this._layout.addConstraint(componentName, AttributeType.TOP, new AttributeConstraint(anchorName, attType, topOffset));
        this._layout.addConstraint(componentName, AttributeType.LEFT, new AttributeConstraint(anchorName, AttributeType.RIGHT, leftOffset));
    }

    public void addFromLeftEdge(JComponent component, String componentName, String anchorName, int verticalConstraint, int topOffset, int leftOffset) {
        this._container.add((Component)component, componentName);
        AttributeType attType = this.getAttributeType(verticalConstraint);
        this._layout.addConstraint(componentName, AttributeType.TOP, new AttributeConstraint(anchorName, attType, topOffset));
        this._layout.addConstraint(componentName, AttributeType.LEFT, new AttributeConstraint(ROOT_NAME, AttributeType.LEFT, leftOffset));
    }

    public void addFromLeftToRightEdges(JComponent component, String componentName, String anchorName, int verticalConstraint, int topOffset, int leftOffset) {
        this.addFromLeftEdge(component, componentName, anchorName, verticalConstraint, topOffset, leftOffset);
        this._layout.addConstraint(componentName, AttributeType.RIGHT, new AttributeConstraint(ROOT_NAME, AttributeType.RIGHT));
    }

    public void addFromRightEdge(JComponent component, String componentName, String anchorName, int verticalConstraint, int topOffset, int rightOffset) {
        this._container.add((Component)component, componentName);
        AttributeType attType = this.getAttributeType(verticalConstraint);
        this._layout.addConstraint(componentName, AttributeType.TOP, new AttributeConstraint(anchorName, attType, topOffset));
        this._layout.addConstraint(componentName, AttributeType.RIGHT, new AttributeConstraint(ROOT_NAME, AttributeType.RIGHT, rightOffset));
    }

    public void addToCenter(JComponent component, String componentName, String anchorName, int verticalConstraint, int topOffset, int leftOffset) {
        this._container.add((Component)component, componentName);
        AttributeType attType = this.getAttributeType(verticalConstraint);
        this._layout.addConstraint(componentName, AttributeType.TOP, new AttributeConstraint(anchorName, attType, topOffset));
        this._layout.addConstraint(componentName, AttributeType.HORIZONTAL_CENTER, new AttributeConstraint(ROOT_NAME, AttributeType.HORIZONTAL_CENTER, leftOffset));
    }

    public AttributeType getAttributeType(int type) {
        switch (type) {
            case 1: {
                return AttributeType.BOTTOM;
            }
            case 2: {
                return AttributeType.TOP;
            }
            case 3: {
                return AttributeType.LEFT;
            }
            case 4: {
                return AttributeType.RIGHT;
            }
            case 5: {
                return AttributeType.HEIGHT;
            }
            case 6: {
                return AttributeType.WIDTH;
            }
            case 7: {
                return AttributeType.HORIZONTAL_CENTER;
            }
            case 8: {
                return AttributeType.VERTICAL_CENTER;
            }
        }
        throw new IllegalStateException("AttributeType not known: " + type);
    }

    public Container get_container() {
        return this._container;
    }
}

