/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.Serializable;

public class SGLayout
implements LayoutManager,
Serializable {
    public static int LEFT = 0;
    public static int CENTER = 1;
    public static int RIGHT = 2;
    public static int FILL = 4;
    public static int TOP = 8;
    public static int BOTTOM = 16;
    protected int rows;
    protected int cols;
    protected int vgap;
    protected int hgap;
    protected int topBorder = 0;
    protected int leftBorder = 0;
    protected int bottomBorder = 0;
    protected int rightBorder = 0;
    protected int minW = 10;
    protected int minH = 10;
    protected double[] rowScale;
    protected double[] columnScale;
    protected int hAlignment = FILL;
    protected int vAlignment = FILL;
    protected int[][] hAlignments;
    protected int[][] vAlignments;
    protected int[] rowSizes;
    protected int[] columnSizes;

    public SGLayout() {
        this(2, 2, FILL, FILL, 0, 0);
    }

    public SGLayout(int rows, int cols) {
        this(rows, cols, FILL, FILL, 0, 0);
    }

    public SGLayout(int rows, int cols, int hgap, int vgap) {
        this(rows, cols, FILL, FILL, hgap, vgap);
    }

    public SGLayout(int rows, int cols, int hAlignment, int vAlignment, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.hAlignment = hAlignment;
        this.vAlignment = vAlignment;
        this.setDimensions(rows, cols);
    }

    private void setScaleValues() {
        this.rowScale = new double[this.rows];
        this.columnScale = new double[this.cols];
        for (int i = 0; i < this.rows; ++i) {
            this.rowScale[i] = 1.0;
        }
        for (int j = 0; j < this.cols; ++j) {
            this.columnScale[j] = 1.0;
        }
    }

    private void setAlignments() {
        this.hAlignments = new int[this.rows][this.cols];
        this.vAlignments = new int[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.hAlignments[i][j] = this.hAlignment;
                this.vAlignments[i][j] = this.vAlignment;
            }
        }
    }

    private void setDimensions(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.setScaleValues();
        this.setAlignments();
    }

    public void setMargins(int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        this.topBorder = topBorder;
        this.leftBorder = leftBorder;
        this.bottomBorder = bottomBorder;
        this.rightBorder = rightBorder;
    }

    public void setRowScale(int index, double prop) {
        if (index >= 0 && index < this.rows) {
            this.rowScale[index] = prop;
        }
    }

    public void setColumnScale(int index, double prop) {
        if (index >= 0 && index < this.cols) {
            this.columnScale[index] = prop;
        }
    }

    public void setAlignment(int row, int column, int h, int v) {
        if (row < this.rows && column < this.cols) {
            this.hAlignments[row][column] = h;
            this.vAlignments[row][column] = v;
        }
    }

    public void setRowAlignment(int row, int h, int v) {
        if (row < this.rows) {
            for (int column = 0; column < this.cols; ++column) {
                this.hAlignments[row][column] = h;
                this.vAlignments[row][column] = v;
            }
        }
    }

    public void setColumnAlignment(int column, int h, int v) {
        if (column < this.cols) {
            for (int row = 0; row < this.rows; ++row) {
                this.hAlignments[row][column] = h;
                this.vAlignments[row][column] = v;
            }
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int totalWidth = 0;
            int totalHeight = 0;
            for (int i = 0; i < nrows; ++i) {
                int prefWidth = 0;
                int prefHeight = 0;
                for (int j = 0; j < ncols; ++j) {
                    int index = i * ncols + j;
                    if (index >= ncomponents) continue;
                    Component comp = parent.getComponent(index);
                    Dimension d = comp.getPreferredSize();
                    prefWidth = d.width < this.minW ? (prefWidth += this.minW) : (prefWidth += d.width);
                    if (d.height <= prefHeight) continue;
                    prefHeight = d.height;
                }
                if (prefWidth > totalWidth) {
                    totalWidth = prefWidth;
                }
                totalHeight += prefHeight;
            }
            return new Dimension(totalWidth + this.leftBorder + this.rightBorder + (ncols - 1) * this.hgap, totalHeight + this.topBorder + this.bottomBorder + (nrows - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int totalWidth = 0;
            int totalHeight = 0;
            for (int i = 0; i < nrows; ++i) {
                int minWidth = 0;
                int minHeight = 0;
                for (int j = 0; j < ncols; ++j) {
                    int index = i * ncols + j;
                    if (index >= ncomponents) continue;
                    Component comp = parent.getComponent(index);
                    Dimension d = comp.getMinimumSize();
                    int width = d.width;
                    if (width < this.minW) {
                        width = this.minW;
                    }
                    minWidth += width;
                    if (minHeight <= d.height) continue;
                    minHeight = d.height;
                }
                if (totalWidth > minWidth) {
                    totalWidth = minWidth;
                }
                if (minHeight < this.minH) {
                    minHeight = this.minH;
                }
                totalHeight += minHeight;
            }
            return new Dimension(totalWidth + this.leftBorder + this.rightBorder + (ncols - 1) * this.hgap, totalHeight + this.topBorder + this.bottomBorder + (nrows - 1) * this.vgap);
        }
    }

    public void layoutContainer(Container parent) {
        int maxWidth = parent.getSize().width - this.leftBorder - this.rightBorder;
        int maxHeight = parent.getSize().height - this.topBorder - this.bottomBorder;
        int nComps = parent.getComponentCount();
        boolean previousWidth = false;
        boolean previousHeight = false;
        int y = this.topBorder;
        boolean rowh = false;
        boolean start = false;
        Dimension d = new Dimension(60, 30);
        this.allocateMaxSizes(parent);
        for (int i = 0; i < this.rows; ++i) {
            int x = this.leftBorder;
            for (int j = 0; j < this.cols; ++j) {
                int componentIndex = i * this.cols + j;
                if (componentIndex > nComps - 1) continue;
                Component c = parent.getComponent(componentIndex);
                if (c.isVisible()) {
                    this.setComponentBounds(c, i, j, x, y);
                }
                x += this.columnSizes[j] + this.hgap;
            }
            y += this.rowSizes[i] + this.vgap;
        }
    }

    void setComponentBounds(Component c, int row, int column, int left, int top) {
        int ySpace;
        Dimension d = c.getPreferredSize();
        int finalWidth = this.columnSizes[column];
        int finalHeight = this.rowSizes[row];
        int xSpace = finalWidth - d.width;
        if (xSpace > 0) {
            int alignment = this.hAlignments[row][column];
            if (alignment == RIGHT) {
                left += xSpace;
            } else if (alignment == CENTER) {
                left += xSpace / 2;
            }
            if (alignment != FILL) {
                finalWidth = d.width;
            }
        }
        if ((ySpace = finalHeight - d.height) > 0) {
            int vAlignment = this.vAlignments[row][column];
            if (vAlignment == BOTTOM) {
                top += ySpace;
            } else if (vAlignment == CENTER) {
                top += ySpace / 2;
            }
            if (vAlignment != FILL) {
                finalHeight = d.height;
            }
        }
        c.setBounds(left, top, finalWidth, finalHeight);
    }

    protected void allocateMaxSizes(Container parent) {
        this.rowSizes = new int[this.rows];
        this.columnSizes = new int[this.cols];
        Dimension thisSize = parent.getSize();
        int width = thisSize.width - this.leftBorder - this.rightBorder - (this.cols - 1) * this.hgap;
        int height = thisSize.height - this.topBorder - this.bottomBorder - (this.rows - 1) * this.vgap;
        double totalRowProps = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            totalRowProps += this.rowScale[i];
        }
        double totalColumnProps = 0.0;
        for (int j = 0; j < this.cols; ++j) {
            totalColumnProps += this.columnScale[j];
        }
        for (int p = 0; p < this.rows; ++p) {
            this.rowSizes[p] = (int)(this.rowScale[p] * (double)height / totalRowProps);
        }
        for (int q = 0; q < this.cols; ++q) {
            this.columnSizes[q] = (int)(this.columnScale[q] * (double)width / totalColumnProps);
        }
    }
}

