/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.tree;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeModel;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;

public class DweezilTree
extends JTree
implements Autoscroll {
    protected boolean isRootPath(TreePath path) {
        return this.isRootVisible() && this.getRowForPath(path) == 0;
    }

    public synchronized DweezilTreeNode selectNodeByObject(Object anObject) {
        if (anObject == null) {
            return null;
        }
        DweezilTreeNode node = this.getNode(anObject);
        this.selectNode(node);
        return node;
    }

    public synchronized void selectNode(final DefaultMutableTreeNode node) {
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreePath path = new TreePath(node.getPath());
                    DweezilTree.this.scrollPathToVisible(path);
                    DweezilTree.this.setSelectionPath(path);
                }
            });
        }
    }

    public void selectRootNode() {
        DweezilTreeModel treeModel = (DweezilTreeModel)this.getModel();
        if (treeModel != null) {
            DweezilTreeNode node = treeModel.getRootNode();
            this.selectNode(node);
        }
    }

    public void selectFirstNode() {
        DweezilTreeNode rootNode;
        DweezilTreeModel treeModel = (DweezilTreeModel)this.getModel();
        if (treeModel != null && (rootNode = treeModel.getRootNode()) != null && rootNode.getChildCount() > 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(0);
            this.selectNode(node);
        }
    }

    public DweezilTreeNode getSelectedNode() {
        TreePath selPath = this.getSelectionPath();
        return selPath == null ? null : (DweezilTreeNode)selPath.getLastPathComponent();
    }

    public DweezilTreeNode[] getSelectedNodes() {
        TreePath[] selPaths = this.getSelectionPaths();
        if (selPaths == null) {
            return null;
        }
        Vector<DweezilTreeNode> v = new Vector<DweezilTreeNode>();
        for (int i = 0; i < selPaths.length; ++i) {
            DweezilTreeNode node = (DweezilTreeNode)selPaths[i].getLastPathComponent();
            v.add(node);
        }
        Object[] nodes = new DweezilTreeNode[v.size()];
        v.copyInto(nodes);
        return nodes;
    }

    public DweezilTreeNode getNode(Object object) {
        if (object == null) {
            return null;
        }
        Enumeration nodes = this.getNodes();
        if (nodes != null) {
            while (nodes.hasMoreElements()) {
                DweezilTreeNode node = (DweezilTreeNode)nodes.nextElement();
                Object o = node.getUserObject();
                if (!object.equals(o)) continue;
                return node;
            }
        }
        return null;
    }

    public Enumeration getNodes() {
        DweezilTreeModel treeModel = (DweezilTreeModel)this.getModel();
        if (treeModel == null) {
            return null;
        }
        DweezilTreeNode rootNode = treeModel.getRootNode();
        if (rootNode == null) {
            return null;
        }
        return rootNode.preorderEnumeration();
    }

    public void expandNode(Object anObject, boolean expand) {
        DweezilTreeNode node = this.getNode(anObject);
        this.expandNode(node, expand);
    }

    public void expandNode(DefaultMutableTreeNode node, boolean expand) {
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            int row = this.getRowForPath(path);
            if (row >= 0) {
                if (expand) {
                    this.expandRow(row);
                } else {
                    this.collapseRow(row);
                }
            } else if (expand) {
                this.expandPath(path);
            } else {
                this.collapsePath(path);
            }
        }
    }

    public void scrollNodeToVisible(DefaultMutableTreeNode node) {
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.scrollPathToVisible(path);
        }
    }

    public void updateSelectedNode() {
        this.updateNode(this.getSelectedNode());
    }

    public void updateNode(DweezilTreeNode node) {
        DweezilTreeModel treeModel = (DweezilTreeModel)this.getModel();
        if (treeModel != null) {
            treeModel.nodeChanged(node);
        }
    }

    public void updateNodes() {
        Enumeration nodes = this.getNodes();
        if (nodes != null) {
            while (nodes.hasMoreElements()) {
                DweezilTreeNode node = (DweezilTreeNode)nodes.nextElement();
                this.updateNode(node);
            }
        }
    }

    public void expandTree(boolean expand) {
        DweezilTreeModel treeModel = (DweezilTreeModel)this.getModel();
        if (treeModel != null) {
            DweezilTreeNode rootNode = treeModel.getRootNode();
            if (rootNode == null) {
                return;
            }
            Enumeration<TreeNode> nodes = expand ? rootNode.preorderEnumeration() : rootNode.postorderEnumeration();
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode theNode = (DefaultMutableTreeNode)nodes.nextElement();
                this.expandNode(theNode, expand);
            }
        }
    }

    public Insets getAutoscrollInsets() {
        Rectangle r = this.getVisibleRect();
        Dimension s = this.getSize();
        Insets insets = new Insets(r.y + 50, r.x, s.height - r.y - r.height + 50, s.width - r.x - r.width);
        return insets;
    }

    public void autoscroll(Point cursorLocn) {
        Rectangle v = this.getVisibleRect();
        int y = cursorLocn.y < v.y + 50 ? cursorLocn.y - 40 : cursorLocn.y;
        Rectangle r = new Rectangle(0, y, this.getVisibleRect().width, 40);
        this.scrollRectToVisible(r);
    }
}

