/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.tree;

import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.dnd.DNDUtils;
import uk.ac.reload.dweezil.dnd.JTreeDragDropHandler;
import uk.ac.reload.dweezil.gui.tree.DweezilTree;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;

public abstract class DweezilTreeDragDropHandler
extends JTreeDragDropHandler {
    protected DweezilTreeNode _prevHilitedNode;
    private TreePath _pathLast;
    private Timer _timerHover;

    protected DweezilTreeDragDropHandler(DweezilTree tree) {
        super(tree);
        final DweezilTree ftree = tree;
        this._timerHover = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ftree.isRootPath(DweezilTreeDragDropHandler.this._pathLast)) {
                    return;
                }
                if (ftree.isCollapsed(DweezilTreeDragDropHandler.this._pathLast)) {
                    ftree.expandPath(DweezilTreeDragDropHandler.this._pathLast);
                }
            }
        });
        this._timerHover.setRepeats(false);
    }

    protected void hiliteNode(DweezilTreeNode node, boolean hilite) {
        if (node == null) {
            return;
        }
        if (this._prevHilitedNode != null && node != this._prevHilitedNode) {
            this._prevHilitedNode.isHiLited = false;
        }
        if (node.isHiLited != hilite) {
            node.isHiLited = hilite;
            this.getTree().repaint();
            this._prevHilitedNode = node;
        }
    }

    public void dragExit(DragSourceEvent event) {
        DragSourceContext context = event.getDragSourceContext();
        context.setCursor(DragSource.DefaultCopyNoDrop);
        this.hiliteNode(this._prevHilitedNode, false);
    }

    public void dropActionChanged(DragSourceDragEvent event) {
    }

    public void dragOver(DragSourceDragEvent event) {
    }

    public void dragEnter(DragSourceDragEvent event) {
        DragSourceContext context = event.getDragSourceContext();
        int action = event.getDropAction();
        if ((action & 1) != 0) {
            context.setCursor(DragSource.DefaultCopyDrop);
        } else if ((action & 2) != 0) {
            context.setCursor(DragSource.DefaultMoveDrop);
        } else {
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    public void dragDropEnd(DragSourceDropEvent event) {
        this.hiliteNode(this._prevHilitedNode, false);
    }

    public void dragEnter(DropTargetDragEvent event) {
        if (this.isDropOK(event)) {
            event.acceptDrag(DNDUtils.getCorrectDropContext(event));
        } else {
            event.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent event) {
        boolean ok = this.isDropOK(event);
        if (ok) {
            event.acceptDrag(DNDUtils.getCorrectDropContext(event));
            DweezilTreeNode node = (DweezilTreeNode)this.getDragOverTreeNode(event);
            this.hiliteNode(node, true);
        } else {
            event.rejectDrag();
        }
        Point pt = event.getLocation();
        TreePath path = this.getTree().getClosestPathForLocation(pt.x, pt.y);
        if (path != this._pathLast) {
            this._pathLast = path;
            this._timerHover.restart();
        }
    }

    public void dragExit(DropTargetEvent event) {
        this.hiliteNode(this._prevHilitedNode, false);
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        if (this.isDropOK(event)) {
            event.acceptDrag(DNDUtils.getCorrectDropContext(event));
        } else {
            event.rejectDrag();
        }
    }

    public void drop(DropTargetDropEvent event) {
    }

    public void dragGestureRecognized(DragGestureEvent event) {
    }
}

