/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DweezilTreePopupHandler {
    private JTree _tree;
    private JPopupMenu _popupMenu;

    public DweezilTreePopupHandler(JTree tree) {
        this._tree = tree;
        tree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                DweezilTreePopupHandler.this.checkPopupTrigger(e);
            }

            public void mousePressed(MouseEvent e) {
                DweezilTreePopupHandler.this.checkPopupTrigger(e);
            }
        });
    }

    protected void checkPopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger()) {
            TreePath selPath = this.getTree().getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            this.getTree().setSelectionPath(selPath);
            this._popupMenu.show(this.getTree(), e.getX(), e.getY());
        }
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this._popupMenu = popupMenu;
    }

    public JPopupMenu getPopupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
        }
        return this._popupMenu;
    }

    public JTree getTree() {
        return this._tree;
    }
}

