/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.treetable;

import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.treetable.JTreeTable;
import uk.ac.reload.dweezil.gui.treetable.TreeTableModel;

public class DweezilTreeTable
extends JTreeTable {
    public DweezilTreeTable() {
    }

    public DweezilTreeTable(TreeTableModel treeTableModel) {
        super(treeTableModel);
    }

    public void tableChanged(TableModelEvent e) {
        this.revalidate();
        super.tableChanged(e);
    }

    public synchronized void selectNode(final DefaultMutableTreeNode node) {
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreePath path = new TreePath(node.getPath());
                    DweezilTreeTable.this.getTree().setSelectionPath(path);
                    Rectangle bounds = DweezilTreeTable.this.getCellRect(DweezilTreeTable.this.getTree().getRowForPath(path), 0, true);
                    DweezilTreeTable.this.scrollRectToVisible(bounds);
                    DweezilTreeTable.this.getTree().setSelectionPath(path);
                }
            });
        }
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath selPath = this.getTree().getSelectionPath();
        if (selPath != null) {
            return (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    public void updateSelectedNode() {
        DefaultMutableTreeNode node;
        if (this.getTreeTableModel() instanceof DefaultTreeModel && (node = this.getSelectedNode()) != null) {
            ((DefaultTreeModel)((Object)this.getTreeTableModel())).nodeChanged(node);
        }
    }

    public DefaultMutableTreeNode getNode(Object object) {
        if (object == null) {
            return null;
        }
        if (this.getTreeTableModel() instanceof DefaultTreeModel) {
            Enumeration<TreeNode> nodes = ((DefaultMutableTreeNode)((DefaultTreeModel)((Object)this.getTreeTableModel())).getRoot()).preorderEnumeration();
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
                Object o = node.getUserObject();
                if (!object.equals(o)) continue;
                return node;
            }
        }
        return null;
    }
}

