/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.treetable;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.treetable.JTreeTable;

public class DweezilTreeTablePopupHandler {
    private JTreeTable _treeTable;
    private JPopupMenu _popupMenu;

    public DweezilTreeTablePopupHandler(JTreeTable treeTable) {
        this._treeTable = treeTable;
        treeTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                DweezilTreeTablePopupHandler.this.checkPopupTrigger(e);
            }

            public void mousePressed(MouseEvent e) {
                DweezilTreeTablePopupHandler.this.checkPopupTrigger(e);
            }
        });
    }

    protected void checkPopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger()) {
            TreePath selPath = this.getTreeTable().getTree().getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            this.getTreeTable().getTree().setSelectionPath(selPath);
            this._popupMenu.show(this.getTreeTable(), e.getX(), e.getY());
        }
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this._popupMenu = popupMenu;
    }

    public JPopupMenu getPopupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
        }
        return this._popupMenu;
    }

    public JTreeTable getTreeTable() {
        return this._treeTable;
    }
}

