/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.treetable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import uk.ac.reload.dweezil.gui.tree.DweezilTree;
import uk.ac.reload.dweezil.gui.treetable.AbstractCellEditor;
import uk.ac.reload.dweezil.gui.treetable.TreeTableModel;
import uk.ac.reload.dweezil.gui.treetable.TreeTableModelAdapter;

public class JTreeTable
extends JTable {
    private JTree _tree;

    public JTreeTable() {
    }

    public JTreeTable(TreeTableModel treeTableModel) {
        this.setTreeTableModel(treeTableModel);
    }

    public void setTreeTableModel(TreeTableModel treeTableModel) {
        this.getTree().setModel(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.getTree()));
        this.getTree().setSelectionModel(new DefaultTreeSelectionModel(){
            {
                JTreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.getTree().setRowHeight(this.getRowHeight());
        this.setDefaultRenderer(TreeTableModel.class, (TableCellRenderer)((Object)this.getTree()));
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.getTree().getModel();
    }

    public void updateUI() {
        super.updateUI();
        if (this.getTree() != null) {
            this.getTree().updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.getTree() != null && this.getTree().getRowHeight() != rowHeight) {
            this.getTree().setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        if (this._tree == null) {
            this._tree = new DweezilTableTree();
        }
        return this._tree;
    }

    public void tableChanged(TableModelEvent e) {
        this.revalidate();
        this.repaint();
        super.tableChanged(e);
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.getTree();
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    MouseEvent newME = new MouseEvent(JTreeTable.this.getTree(), me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.getTree().dispatchEvent(newME);
                    newME = new MouseEvent(JTreeTable.this.getTree(), 502, me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.getTree().dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }
    }

    public class DweezilTableTree
    extends DweezilTree
    implements TableCellRenderer {
        protected int visibleRow;

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }
}

