/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import uk.ac.reload.diva.util.GeneralUtils;
import uk.ac.reload.dweezil.util.OSXApplication;

public final class DweezilUIManager {
    private static final DweezilUIManager INSTANCE = new DweezilUIManager();
    public static Cursor TEXT_CURSOR = Cursor.getPredefinedCursor(2);
    public static Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    public static Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    public static Font plainFont11 = new Font("SansSerif", 0, 11);
    public static Font boldFont11 = new Font("SansSerif", 1, 11);
    public static Font italicFont11 = new Font("SansSerif", 2, 11);
    public static Font bold_italicFont11 = new Font("SansSerif", 3, 11);
    public static Font plainFont12 = new Font("SansSerif", 0, 12);
    public static Font boldFont12 = new Font("SansSerif", 1, 12);
    public static Font italicFont12 = new Font("SansSerif", 2, 12);
    public static Font bold_italicFont12 = new Font("SansSerif", 3, 12);
    public static Font plainFont13 = new Font("SansSerif", 0, 13);
    public static Font boldFont13 = new Font("SansSerif", 1, 13);
    public static Font italicFont13 = new Font("SansSerif", 2, 13);
    public static Font bold_italicFont13 = new Font("SansSerif", 3, 13);
    public static Font plainFont14 = new Font("SansSerif", 0, 14);
    public static Font boldFont14 = new Font("SansSerif", 1, 14);
    private static Hashtable icons = new Hashtable();

    private DweezilUIManager() {
    }

    public static void setMacUIDefaults(String applicationName, OSXApplication app) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", applicationName);
        System.setProperty("apple.awt.showGrowBox", "true");
        INSTANCE.macOSXRegistration(app);
    }

    public void macOSXRegistration(OSXApplication app) {
        if (GeneralUtils.getOS() == 0) {
            try {
                Class<?> osxAdapter = Class.forName("uk.ac.reload.dweezil.util.OSXAdapter");
                Class[] defArgs = new Class[]{OSXApplication.class};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                Object[] args = new Object[]{app};
                registerMethod.invoke(osxAdapter, args);
                defArgs[0] = Boolean.TYPE;
                Method prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
                Object[] args2 = new Object[]{Boolean.TRUE};
                prefsEnableMethod.invoke(osxAdapter, args2);
            }
            catch (NoClassDefFoundError e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (ClassNotFoundException e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (Exception e) {
                System.err.println("Exception while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public static void setLookAndFeel(String className, Component[] components) {
        try {
            UIManager.setLookAndFeel(className);
            DweezilUIManager.updateComponentTreeUI(components);
        }
        catch (Exception ex) {
            try {
                String lf = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(lf);
                DweezilUIManager.updateComponentTreeUI(components);
            }
            catch (Exception ex1) {
                System.out.println("Error loading L&F: " + ex);
            }
        }
    }

    private static void updateComponentTreeUI(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            SwingUtilities.updateComponentTreeUI(components[i]);
        }
    }

    public static ImageIcon getIcon(String iconPath) {
        URL url;
        ImageIcon imageIcon = (ImageIcon)icons.get(iconPath);
        if (imageIcon == null && (url = INSTANCE.getClass().getClassLoader().getResource(iconPath)) != null) {
            imageIcon = new ImageIcon(url);
            icons.put(iconPath, imageIcon);
        }
        return imageIcon;
    }

    public static Image getImage(String imagePath) {
        ImageIcon imageIcon = DweezilUIManager.getIcon(imagePath);
        if (imageIcon != null) {
            return imageIcon.getImage();
        }
        return null;
    }
}

