/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JInternalFrame;

public final class UIUtils {
    public static void centreWindowProportional(Window window, double width, double height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenSize.width / 2;
        int screenHeight = screenSize.height / 2;
        int newWidth = (int)((double)screenSize.width * width);
        int newHeight = (int)((double)screenSize.height * height);
        window.setSize(newWidth, newHeight);
        window.setLocation(screenWidth - newWidth / 2, screenHeight - newHeight / 2);
    }

    public static void centreWindow(Window window, int width, int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenSize.width / 2;
        int screenHeight = screenSize.height / 2;
        window.setSize(width, height);
        window.setLocation(screenWidth - width / 2, screenHeight - height / 2);
    }

    public static int getScreenWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().width;
    }

    public static int getScreenHeight() {
        return Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    public static JInternalFrame getInternalFrameAncestor(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JInternalFrame) {
            return (JInternalFrame)c;
        }
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JInternalFrame)) continue;
            return (JInternalFrame)p;
        }
        return null;
    }

    public static Frame getFrameAncestor(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof Frame) {
            return (Frame)c;
        }
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static boolean isComponentInMainFrame(Component c) {
        return !UIUtils.isComponentInInternalFrame(c);
    }

    public static boolean isComponentInInternalFrame(Component c) {
        JInternalFrame frame = UIUtils.getInternalFrameAncestor(c);
        return frame != null;
    }
}

